/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component2.form4;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.binding.IBindingConverter;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component2.controlfactory.ControlCreatorRegistry;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.Label;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.server.DomApplication;
import to.etc.webapp.annotations.GProperty;

public final class FormBuilder {
    @Nonnull
    private final IAppender m_appender;
    private boolean m_horizontal;
    private boolean m_currentDirection;
    private String m_nextLabel;
    private String m_errorLocation;
    private Label m_nextLabelControl;
    private PropertyMetaModel<?> m_propertyMetaModel;
    private Object m_instance;
    private Boolean m_mandatory;
    private boolean m_append;
    private Boolean m_readOnly;
    private NodeBase m_lastAddedControl;
    @Nullable
    private String m_controlCss;
    @Nullable
    private String m_labelCss;
    @Nullable
    private IBindingConverter<?, ?> m_bindingConverter;
    private Table m_table;
    private TBody m_body;
    private TR m_labelRow;
    private TR m_controlRow;

    public FormBuilder(@Nonnull IAppender appender) {
        this.m_appender = appender;
    }

    public FormBuilder(final @Nonnull NodeContainer nb) {
        this(new IAppender(){

            @Override
            public void add(NodeBase formNode) {
                nb.add(formNode);
            }
        });
    }

    @Nonnull
    public FormBuilder append() {
        this.m_append = true;
        return this;
    }

    @Nonnull
    public FormBuilder horizontal() {
        this.m_horizontal = true;
        return this;
    }

    @Nonnull
    public FormBuilder vertical() {
        this.m_horizontal = false;
        return this;
    }

    @Nonnull
    public FormBuilder label(@Nonnull String label) {
        if (null != this.m_nextLabelControl) {
            throw new IllegalStateException("You already set a Label instance");
        }
        this.m_nextLabel = label;
        return this;
    }

    @Nonnull
    public FormBuilder label(@Nonnull Label label) {
        if (null != this.m_nextLabel) {
            throw new IllegalStateException("You already set a String label instance");
        }
        this.m_nextLabelControl = label;
        return this;
    }

    @Nonnull
    public FormBuilder errorLocation(@Nonnull String errorLocation) {
        this.m_errorLocation = errorLocation;
        return this;
    }

    @Nonnull
    public FormBuilder unlabeled() {
        this.label("");
        return this;
    }

    @Nonnull
    public FormBuilder readOnly() {
        this.m_readOnly = Boolean.TRUE;
        return this;
    }

    @Nonnull
    public FormBuilder readOnly(boolean ro) {
        this.m_readOnly = ro;
        return this;
    }

    @Nonnull
    public FormBuilder mandatory() {
        this.m_mandatory = Boolean.TRUE;
        return this;
    }

    @Nonnull
    public FormBuilder mandatory(boolean yes) {
        this.m_mandatory = yes;
        return this;
    }

    public void control(@Nonnull IControl<?> control) throws Exception {
        if (control.isMandatory()) {
            this.m_mandatory = Boolean.TRUE;
        }
        this.addControl((NodeBase)((Object)control));
        this.resetBuilder();
    }

    @Nonnull
    public <T> IControl<?> control() throws Exception {
        return this.control((Class)null);
    }

    @Nonnull
    public <T, C extends IControl<T>> C control(@Nullable Class<C> controlClass) throws Exception {
        ControlCreatorRegistry builder = DomApplication.get().getControlCreatorRegistry();
        PropertyMetaModel<?> pmm = this.m_propertyMetaModel;
        if (null == pmm) {
            throw new IllegalStateException("You must have called 'property(...)' before");
        }
        C control = builder.createControl(pmm, controlClass);
        this.bindControlData(control, pmm);
        this.addControl((NodeBase)control);
        this.resetBuilder();
        return control;
    }

    @Nonnull
    public FormBuilder converter(@Nonnull IBindingConverter<?, ?> converter) {
        this.m_bindingConverter = converter;
        return this;
    }

    @Nonnull
    public FormBuilder cssControl(@Nonnull String cssClass) {
        this.m_controlCss = cssClass;
        return this;
    }

    @Nonnull
    public FormBuilder cssLabel(@Nonnull String cssClass) {
        this.m_labelCss = cssClass;
        return this;
    }

    public void item(@Nonnull NodeBase item) throws Exception {
        this.addControl(item);
        this.resetBuilder();
    }

    public <T, C extends IControl<T>> void bindControlData(@Nonnull C control, @Nonnull PropertyMetaModel<T> pmm) throws Exception {
    }

    @Nonnull
    public <T> FormBuilder property(@Nonnull T instance, @GProperty String property) {
        if (null != this.m_propertyMetaModel) {
            throw new IllegalStateException("You need to end the builder pattern with a call to 'control()'");
        }
        this.m_propertyMetaModel = MetaManager.getPropertyMeta(instance.getClass(), property);
        this.m_instance = instance;
        return this;
    }

    private void resetBuilder() {
        this.m_readOnly = null;
        this.m_instance = null;
        this.m_propertyMetaModel = null;
        this.m_append = false;
        this.m_mandatory = null;
        this.m_nextLabel = null;
        this.m_nextLabelControl = null;
        this.m_controlCss = null;
        this.m_labelCss = null;
        this.m_errorLocation = null;
        this.m_bindingConverter = null;
    }

    private void addControl(@Nonnull NodeBase control) throws Exception {
        if (control.getClass().getSimpleName().contains("TextArea") && this.m_labelCss == null) {
            this.m_labelCss = "ui-f4-ta";
        }
        this.resetDirection();
        if (this.m_horizontal) {
            this.addHorizontal(control);
        } else {
            this.addVertical(control);
        }
        if (control instanceof IControl) {
            Object instance;
            IControl ctl = (IControl)((Object)control);
            PropertyMetaModel<?> pmm = this.m_propertyMetaModel;
            if (null != pmm && null != (instance = this.m_instance)) {
                ((NodeBase)((Object)ctl)).bind().convert(this.m_bindingConverter).to(instance, pmm);
            }
            if (this.isReadOnly()) {
                ctl.setReadOnly(true);
            }
            if (this.isMandatory()) {
                ctl.setMandatory(true);
            }
        }
        String label = this.labelTextCalculated();
        this.m_lastAddedControl = control;
        if (null != this.m_errorLocation) {
            control.setErrorLocation(this.m_errorLocation);
        } else if (null != label) {
            control.setErrorLocation(label);
        }
        if (null != label) {
            control.setCalculcatedId(label.toLowerCase());
        }
    }

    private void resetDirection() {
        if (this.m_horizontal == this.m_currentDirection) {
            return;
        }
        this.clearTable();
        this.m_currentDirection = this.m_horizontal;
    }

    public FormBuilder nl() {
        this.clearTable();
        return this;
    }

    private void clearTable() {
        this.m_table = null;
        this.m_body = null;
        this.m_labelRow = null;
        this.m_controlRow = null;
    }

    @Nonnull
    public TBody body() {
        if (this.m_body == null) {
            Table tbl = this.m_table = new Table();
            this.m_appender.add(tbl);
            tbl.setCssClass(this.m_horizontal ? "ui-f4 ui-f4-h" : "ui-f4 ui-f4-v");
            tbl.setCellPadding("0");
            tbl.setCellSpacing("0");
            TBody b = this.m_body = new TBody();
            tbl.add(b);
            return b;
        }
        return this.m_body;
    }

    private void addVertical(NodeBase control) {
        TBody b = this.body();
        Label lbl = this.determineLabel();
        if (this.m_append) {
            TD cell = b.cell();
            if (lbl != null) {
                lbl.addCssClass("ui-f4-lbl");
                lbl.setMarginLeft("10px");
                lbl.setMarginRight("3px");
                cell.add(lbl);
            }
            cell.add(control);
            String controlCss = this.m_controlCss;
            if (null != controlCss) {
                cell.addCssClass(controlCss);
            }
        } else {
            String labelCss;
            TD labelcell = b.addRowAndCell();
            labelcell.setCssClass("ui-f4-lbl ui-f4-lbl-v");
            if (null != lbl) {
                labelcell.add(lbl);
            }
            if ((labelCss = this.m_labelCss) != null) {
                labelcell.addCssClass(labelCss);
            }
            TD controlcell = b.addCell();
            controlcell.setCssClass("ui-f4-ctl ui-f4-ctl-v");
            controlcell.add(control);
            String controlCss = this.m_controlCss;
            if (null != controlCss) {
                controlcell.addCssClass(controlCss);
            }
        }
        if (null != lbl) {
            lbl.setForNode(control);
        }
    }

    @Nonnull
    private TR controlRow() {
        TR row = this.m_controlRow;
        if (null == row) {
            this.labelRow();
            row = this.m_controlRow = this.body().addRow();
        }
        return row;
    }

    @Nonnull
    private TR labelRow() {
        TR row = this.m_labelRow;
        if (null == row) {
            row = this.m_labelRow = this.body().addRow();
        }
        return row;
    }

    private void addHorizontal(NodeBase control) {
        TBody b = this.body();
        Label lbl = this.determineLabel();
        if (this.m_append) {
            TD cell;
            TR row = this.controlRow();
            if (row.getChildCount() == 0) {
                cell = row.addCell();
                cell.setCssClass("ui-f4-ctl ui-f4-ctl-h");
            } else {
                cell = (TD)row.getChild(row.getChildCount() - 1);
            }
            cell.add(control);
            String controlCss = this.m_controlCss;
            if (null != controlCss) {
                cell.addCssClass(controlCss);
            }
        } else {
            String labelCss;
            TD labelcell = this.labelRow().addCell();
            labelcell.setCssClass("ui-f4-lbl ui-f4-lbl-h");
            if (null != lbl) {
                labelcell.add(lbl);
            }
            if ((labelCss = this.m_labelCss) != null) {
                labelcell.addCssClass(labelCss);
            }
            TD controlcell = this.controlRow().addCell();
            controlcell.setCssClass("ui-f4-ctl ui-f4-ctl-h");
            controlcell.add(control);
            String controlCss = this.m_controlCss;
            if (null != controlCss) {
                controlcell.addCssClass(controlCss);
            }
        }
        if (null != lbl) {
            lbl.setForNode(control);
        }
    }

    public void appendAfterControl(@Nonnull NodeBase what) {
        this.getLastControlCell().add(what);
    }

    @Nonnull
    public NodeContainer getLastControlCell() {
        if (this.m_lastAddedControl == null) {
            throw new IllegalStateException("No controls were added yet.");
        }
        return this.m_lastAddedControl.getParent(TD.class);
    }

    @Nullable
    private Label determineLabel() {
        Label res = null;
        String txt = this.m_nextLabel;
        if (null != txt) {
            if (txt.length() != 0) {
                res = new Label(txt);
            }
        } else {
            PropertyMetaModel<?> pmm;
            res = this.m_nextLabelControl;
            if (res == null && null != (pmm = this.m_propertyMetaModel) && (txt = pmm.getDefaultLabel()) != null && txt.length() > 0) {
                res = new Label(txt);
            }
        }
        if (res != null && this.calculateMandatory() && !this.isReadOnly()) {
            res.addCssClass("ui-f4-mandatory");
        }
        return res;
    }

    @Nullable
    private String labelTextCalculated() {
        String txt = this.m_nextLabel;
        if (null != txt) {
            if (txt.length() != 0) {
                return txt;
            }
            return null;
        }
        Label res = this.m_nextLabelControl;
        if (res != null) {
            return res.getTextContents();
        }
        PropertyMetaModel<?> pmm = this.m_propertyMetaModel;
        if (null != pmm && (txt = pmm.getDefaultLabel()) != null && txt.length() > 0) {
            return txt;
        }
        return null;
    }

    private boolean isReadOnly() {
        Boolean ro = this.m_readOnly;
        if (null != ro) {
            return ro;
        }
        return false;
    }

    private boolean isMandatory() {
        Boolean man = this.m_mandatory;
        if (null != man) {
            return man;
        }
        return false;
    }

    private boolean calculateMandatory() {
        Boolean m = this.m_mandatory;
        if (null != m) {
            return m;
        }
        PropertyMetaModel<?> pmm = this.m_propertyMetaModel;
        if (null != pmm) {
            return pmm.isRequired();
        }
        return false;
    }

    static interface IAppender {
        public void add(@Nonnull NodeBase var1);
    }
}

