/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component2.lookupinput;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.input.IQueryManipulator;
import to.etc.domui.component.layout.Dialog;
import to.etc.domui.component.lookup.LookupForm;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.component.tbl.BasicRowRenderer;
import to.etc.domui.component.tbl.DataPager;
import to.etc.domui.component.tbl.DataTable;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.IClickableRowRenderer;
import to.etc.domui.component.tbl.IQueryHandler;
import to.etc.domui.component.tbl.IRowRenderer;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.PageQueryHandler;
import to.etc.domui.component2.lookupinput.ITableModelFactory;
import to.etc.domui.dom.errors.IErrorMessageListener;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.Msgs;
import to.etc.webapp.query.QCriteria;

public class DefaultLookupInputDialog<QT, OT>
extends Dialog {
    @Nullable
    private LookupForm<QT> m_lookupForm;
    @Nullable
    private DataTable<OT> m_result;
    @Nullable
    private String m_formTitle;
    private boolean m_allowEmptyQuery = true;
    private boolean m_searchImmediately;
    private boolean m_useStretchedLayout = true;
    @Nullable
    private IErrorMessageListener m_customErrorMessageListener;
    @Nullable
    private IClickableRowRenderer<OT> m_formRowRenderer;
    @Nullable
    private IClickableRowRenderer<OT> m_actualFormRowRenderer;
    private ITableModelFactory<QT, OT> m_modelFactory;
    @Nullable
    private IQueryManipulator<QT> m_queryManipulator;
    @Nullable
    private IQueryHandler<QT> m_queryHandler;
    @Nullable
    private List<SearchPropertyMetaModel> m_searchPropertyList;
    @Nonnull
    private final ClassMetaModel m_queryMetaModel;
    @Nonnull
    private final ClassMetaModel m_outputMetaModel;
    @Nullable
    private ITableModel<OT> m_initialModel;
    @Nullable
    private OT m_value;
    @Nullable
    private IClicked<DefaultLookupInputDialog<QT, OT>> m_onSelection;

    public DefaultLookupInputDialog(@Nonnull ClassMetaModel queryMetaModel, @Nonnull ClassMetaModel outputMetaModel, @Nonnull ITableModelFactory<QT, OT> modelFactory) {
        this.m_queryMetaModel = queryMetaModel;
        this.m_outputMetaModel = outputMetaModel;
        this.m_modelFactory = modelFactory;
    }

    @Override
    public void createContent() throws Exception {
        ITableModel<OT> initialModel;
        LookupForm<Object> lf;
        if (this.getWidth() == null) {
            this.setWidth("740px");
        }
        if (this.getHeight() == null) {
            this.setHeight("90%");
        }
        this.setIcon("THEME/ttlFind.png");
        this.setTestID(this.getTestID() + "_floaterWindowLookupInput");
        IErrorMessageListener cerl = this.m_customErrorMessageListener;
        if (cerl != null && cerl instanceof NodeBase) {
            this.setErrorFence();
            this.add((NodeBase)((Object)cerl));
            DomUtil.getMessageFence(this).addErrorListener(cerl);
        }
        if ((lf = this.getLookupForm()) == null) {
            lf = new LookupForm(this.getQueryMetaModel().getActualClass(), this.getQueryMetaModel(), new String[0]);
            if (this.m_searchPropertyList != null && this.m_searchPropertyList.size() != 0) {
                lf.setSearchProperties(this.m_searchPropertyList);
            }
        }
        lf.setCollapsed((initialModel = this.m_initialModel) != null && initialModel.getRows() > 0);
        lf.forceRebuild();
        this.add(lf);
        lf.setClicked(new IClicked<LookupForm<QT>>(){

            @Override
            public void clicked(@Nonnull LookupForm<QT> b) throws Exception {
                DefaultLookupInputDialog.this.search(b);
            }
        });
        lf.setOnCancel(new IClicked<LookupForm<QT>>(){

            @Override
            public void clicked(@Nonnull LookupForm<QT> b) throws Exception {
                DefaultLookupInputDialog.this.closePressed();
            }
        });
        if (initialModel != null && initialModel.getRows() > 0) {
            this.setResultModel(initialModel);
        } else if (this.isSearchImmediately()) {
            this.search(lf);
        }
    }

    private void search(@Nonnull LookupForm<QT> lf) throws Exception {
        QCriteria<QT> c = lf.getEnteredCriteria();
        if (c == null) {
            return;
        }
        IQueryManipulator<QT> m = this.m_queryManipulator;
        if (null != m && (c = m.adjustQuery(c)) == null) {
            return;
        }
        this.clearGlobalMessage("v.missing.search");
        if (!lf.hasUserDefinedCriteria() && !this.isAllowEmptyQuery()) {
            this.addGlobalMessage(UIMessage.error(Msgs.BUNDLE, "v.missing.search", new Object[0]));
            return;
        }
        this.clearGlobalMessage();
        this.setTableQuery(c);
    }

    private void setTableQuery(@Nonnull QCriteria<QT> qc) throws Exception {
        ITableModel<OT> model = this.createTableModel(qc);
        this.setResultModel(model);
    }

    @Nonnull
    private ITableModel<OT> createTableModel(@Nonnull QCriteria<QT> qc) throws Exception {
        ITableModelFactory<QT, OT> factory = this.m_modelFactory;
        if (null == factory) {
            throw new IllegalStateException("Table model factory unset");
        }
        return factory.createTableModel(this.getQueryHandler(), qc);
    }

    private void setResultModel(@Nonnull ITableModel<OT> model) throws Exception {
        DataTable<OT> dt = this.m_result;
        if (dt == null) {
            this.m_result = new DataTable<OT>(model, this.getActualFormRowRenderer());
            dt = this.m_result;
            this.add(dt);
            dt.setPageSize(20);
            dt.setTableWidth("100%");
            this.initSelectionModel();
            if (this.isUseStretchedLayout()) {
                dt.setStretchHeight(true);
                NodeContainer delegate = this.getDelegate();
                if (null != delegate && !delegate.isStretchHeight()) {
                    delegate.setStretchHeight(true);
                }
            }
            DataPager pg = new DataPager(this.m_result);
            this.add(pg);
            dt.setTestID("resultTableLookupInput");
        } else {
            dt.setModel(model);
        }
    }

    private void initSelectionModel() throws Exception {
    }

    @Nonnull
    private IRowRenderer<OT> getActualFormRowRenderer() {
        IClickableRowRenderer<OT> actualFormRowRenderer = this.m_actualFormRowRenderer;
        if (null == actualFormRowRenderer) {
            this.m_actualFormRowRenderer = this.getFormRowRenderer();
            actualFormRowRenderer = this.m_actualFormRowRenderer;
            if (null == actualFormRowRenderer) {
                this.m_actualFormRowRenderer = new BasicRowRenderer(this.getOutputMetaModel().getActualClass(), this.getOutputMetaModel(), new Object[0]);
                actualFormRowRenderer = this.m_actualFormRowRenderer;
            }
            actualFormRowRenderer.setRowClicked(new ICellClicked<OT>(){

                @Override
                public void cellClicked(@Nonnull NodeBase tr, @Nonnull OT val) throws Exception {
                    DefaultLookupInputDialog.this.rowSelected(val);
                }
            });
        }
        return actualFormRowRenderer;
    }

    protected void rowSelected(@Nonnull OT value) throws Exception {
        this.clearGlobalMessage("v.missing.search");
        this.close();
        this.setValue(value);
        this.callOnSelection();
    }

    private void callOnSelection() throws Exception {
        IClicked<DefaultLookupInputDialog<QT, OT>> clicked = this.m_onSelection;
        if (null != clicked) {
            clicked.clicked(this);
        }
    }

    @Override
    protected void onClosed(String closeReason) throws Exception {
        this.setValue(null);
        this.callOnSelection();
        super.onClosed(closeReason);
    }

    public void addFormColumns(Object ... columns) {
        IRowRenderer<OT> rr = this.getActualFormRowRenderer();
        if (!(rr instanceof BasicRowRenderer)) {
            throw new IllegalStateException("The row renderer for the form is set to something else than a BasicRowRenderer.");
        }
        ((BasicRowRenderer)rr).addColumns(columns);
    }

    @Nonnull
    public ClassMetaModel getQueryMetaModel() {
        return this.m_queryMetaModel;
    }

    @Nonnull
    public ClassMetaModel getOutputMetaModel() {
        return this.m_outputMetaModel;
    }

    @Nullable
    public LookupForm<QT> getLookupForm() {
        return this.m_lookupForm;
    }

    public void setLookupForm(@Nullable LookupForm<QT> externalLookupForm) {
        this.m_lookupForm = externalLookupForm;
    }

    public boolean isAllowEmptyQuery() {
        return this.m_allowEmptyQuery;
    }

    public void setAllowEmptyQuery(boolean allowEmptyQuery) {
        this.m_allowEmptyQuery = allowEmptyQuery;
    }

    public boolean isSearchImmediately() {
        return this.m_searchImmediately;
    }

    public void setSearchImmediately(boolean searchImmediately) {
        this.m_searchImmediately = searchImmediately;
        if (searchImmediately) {
            this.setAllowEmptyQuery(true);
        }
    }

    public boolean isUseStretchedLayout() {
        return this.m_useStretchedLayout;
    }

    public void setUseStretchedLayout(boolean value) {
        if (value == this.m_useStretchedLayout) {
            return;
        }
        this.m_useStretchedLayout = value;
        if (this.isBuilt()) {
            this.forceRebuild();
        }
    }

    @Nullable
    public String getFormTitle() {
        return this.m_formTitle;
    }

    public void setFormTitle(@Nullable String lookupTitle) {
        this.m_formTitle = lookupTitle;
    }

    @Nullable
    public IErrorMessageListener getCustomErrorMessageListener() {
        return this.m_customErrorMessageListener;
    }

    public void setCustomErrorMessageListener(@Nullable IErrorMessageListener customErrorMessageListener) {
        this.m_customErrorMessageListener = customErrorMessageListener;
    }

    @Nullable
    public IClickableRowRenderer<OT> getFormRowRenderer() {
        return this.m_formRowRenderer;
    }

    public void setFormRowRenderer(@Nullable IClickableRowRenderer<OT> lookupFormRenderer) {
        this.m_formRowRenderer = lookupFormRenderer;
    }

    public List<SearchPropertyMetaModel> getSearchProperties() {
        return this.m_searchPropertyList;
    }

    public void setSearchProperties(List<SearchPropertyMetaModel> searchPropertyList) {
        this.m_searchPropertyList = searchPropertyList;
    }

    @Nullable
    public OT getValue() {
        return this.m_value;
    }

    public void setValue(@Nullable OT value) {
        this.m_value = value;
    }

    @Nullable
    public IClicked<DefaultLookupInputDialog<QT, OT>> getOnSelection() {
        return this.m_onSelection;
    }

    public void setOnSelection(@Nullable IClicked<DefaultLookupInputDialog<QT, OT>> onSelection) {
        this.m_onSelection = onSelection;
    }

    @Nullable
    public IQueryManipulator<QT> getQueryManipulator() {
        return this.m_queryManipulator;
    }

    public void setQueryManipulator(IQueryManipulator<QT> queryManipulator) {
        this.m_queryManipulator = queryManipulator;
    }

    @Nonnull
    public IQueryHandler<QT> getQueryHandler() {
        IQueryHandler<QT> handler = this.m_queryHandler;
        if (null == handler) {
            handler = new PageQueryHandler<QT>(this);
        }
        return handler;
    }

    public void setQueryHandler(IQueryHandler<QT> queryHandler) {
        this.m_queryHandler = queryHandler;
    }

    public void setInitialModel(@Nullable ITableModel<OT> initialModel) {
        if (this.m_initialModel != initialModel) {
            this.m_initialModel = initialModel;
            if (this.isBuilt()) {
                this.forceRebuild();
            }
        }
    }
}

