/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component2.lookupinput;

import javax.annotation.Nonnull;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.tbl.ColumnDefList;
import to.etc.domui.component.tbl.SimpleColumnDef;
import to.etc.domui.converter.IConverter;
import to.etc.domui.converter.IObjectToStringConverter;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.IValueTransformer;
import to.etc.webapp.nls.NlsContext;

public class DefaultPopupRowRenderer<T>
implements INodeContentRenderer<T> {
    @Nonnull
    private final ColumnDefList<T> m_columnList;

    public DefaultPopupRowRenderer(@Nonnull ClassMetaModel cmm) {
        this.m_columnList = new ColumnDefList(cmm.getActualClass(), cmm);
        this.m_columnList.addDefaultColumns();
    }

    @Override
    public void renderNodeContent(NodeBase component, NodeContainer node, T instance, Object parameters) throws Exception {
        if (null == instance) {
            return;
        }
        int column = 0;
        for (SimpleColumnDef<?> simpleColumnDef : this.m_columnList) {
            this.renderColumn(node, column++, instance, simpleColumnDef);
        }
    }

    private <X> void renderColumn(@Nonnull NodeContainer node, int column, @Nonnull T instance, @Nonnull SimpleColumnDef<X> cd) throws Exception {
        IValueTransformer<X> vtr = cd.getValueTransformer();
        Object colval = vtr == null ? instance : vtr.getValue(instance);
        INodeContentRenderer<X> contentRenderer = cd.getContentRenderer();
        if (null != contentRenderer) {
            if (column > 0) {
                node.add(" ");
            }
            contentRenderer.renderNodeContent(node, node, colval, instance);
        } else {
            IObjectToStringConverter<X> presentationConverter;
            String s = colval == null ? null : ((presentationConverter = cd.getPresentationConverter()) != null ? ((IConverter)presentationConverter).convertObjectToString(NlsContext.getLocale(), colval) : String.valueOf(colval));
            if (s != null) {
                if (column > 0) {
                    node.add(" ");
                }
                node.add(s);
            }
        }
    }
}

