/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component2.lookupinput;

import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.component2.lookupinput.IStringQueryFactory;
import to.etc.domui.util.DomUtil;
import to.etc.util.RuntimeConversions;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QLiteral;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QPropertyComparison;
import to.etc.webapp.query.QRestrictor;

public class DefaultStringQueryFactory<QT>
implements IStringQueryFactory<QT> {
    @Nonnull
    private final ClassMetaModel m_queryMetaModel;
    @Nullable
    private List<SearchPropertyMetaModel> m_keywordLookupPropertyList;

    public DefaultStringQueryFactory(@Nonnull ClassMetaModel queryMetaModel) {
        this.m_queryMetaModel = queryMetaModel;
    }

    @Override
    public QCriteria<QT> createQuery(String searchString) throws Exception {
        List<SearchPropertyMetaModel> keywordLookupPropertyList;
        if ((searchString = DomUtil.nullChecked(searchString.replace("*", "%"))).startsWith("$$") && searchString.length() > 2) {
            Class<?> pkType;
            Object pk;
            String idString = searchString.substring(2);
            PropertyMetaModel<?> primaryKey = this.getQueryMetaModel().getPrimaryKey();
            if (null != primaryKey && null != (pk = RuntimeConversions.convertTo((Object)idString, pkType = primaryKey.getActualType()))) {
                QCriteria<?> searchQuery = this.getQueryMetaModel().createCriteria();
                searchQuery.eq(primaryKey.getName(), pk);
                return searchQuery;
            }
        }
        List<SearchPropertyMetaModel> spml = (keywordLookupPropertyList = this.m_keywordLookupPropertyList) == null ? this.getQueryMetaModel().getKeyWordSearchProperties() : keywordLookupPropertyList;
        QCriteria<?> searchQuery = this.getQueryMetaModel().createCriteria();
        QRestrictor r = searchQuery.or();
        int ncond = 0;
        if (spml.size() > 0) {
            for (SearchPropertyMetaModel spm : spml) {
                if (spm.getMinLength() > searchString.length()) continue;
                if (spm.getPropertyName() == null) {
                    throw new ProgrammerErrorException("The quick lookup properties for " + this.getQueryMetaModel() + " are invalid: the property name is null");
                }
                List<PropertyMetaModel<?>> pl = MetaManager.parsePropertyPath(this.getQueryMetaModel(), spm.getPropertyName());
                if (pl.size() == 0) {
                    throw new ProgrammerErrorException("Unknown/unresolvable lookup property " + spm.getPropertyName() + " on " + this.getQueryMetaModel());
                }
                PropertyMetaModel<?> lastProperty = pl.get(pl.size() - 1);
                if (lastProperty.getActualType() == Long.class || lastProperty.getActualType() == BigDecimal.class) {
                    if (searchString.contains("%") && !lastProperty.isTransient()) {
                        r.add((QOperatorNode)new QPropertyComparison(QOperation.LIKE, spm.getPropertyName(), (QOperatorNode)new QLiteral((Object)searchString)));
                        continue;
                    }
                    try {
                        Object value = RuntimeConversions.convertTo((Object)searchString, lastProperty.getActualType());
                        if (null == value) continue;
                        r.eq(spm.getPropertyName(), value);
                        ++ncond;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!lastProperty.getActualType().isAssignableFrom(String.class)) continue;
                if (spm.isIgnoreCase()) {
                    r.ilike(spm.getPropertyName(), (Object)(searchString + "%"));
                } else {
                    r.like(spm.getPropertyName(), (Object)(searchString + "%"));
                }
                ++ncond;
            }
        }
        if (ncond == 0) {
            return null;
        }
        return searchQuery;
    }

    @Nonnull
    public ClassMetaModel getQueryMetaModel() {
        return this.m_queryMetaModel;
    }
}

