/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component2.lookupinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.binding.OldBindingHandler;
import to.etc.domui.component.buttons.HoverButton;
import to.etc.domui.component.event.INotify;
import to.etc.domui.component.input.IQueryManipulator;
import to.etc.domui.component.input.ITypedControl;
import to.etc.domui.component.layout.Dialog;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.component.meta.impl.SearchPropertyMetaModelImpl;
import to.etc.domui.component.tbl.IQueryHandler;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.ITruncateableDataModel;
import to.etc.domui.component.tbl.PageQueryHandler;
import to.etc.domui.component2.lookupinput.DefaultPopupOpener;
import to.etc.domui.component2.lookupinput.DefaultPopupRowRenderer;
import to.etc.domui.component2.lookupinput.DefaultStringQueryFactory;
import to.etc.domui.component2.lookupinput.IStringQueryFactory;
import to.etc.domui.component2.lookupinput.ITableModelFactory;
import to.etc.domui.component2.lookupinput.SearchInput2;
import to.etc.domui.component2.lookupinput.SelectOnePanel;
import to.etc.domui.component2.lookupinput.SimpleLookupInputRenderer2;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IHasModifiedIndication;
import to.etc.domui.dom.html.IReturnPressed;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Span;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IExecute;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.Msgs;
import to.etc.util.WrappedException;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.query.QCriteria;

public abstract class LookupInputBase2<QT, OT>
extends Div
implements IControl<OT>,
ITypedControl<OT>,
IHasModifiedIndication,
IQueryManipulator<QT> {
    @Nullable
    private String m_defaultTitle;
    @Nonnull
    private final Class<QT> m_queryClass;
    @Nonnull
    private final Class<OT> m_outputClass;
    @Nonnull
    private final ClassMetaModel m_queryMetaModel;
    @Nonnull
    private final ClassMetaModel m_outputMetaModel;
    private ITableModelFactory<QT, OT> m_modelFactory;
    @Nonnull
    private final HoverButton m_selButton;
    @Nonnull
    private final HoverButton m_clearButton;
    @Nullable
    private Dialog m_floater;
    @Nullable
    private OT m_value;
    private boolean m_mandatory;
    private boolean m_readOnly;
    private boolean m_disabled;
    @Nullable
    private String m_disabledBecause;
    @Nullable
    private IQueryManipulator<QT> m_queryManipulator;
    @Nullable
    private IQueryHandler<QT> m_queryHandler;
    @Nullable
    private INodeContentRenderer<OT> m_valueRenderer;
    @Nullable
    private SearchInput2 m_keySearch;
    @Nullable
    private String m_keySearchHint;
    private boolean m_modifiedByUser;
    @Nullable
    private IStringQueryFactory<QT> m_stringQueryFactory;
    @Nullable
    private String m_keyWordSearchCssClass;
    private int m_keyWordSearchPopupWidth;
    private boolean m_allowKeyWordSearch = true;
    @Nullable
    private List<SearchPropertyMetaModel> m_keywordLookupPropertyList;
    @Nullable
    private INotify<Dialog> m_onPopupOpen;
    @Nullable
    private RebuildCause m_rebuildCause;
    @Nullable
    private QCriteria<QT> m_rootCriteria;
    private boolean m_doFocus;
    @Nullable
    private IPopupOpener m_popupOpener;
    @Nullable
    private NodeContainer m_valueNode;
    @Nullable
    private SelectOnePanel<OT> m_selectPanel;
    @Nullable
    private Div m_pnlMessage;
    @Nullable
    private IValueChanged<?> m_onValueChanged;

    public LookupInputBase2(@Nonnull ITableModelFactory<QT, OT> modelFactory, @Nonnull Class<QT> queryClass, @Nonnull Class<OT> resultClass) {
        this(modelFactory, queryClass, resultClass, (ClassMetaModel)null, (ClassMetaModel)null);
    }

    public LookupInputBase2(@Nonnull ITableModelFactory<QT, OT> modelFactory, @Nonnull QCriteria<QT> rootCriteria, @Nonnull Class<OT> resultClass) {
        this(modelFactory, DomUtil.nullChecked(rootCriteria.getBaseClass()), resultClass, (ClassMetaModel)null, (ClassMetaModel)null);
        this.m_rootCriteria = rootCriteria;
    }

    public LookupInputBase2(@Nonnull ITableModelFactory<QT, OT> modelFactory, @Nonnull Class<QT> queryClass, @Nonnull Class<OT> resultClass, @Nullable ClassMetaModel queryMetaModel, @Nullable ClassMetaModel outputMetaModel) {
        this.m_queryClass = queryClass;
        this.m_outputClass = resultClass;
        this.m_queryMetaModel = queryMetaModel != null ? queryMetaModel : MetaManager.findClassMeta(queryClass);
        this.m_outputMetaModel = outputMetaModel != null ? outputMetaModel : MetaManager.findClassMeta(resultClass);
        this.m_modelFactory = modelFactory;
        HoverButton b = this.m_selButton = new HoverButton("THEME/btn-hover-popuplookup.png");
        b.setTestID("selButtonInputLookup");
        b.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase b) throws Exception {
                LookupInputBase2.this.openPopupWithClick();
            }
        });
        b = this.m_clearButton = new HoverButton("THEME/btn-hover-ClearLookup.png", new IClicked<HoverButton>(){

            @Override
            public void clicked(@Nonnull HoverButton b) throws Exception {
                LookupInputBase2.this.handleSetValue(null);
            }
        });
        b.setTestID("clearButtonInputLookup");
        b.setDisplay(DisplayType.NONE);
        this.setCssClass("ui-lui2");
    }

    @Nonnull
    private HoverButton getSelButton() {
        if (null != this.m_selButton) {
            return this.m_selButton;
        }
        throw new IllegalStateException("Selection button is not there.");
    }

    @Nonnull
    public HoverButton getClearButton() {
        if (null != this.m_clearButton) {
            return this.m_clearButton;
        }
        throw new IllegalStateException("Clear button is not there.");
    }

    @Nonnull
    private NodeContainer getValueNode() {
        NodeContainer node = this.m_valueNode;
        if (node == null) {
            Span span = new Span();
            this.m_valueNode = node = span;
            span.setCssClass("ui-lui2-vspan");
        }
        return node;
    }

    @Override
    public void createContent() throws Exception {
        this.m_keySearch = null;
        this.removeCssClass("ui-ro");
        if (this.m_value == null && this.isAllowKeyWordSearch() && this.isKeyWordSearchDefined()) {
            if (this.isReadOnly() || this.isDisabled()) {
                this.add(0, this.getValueNode());
                this.renderEmptySelection();
                this.addCssClass("ui-ro");
            } else {
                this.renderKeyWordSearch();
            }
        } else {
            INodeContentRenderer<OT> r = this.getValueRenderer();
            if (r == null) {
                r = new SimpleLookupInputRenderer2<OT>(this.getOutputMetaModel(), new String[0]);
            }
            NodeContainer valueNode = this.getValueNode();
            valueNode.removeAllChildren();
            r.renderNodeContent(this, valueNode, this.m_value, null);
            this.add(0, valueNode);
        }
        HoverButton clearButton = this.getClearButton();
        if (!this.isReadOnly() && !this.isDisabled()) {
            this.add(this.getSelButton());
            this.add(clearButton);
        }
        if (this.m_rebuildCause == RebuildCause.CLEAR) {
            if (this.m_keySearch != null) {
                this.m_keySearch.setFocus();
            }
        } else if (this.m_rebuildCause == RebuildCause.SELECT && clearButton != null && clearButton.getDisplay() != DisplayType.NONE && this.getPage().getFocusComponent() == null) {
            clearButton.setFocus();
        }
        this.m_rebuildCause = null;
        if (this.m_doFocus) {
            this.m_doFocus = false;
            if (this.m_keySearch != null) {
                this.m_keySearch.setFocus();
            } else if (this.m_clearButton != null) {
                this.m_clearButton.setFocus();
            }
        }
    }

    @Override
    @Nullable
    protected String getFocusID() {
        SearchInput2 keySearch = this.m_keySearch;
        if (null != keySearch && keySearch.isAttached()) {
            return keySearch.getActualID();
        }
        HoverButton selButton = this.m_selButton;
        if (null != selButton && selButton.isAttached()) {
            return selButton.getActualID();
        }
        HoverButton clearButton = this.m_clearButton;
        if (null != clearButton && clearButton.isAttached()) {
            return clearButton.getActualID();
        }
        return null;
    }

    private void renderEmptySelection() {
        String txt = Msgs.BUNDLE.getString("ui.lookup.empty");
        this.getValueNode().setText(txt);
    }

    private boolean isKeyWordSearchDefined() {
        if (this.getStringQueryFactory() != null) {
            return true;
        }
        if (this.m_keywordLookupPropertyList != null) {
            return true;
        }
        List<SearchPropertyMetaModel> spml = this.getQueryMetaModel().getKeyWordSearchProperties();
        return spml.size() > 0;
    }

    private void renderKeyWordSearch() {
        this.getValueNode().remove();
        SearchInput2 ks = this.m_keySearch = new SearchInput2(this.m_keyWordSearchCssClass);
        this.add(0, ks);
        ks.setPopupWidth(this.getKeyWordSearchPopupWidth());
        ks.setOnLookupTyping(new IValueChanged<SearchInput2>(){

            @Override
            public void onValueChanged(@Nonnull SearchInput2 component) throws Exception {
                ITableModel keySearchModel = LookupInputBase2.this.searchKeyWord(component.getValue());
                LookupInputBase2.this.showResults(keySearchModel);
            }
        });
        ks.setReturnPressed((IReturnPressed<? extends NodeBase>)new IReturnPressed<SearchInput2>(){

            @Override
            public void returnPressed(SearchInput2 node) throws Exception {
                LookupInputBase2.this.handleSelection(node);
            }
        });
        if (this.m_keyWordSearchCssClass != null) {
            this.addCssClass(this.m_keyWordSearchCssClass);
        }
        ks.setHint(Msgs.BUNDLE.formatMessage("ui.keyword.search.hint", new Object[]{this.m_keySearchHint != null ? this.m_keySearchHint : this.getDefaultKeySearchHint()}));
    }

    private void handleSelection(@Nonnull SearchInput2 node) throws Exception {
        OT value;
        SelectOnePanel<OT> sp = this.m_selectPanel;
        if (sp != null && null != (value = sp.getValue())) {
            this.clearResult();
            this.handleSetValue(value);
            return;
        }
        ITableModel<OT> keySearchModel = this.searchKeyWord(node.getValue());
        this.openPopup(keySearchModel);
    }

    @Nonnull
    private SearchInput2 getKeySearch() {
        if (null != this.m_keySearch) {
            return this.m_keySearch;
        }
        throw new IllegalStateException("keySearch is null");
    }

    private String getDefaultKeySearchHint() {
        List<SearchPropertyMetaModel> spml;
        List<SearchPropertyMetaModel> list = spml = this.m_keywordLookupPropertyList != null ? this.m_keywordLookupPropertyList : this.getQueryMetaModel().getKeyWordSearchProperties();
        if (spml.size() <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < spml.size(); ++i) {
            SearchPropertyMetaModel spm;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (null == (spm = spml.get(i))) {
                throw new IllegalStateException("null entry in keyword search list");
            }
            if (spm.getLookupLabel() != null) {
                sb.append(spm.getLookupLabel());
                continue;
            }
            String propertyName = spm.getPropertyName();
            if (propertyName == null) {
                throw new IllegalStateException("Search property name is null");
            }
            PropertyMetaModel<?> pmm = this.getQueryMetaModel().findProperty(propertyName);
            if (pmm == null) {
                throw new IllegalStateException(propertyName + ": undefined property in " + this.getQueryMetaModel());
            }
            if (pmm.getDefaultLabel() != null) {
                sb.append(pmm.getDefaultLabel());
                continue;
            }
            sb.append(pmm.getName());
        }
        return sb.toString();
    }

    @Nullable
    private ITableModel<OT> searchKeyWord(@Nullable String searchString) throws Exception {
        if (searchString == null || searchString.trim().length() == 0) {
            return null;
        }
        IStringQueryFactory<QT> ksh = this.getStringQueryFactory();
        QCriteria<QT> searchQuery = ksh.createQuery(searchString);
        if (searchQuery == null) {
            return null;
        }
        if ((searchQuery = this.adjustQuery(searchQuery)) == null) {
            return null;
        }
        return this.createTableModel(searchQuery);
    }

    @Nonnull
    private ITableModel<OT> createTableModel(@Nonnull QCriteria<QT> qc) throws Exception {
        ITableModelFactory<QT, OT> factory = this.m_modelFactory;
        if (null == factory) {
            throw new IllegalStateException("Table model factory unset");
        }
        return factory.createTableModel(this.getQueryHandler(), qc);
    }

    @Override
    @Nullable
    public QCriteria<QT> adjustQuery(@Nonnull QCriteria<QT> enteredCriteria) {
        IQueryManipulator<QT> qm = this.getQueryManipulator();
        QCriteria<QT> result = enteredCriteria;
        if (qm != null && (result = qm.adjustQuery(enteredCriteria)) == null) {
            return null;
        }
        QCriteria<QT> root = this.m_rootCriteria;
        if (null != root) {
            result.mergeCriteria(root);
        }
        return result;
    }

    private void openPopupWithClick() throws Exception {
        ITableModel<OT> initialModel = null;
        if (this.m_keySearch != null) {
            initialModel = this.searchKeyWord(this.m_keySearch.getValue());
        }
        this.openPopup(initialModel);
    }

    private void closePopup() {
        Dialog floater = this.m_floater;
        if (floater == null) {
            return;
        }
        floater.close();
        this.m_floater = null;
    }

    private void openPopup(@Nullable ITableModel<OT> initialModel) throws Exception {
        if (this.m_floater != null) {
            return;
        }
        IPopupOpener po = this.m_popupOpener;
        if (null == po) {
            po = this.createPopupOpener();
        }
        Dialog floater = this.m_floater = po.createDialog(this, initialModel, () -> {
            this.m_floater = null;
        });
        floater.setCssClass("ui-lui2-dlg");
        floater.modal();
        this.add(floater);
        INotify<Dialog> onPopupOpen = this.m_onPopupOpen;
        if (null != onPopupOpen) {
            onPopupOpen.onNotify(floater);
        }
    }

    @Nullable
    public INotify<Dialog> getOnPopupOpen() {
        return this.m_onPopupOpen;
    }

    public void setOnPopupOpen(@Nullable INotify<Dialog> onPopupOpen) {
        this.m_onPopupOpen = onPopupOpen;
    }

    @Nonnull
    private IPopupOpener createPopupOpener() {
        return new DefaultPopupOpener();
    }

    public void showResults(@Nullable ITableModel<OT> model) throws Exception {
        this.clearResult();
        if (model == null) {
            return;
        }
        int size = model.getRows();
        if (size == 0) {
            this.openMessagePanel("ui.keyword.search.no.match", new String[0]);
        } else if (size > 10) {
            String count = Integer.toString(size);
            if (model instanceof ITruncateableDataModel && ((ITruncateableDataModel)((Object)model)).isTruncated()) {
                count = "> " + count;
            }
            this.openMessagePanel("ui.keyword.search.count", count);
        } else {
            this.openResultsPopup(model);
        }
    }

    private void openResultsPopup(@Nonnull ITableModel<OT> model) throws Exception {
        List<OT> list = model.getItems(0, model.getRows());
        DefaultPopupRowRenderer renderer = new DefaultPopupRowRenderer(this.m_outputMetaModel);
        this.m_selectPanel = new SelectOnePanel<OT>(list, renderer);
        SelectOnePanel<OT> pnl = this.m_selectPanel;
        DomUtil.nullChecked(this.m_keySearch).add(pnl);
        pnl.setOnValueChanged(new IValueChanged<SelectOnePanel<OT>>(){

            @Override
            public void onValueChanged(SelectOnePanel<OT> component) throws Exception {
                LookupInputBase2.this.clearResult();
                Object selection = component.getValue();
                if (null != selection) {
                    LookupInputBase2.this.handleSetValue(selection);
                }
            }
        });
        pnl.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase clickednode) throws Exception {
            }
        });
    }

    private void openMessagePanel(@Nonnull String code, String ... parameters) {
        String message = Msgs.BUNDLE.formatMessage(code, (Object[])parameters);
        Div pnl = this.m_pnlMessage;
        if (pnl == null) {
            pnl = this.m_pnlMessage = new Div();
            this.add(pnl);
        }
        pnl.setCssClass("ui-srip-message");
        pnl.setText(message);
    }

    private void clearResult() {
        SelectOnePanel<OT> panel;
        Div div = this.m_pnlMessage;
        if (null != div) {
            div.remove();
            this.m_pnlMessage = null;
        }
        if (null != (panel = this.m_selectPanel)) {
            panel.remove();
            this.m_selectPanel = null;
        }
    }

    @Nonnull
    public String getDefaultTitle() {
        String popupTitle = this.m_defaultTitle;
        if (null != popupTitle) {
            return popupTitle;
        }
        String entity = this.getOutputMetaModel().getUserEntityName();
        if (entity != null) {
            return Msgs.BUNDLE.formatMessage("ui.lui.ttl.wen", new Object[]{entity});
        }
        return Msgs.BUNDLE.getString("ui.lui.ttl");
    }

    public void setDefaultTitle(@Nullable String defaultTitle) {
        this.m_defaultTitle = defaultTitle;
    }

    public void setHint(@Nonnull String text) {
        if (this.m_selButton != null) {
            this.m_selButton.setTitle(text);
        }
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (this.m_readOnly == readOnly) {
            return;
        }
        this.m_readOnly = readOnly;
        this.updateRoStyle();
        this.forceRebuild();
    }

    private void updateRoStyle() {
        if ((this.m_disabled || this.m_readOnly) && this.m_value != null) {
            this.addCssClass("ui-lui2-selected-ro");
        } else {
            this.removeCssClass("ui-lui2-selected-ro");
        }
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.m_disabled == disabled) {
            return;
        }
        this.m_disabled = disabled;
        this.updateRoStyle();
        this.forceRebuild();
    }

    @Nullable
    public String getDisabledBecause() {
        return this.m_disabledBecause;
    }

    public void setDisabledBecause(@Nullable String msg) {
        if (Objects.equals(msg, this.m_disabledBecause)) {
            return;
        }
        this.m_disabledBecause = msg;
        this.setOverrideTitle(msg);
        this.setDisabled(msg != null);
    }

    @Nullable
    public OT getBindValue() {
        if (this.m_value == null && this.isMandatory()) {
            throw new ValidationException("ui.mandatory", new Object[0]);
        }
        return this.m_value;
    }

    public void setBindValue(@Nullable OT value) {
        this.setValue(value);
    }

    @Override
    @Nullable
    public OT getValue() {
        if (this.m_value == null && this.isMandatory()) {
            this.setMessage(UIMessage.error(Msgs.BUNDLE, "ui.mandatory", new Object[0]));
            throw new ValidationException("ui.mandatory", new Object[0]);
        }
        return this.m_value;
    }

    @Override
    @Nullable
    public OT getValueSafe() {
        return (OT)DomUtil.getValueSafe(this);
    }

    public OT getWorkValue() {
        OT valueSafe = this.getValueSafe();
        this.clearMessage();
        return valueSafe;
    }

    @Override
    public boolean hasError() {
        this.getValueSafe();
        return super.hasError();
    }

    @Override
    public void setValue(@Nullable OT v) {
        SearchInput2 ks = this.m_keySearch;
        if (DomUtil.isEqual(this.m_value, v) && (ks == null || ks.getValue() == null)) {
            return;
        }
        OT old = this.m_value;
        this.m_value = v;
        if (v != null) {
            this.getClearButton().setDisplay(DisplayType.INLINE);
            this.clearMessage();
            this.setCssClass("ui-lui2-selected");
        } else {
            this.getClearButton().setDisplay(DisplayType.NONE);
            this.setCssClass("ui-lui2");
        }
        this.updateRoStyle();
        this.forceRebuild();
    }

    void handleSetValue(@Nullable OT value) throws Exception {
        if (!MetaManager.areObjectsEqual(value, this.m_value, null)) {
            DomUtil.setModifiedFlag(this);
            this.setValue(value);
            try {
                OldBindingHandler.controlToModel(this);
            }
            catch (Exception x) {
                throw WrappedException.wrap((Exception)x);
            }
            IValueChanged<?> onValueChanged = this.getOnValueChanged();
            if (onValueChanged != null) {
                onValueChanged.onValueChanged(this);
            }
        }
        this.m_rebuildCause = value == null ? RebuildCause.CLEAR : RebuildCause.SELECT;
    }

    public final void setDialogSelection(@Nullable OT value) throws Exception {
        if (null == value) {
            return;
        }
        this.m_floater = null;
        this.handleSetValue(value);
    }

    @Override
    @Nullable
    public IValueChanged<?> getOnValueChanged() {
        if (this.m_floater != null) {
            return null;
        }
        return this.m_onValueChanged;
    }

    @Override
    public void setOnValueChanged(@Nullable IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }

    @Nullable
    public IQueryManipulator<QT> getQueryManipulator() {
        return this.m_queryManipulator;
    }

    @Nonnull
    public IQueryHandler<QT> getQueryHandler() {
        IQueryHandler<QT> handler = this.m_queryHandler;
        if (null == handler) {
            handler = new PageQueryHandler<QT>(this);
        }
        return handler;
    }

    public void setQueryHandler(@Nullable IQueryHandler<QT> queryHandler) {
        this.m_queryHandler = queryHandler;
    }

    public void setQueryManipulator(@Nullable IQueryManipulator<QT> queryManipulator) {
        this.m_queryManipulator = queryManipulator;
    }

    @Override
    public boolean isModified() {
        return this.m_modifiedByUser;
    }

    @Override
    public void setModified(boolean as) {
        this.m_modifiedByUser = as;
    }

    @Nonnull
    public IStringQueryFactory<QT> getStringQueryFactory() {
        IStringQueryFactory<QT> factory = this.m_stringQueryFactory;
        if (null == factory) {
            this.m_stringQueryFactory = factory = new DefaultStringQueryFactory(this.getQueryMetaModel());
        }
        return factory;
    }

    public void setStringQueryFactory(@Nonnull IStringQueryFactory<QT> keyWordSearchManipulator) {
        this.m_stringQueryFactory = keyWordSearchManipulator;
    }

    @Nullable
    public String getKeyWordSearchCssClass() {
        return this.m_keyWordSearchCssClass;
    }

    public void setKeyWordSearchCssClass(@Nullable String cssClass) {
        this.m_keyWordSearchCssClass = cssClass;
    }

    public boolean isAllowKeyWordSearch() {
        return this.m_allowKeyWordSearch;
    }

    public void setAllowKeyWordSearch(boolean allowKeyWordSearch) {
        this.m_allowKeyWordSearch = allowKeyWordSearch;
    }

    @Nullable
    public String getKeySearchHint() {
        return this.m_keySearchHint;
    }

    public void setKeySearchHint(@Nullable String keySearchHint) {
        this.m_keySearchHint = keySearchHint;
        if (this.m_keySearch != null) {
            this.m_keySearch.setHint(keySearchHint);
        }
    }

    public void addKeywordProperty(@Nonnull String name, int minlen) {
        if (this.m_keywordLookupPropertyList == null) {
            this.m_keywordLookupPropertyList = new ArrayList<SearchPropertyMetaModel>();
        }
        SearchPropertyMetaModelImpl si = new SearchPropertyMetaModelImpl(this.getQueryMetaModel());
        if (minlen > 0) {
            si.setMinLength(minlen);
        }
        si.setPropertyName(name);
        si.setIgnoreCase(true);
        DomUtil.nullChecked(this.m_keywordLookupPropertyList).add(si);
    }

    public void setKeywordSearchProperties(@Nonnull List<SearchPropertyMetaModel> keywordLookupPropertyList) {
        this.m_keywordLookupPropertyList = keywordLookupPropertyList;
    }

    @Nonnull
    public List<SearchPropertyMetaModel> getKeywordLookupPropertyList() {
        if (null != this.m_keywordLookupPropertyList) {
            return this.m_keywordLookupPropertyList;
        }
        throw new NullPointerException("No keyword properties set.");
    }

    public void addKeywordProperty(@Nonnull String name) {
        this.addKeywordProperty(name, -1);
    }

    public int getKeyWordSearchPopupWidth() {
        return this.m_keyWordSearchPopupWidth;
    }

    public void setKeyWordSearchPopupWidth(int keyWordSearchPopupWidth) {
        this.m_keyWordSearchPopupWidth = keyWordSearchPopupWidth;
    }

    @Nonnull
    public Class<OT> getOutputClass() {
        return this.m_outputClass;
    }

    @Override
    @Nonnull
    public Class<OT> getActualType() {
        return this.m_outputClass;
    }

    @Nonnull
    public Class<QT> getQueryClass() {
        return this.m_queryClass;
    }

    @Nonnull
    public ClassMetaModel getOutputMetaModel() {
        return this.m_outputMetaModel;
    }

    @Nonnull
    public ClassMetaModel getQueryMetaModel() {
        return this.m_queryMetaModel;
    }

    public void setValueColumns(String ... columns) {
        this.setValueRenderer(new SimpleLookupInputRenderer2<OT>(this.getOutputClass(), columns));
    }

    @Nullable
    public INodeContentRenderer<OT> getValueRenderer() {
        return this.m_valueRenderer;
    }

    public void setValueRenderer(@Nullable INodeContentRenderer<OT> contentRenderer) {
        this.m_valueRenderer = contentRenderer;
    }

    protected boolean isPopupShown() {
        return this.m_floater != null;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocus() {
        if (null != this.m_keySearch) {
            this.m_keySearch.setFocus();
        } else if (!this.isBuilt()) {
            this.m_doFocus = true;
        }
    }

    @Nonnull
    public ITableModelFactory<QT, OT> getModelFactory() {
        ITableModelFactory<QT, OT> modelFactory = this.m_modelFactory;
        if (null == modelFactory) {
            throw new IllegalStateException("The model factory is not set");
        }
        return modelFactory;
    }

    public void setModelFactory(@Nonnull ITableModelFactory<QT, OT> modelFactory) {
        this.m_modelFactory = modelFactory;
    }

    @Nullable
    public IPopupOpener getPopupOpener() {
        return this.m_popupOpener;
    }

    public void setPopupOpener(IPopupOpener popupOpener) {
        if (this.isBuilt()) {
            throw new ProgrammerErrorException("can't set popup opener on built component!");
        }
        this.m_popupOpener = popupOpener;
    }

    private static enum RebuildCause {
        CLEAR,
        SELECT;

    }

    public static interface IPopupOpener {
        @Nonnull
        public <A, B, L extends LookupInputBase2<A, B>> Dialog createDialog(@Nonnull L var1, @Nullable ITableModel<B> var2, @Nonnull IExecute var3);
    }
}

