/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component2.lookupinput;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.html.ClickInfo;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IHasChangeListener;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.util.INodeContentRenderer;

public class SelectOnePanel<T>
extends Div
implements IHasChangeListener {
    @Nonnull
    private final List<T> m_itemList;
    private final INodeContentRenderer<T> m_renderer;
    private int m_currentSelection;
    private int m_currentValue;
    private IValueChanged<?> m_valueChanged;

    public SelectOnePanel(@Nonnull List<T> itemList, @Nonnull INodeContentRenderer<T> renderer) {
        this.m_itemList = itemList;
        this.m_renderer = renderer;
    }

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-ssop");
        Table tbl = new Table();
        this.add(tbl);
        TBody body = new TBody();
        tbl.add(body);
        tbl.setCellPadding("0");
        tbl.setCellSpacing("0");
        for (T item : this.m_itemList) {
            this.renderItem(body, item);
        }
        this.appendCreateJS("new WebUI.SelectOnePanel('" + this.getActualID() + "');");
        this.m_currentSelection = -1;
        this.m_currentValue = -1;
    }

    private void renderItem(@Nonnull TBody body, @Nonnull T item) throws Exception {
        TR row = body.addRow();
        row.setCssClass("ui-ssop-row");
        TD cell = row.addCell();
        this.m_renderer.renderNodeContent(row, cell, item, null);
    }

    @Override
    public boolean acceptRequestParameter(String[] values) throws Exception {
        String s;
        int value = -1;
        if (values.length == 1 && (s = values[0]) != null && s.trim().length() > 0) {
            try {
                value = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_currentSelection = value;
        return false;
    }

    @Override
    public void internalOnClicked(@Nonnull ClickInfo cli) throws Exception {
        if (this.m_currentValue != this.m_currentSelection) {
            this.m_currentValue = this.m_currentSelection;
            this.internalOnValueChanged();
        }
        super.internalOnClicked(cli);
    }

    public int getIndex() {
        return this.m_currentValue;
    }

    @Nullable
    public T getValue() {
        int index = this.getIndex();
        if (index < 0 || index >= this.m_itemList.size()) {
            return null;
        }
        return this.m_itemList.get(index);
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        return this.m_valueChanged;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> valueChanged) {
        this.m_valueChanged = valueChanged;
    }
}

