/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component2.lookupinput;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.impl.DisplayPropertyMetaModel;
import to.etc.domui.component.meta.impl.ExpandedDisplayProperty;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Span;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.Msgs;
import to.etc.webapp.ProgrammerErrorException;

@DefaultNonNull
public final class SimpleLookupInputRenderer2<T>
implements INodeContentRenderer<T> {
    private final Class<T> m_actualClass;
    private final ClassMetaModel m_classModel;
    private final String[] m_propertyNames;
    private final List<ExpandedDisplayProperty<?>> m_xpl;

    public SimpleLookupInputRenderer2(Class<T> displayClass, String ... propertyNames) {
        this.m_classModel = MetaManager.findClassMeta(displayClass);
        this.m_actualClass = displayClass;
        this.m_propertyNames = propertyNames;
        this.m_xpl = this.initRenderingModel();
    }

    public SimpleLookupInputRenderer2(ClassMetaModel cmm, String ... propertyNames) {
        this.m_actualClass = cmm.getActualClass();
        this.m_classModel = cmm;
        this.m_propertyNames = propertyNames;
        this.m_xpl = this.initRenderingModel();
    }

    private Class<T> getActualClass() {
        return this.m_actualClass;
    }

    @Nonnull
    private List<ExpandedDisplayProperty<?>> initRenderingModel() {
        ArrayList<ExpandedDisplayProperty<?>> xpl;
        ClassMetaModel cmm = MetaManager.findClassMeta(this.getActualClass());
        if (this.m_propertyNames.length == 0) {
            List<DisplayPropertyMetaModel> l = cmm.getTableDisplayProperties();
            if (l.size() == 0) {
                l = cmm.getComboDisplayProperties();
            }
            if (l.size() == 0) {
                throw new ProgrammerErrorException("The class " + this.getActualClass() + " has no presentation metadata (@MetaObject or @MetaCombo)");
            }
            xpl = ExpandedDisplayProperty.expandDisplayProperties(l, cmm, null);
        } else {
            xpl = new ArrayList();
            for (String propname : this.m_propertyNames) {
                xpl.add(ExpandedDisplayProperty.expandProperty(cmm, propname));
            }
        }
        return ExpandedDisplayProperty.flatten(xpl);
    }

    @Override
    public void renderNodeContent(@Nonnull NodeBase component, @Nonnull NodeContainer node, @Nullable T object, @Nullable Object parameters) throws Exception {
        if (null == object) {
            String txt = Msgs.BUNDLE.getString("ui.lookup.empty");
            node.setText(txt);
            return;
        }
        List<ExpandedDisplayProperty<?>> xl = this.m_xpl;
        if (xl == null || xl.size() == 0) {
            node.add(String.valueOf(object));
            return;
        }
        boolean c = false;
        boolean mw = false;
        TBody tb = node.addTableForLayout();
        for (ExpandedDisplayProperty<?> xp : xl) {
            String val = xp.getPresentationString(object);
            if (val == null || val.length() == 0) continue;
            Span vals = new Span();
            vals.setCssClass("ui-lui2-vals");
            tb.addRowAndCell().add(vals);
            vals.setText(val);
        }
    }
}

