/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.util.Locale;
import to.etc.domui.converter.IConverter;
import to.etc.domui.trouble.UIException;
import to.etc.domui.util.Msgs;

public class BooleanConverter
implements IConverter<Boolean> {
    private static final BooleanConverter m_instance = new BooleanConverter();

    @Override
    public Boolean convertStringToObject(Locale loc, String in) throws UIException {
        if ("TRUE".equalsIgnoreCase(in) || "Y".equalsIgnoreCase(in) || "YES".equalsIgnoreCase(in)) {
            return Boolean.TRUE;
        }
        if ("FALSE".equalsIgnoreCase(in) || "N".equalsIgnoreCase(in) || "NO".equalsIgnoreCase(in) || "".equalsIgnoreCase(in)) {
            return Boolean.FALSE;
        }
        throw new IllegalStateException("Unreasonable text conversion from string to boolean.");
    }

    @Override
    public String convertObjectToString(Locale loc, Boolean in) throws UIException {
        if (in == null) {
            return null;
        }
        return Msgs.BUNDLE.getString(loc, in != false ? "ui.boolean.true" : "ui.boolean.false");
    }

    public static final BooleanConverter getInstance() {
        return m_instance;
    }
}

