/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;

public final class CompoundComparator<T>
implements Comparator<T> {
    @Nonnull
    private final List<Comparator<T>> m_list;
    private final int m_descending;

    public CompoundComparator(List<Comparator<T>> list, boolean reverse) {
        this.m_list = list;
        this.m_descending = reverse ? -1 : 1;
    }

    @Override
    public int compare(T o1, T o2) {
        for (Comparator<T> c : this.m_list) {
            int res = c.compare(o1, o2);
            if (res == 0) continue;
            return res * this.m_descending;
        }
        return 0;
    }
}

