/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.util.DomUtil;
import to.etc.util.RuntimeConversions;
import to.etc.util.TextScanner;
import to.etc.webapp.query.QDataContext;

public class CompoundKeyConverter {
    public static final CompoundKeyConverter INSTANCE = new CompoundKeyConverter();

    public Object unmarshal(QDataContext dc, Class<?> pkclass, String in) throws Exception {
        if (in.trim().length() == 0) {
            return null;
        }
        Scanner ts = new Scanner(dc, pkclass, in);
        return ts.scanAnything(pkclass);
    }

    public String marshal(Object in) throws Exception {
        if (in == null) {
            return "$$null$$";
        }
        StringBuilder sb = new StringBuilder();
        this.renderAnything(sb, in, in);
        return sb.toString();
    }

    private void renderRenderable(StringBuilder sb, Object pvalue) throws Exception {
        if (sb.length() != 0) {
            sb.append(",");
        }
        if (pvalue instanceof String) {
            sb.append(((String)pvalue).replace(",", "\\,").replace("\\", "\\\\"));
        } else {
            sb.append(String.valueOf(pvalue));
        }
    }

    private void renderAnything(StringBuilder sb, Object in, Object root) throws Exception {
        if (in == null) {
            throw new IllegalStateException("Unexpected: null value in PK " + root + " of class " + root.getClass());
        }
        Class<?> clz = in.getClass();
        if (CompoundKeyConverter.isRenderable(clz)) {
            this.renderRenderable(sb, in);
            return;
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(in.getClass());
        if (cmm.isPersistentClass()) {
            this.renderPersistentClass(sb, in, root, cmm);
            return;
        }
        this.renderObject(sb, in, root, cmm);
    }

    private void renderPersistentClass(StringBuilder sb, Object in, Object root, ClassMetaModel cmm) throws Exception {
        if (!cmm.isPersistentClass()) {
            throw new IllegalStateException("Unexpected: PK entry is not a persistent class: " + cmm + ", in root PK " + root.getClass());
        }
        PropertyMetaModel<?> pkpm = cmm.getPrimaryKey();
        if (pkpm == null) {
            throw new IllegalStateException("Unexpected: persistent class " + cmm + " has an undefined PK property");
        }
        Object pkval = pkpm.getValue(in);
        this.renderAnything(sb, pkval, root);
    }

    private void renderObject(StringBuilder sb, Object in, Object root, ClassMetaModel cmm) throws Exception {
        for (PropertyMetaModel<?> pmm : cmm.getProperties()) {
            Object pvalue = pmm.getValue(in);
            this.renderAnything(sb, pvalue, root);
        }
    }

    static boolean isRenderable(Class<?> t) {
        if (t.isPrimitive()) {
            return true;
        }
        return t == Integer.class || t == Long.class || t == Short.class || t == String.class || t == Byte.class || t == BigDecimal.class || t == BigInteger.class || t == Double.class || t == Float.class || t == Date.class;
    }

    private static class Scanner
    extends TextScanner {
        private QDataContext m_dc;
        private Class<?> m_root;
        private String m_input;

        public Scanner(QDataContext dc, Class<?> root, String s) {
            super(s);
            this.m_dc = dc;
            this.m_root = root;
            this.m_input = s;
        }

        public String scanString() {
            this.clear();
            while (!this.eof()) {
                int c = this.LA();
                if (c == 92) {
                    this.accept();
                    this.copy();
                    continue;
                }
                if (c == 44) {
                    this.accept();
                    return this.getCopied();
                }
                this.copy();
            }
            return this.getCopied();
        }

        public Object scanAnything(Class<?> type) throws Exception {
            if (CompoundKeyConverter.isRenderable(type)) {
                if (type == String.class) {
                    return this.scanString();
                }
                if (DomUtil.isIntegerOrWrapper(type) || DomUtil.isLongOrWrapper(type) || DomUtil.isDoubleOrWrapper(type) || DomUtil.isFloatOrWrapper(type) || DomUtil.isBooleanOrWrapper(type)) {
                    String s = this.scanString();
                    return RuntimeConversions.convertTo((Object)s, type);
                }
                throw new IllegalStateException("?? Unexpected type in unmarshaller: " + type);
            }
            ClassMetaModel cmm = MetaManager.findClassMeta(type);
            if (cmm.isPersistentClass()) {
                return this.scanPersistentClass(type, cmm);
            }
            return this.scanObject(type, cmm);
        }

        private Object scanPersistentClass(Class<?> type, ClassMetaModel cmm) throws Exception {
            if (!cmm.isPersistentClass()) {
                throw new IllegalStateException("Unexpected: PK entry is not a persistent class: " + cmm + ", in root PK " + this.m_root.getClass());
            }
            PropertyMetaModel<?> pkpm = cmm.getPrimaryKey();
            if (pkpm == null) {
                throw new IllegalStateException("Unexpected: persistent class " + cmm + " has an undefined PK property");
            }
            Object pk = this.scanAnything(pkpm.getActualType());
            if (pk == null) {
                throw new IllegalStateException("Primary key " + pkpm + " is null in [[" + this.m_input + "]]");
            }
            return this.m_dc.getInstance(cmm.getActualClass(), pk);
        }

        private Object scanObject(Class<?> type, ClassMetaModel cmm) throws Exception {
            Object inst;
            try {
                inst = type.newInstance();
            }
            catch (Exception x) {
                throw new IllegalStateException("Cannot create instance of " + type + " for PK=" + this.m_root + ": " + x, x);
            }
            for (PropertyMetaModel<?> pmm : cmm.getProperties()) {
                Object pvalue = this.scanAnything(pmm.getActualType());
                if (pvalue == null) {
                    throw new IllegalStateException("Null value for property " + pmm + " in pk " + this.m_root);
                }
                pmm.setValue(inst, pvalue);
            }
            return inst;
        }
    }
}

