/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.converter.BooleanConverter;
import to.etc.domui.converter.BooleanConverterFactory;
import to.etc.domui.converter.CompoundComparator;
import to.etc.domui.converter.DateConverterFactory;
import to.etc.domui.converter.DateUrlParamConverter;
import to.etc.domui.converter.DefaultConverterFactory;
import to.etc.domui.converter.DomainListConverterFactory;
import to.etc.domui.converter.DoubleFactory;
import to.etc.domui.converter.EnumFactory;
import to.etc.domui.converter.IConverter;
import to.etc.domui.converter.IConverterFactory;
import to.etc.domui.converter.MoneyConverterFactory;
import to.etc.domui.converter.PropertyComparator;
import to.etc.util.RuntimeConversions;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.nls.NlsContext;

public class ConverterRegistry {
    private static Map<Class<? extends IConverter<?>>, IConverter<?>> m_converterMap = new HashMap();
    private static Map<Class<?>, IConverter<?>> m_urlConverterMap = new HashMap();
    private static List<IConverterFactory> m_factoryList = new ArrayList<IConverterFactory>();
    private static IConverterFactory m_defaultConverterFactory;
    private static Map<Class<?>, Comparator<?>> m_comparatorMap;
    public static final Comparator<Object> DEFAULT_COMPARATOR;

    @Nonnull
    public static synchronized <X, T extends IConverter<X>> T getConverterInstance(@Nonnull Class<T> clz) {
        IConverter c = m_converterMap.get(clz);
        if (c == null) {
            try {
                c = (IConverter)clz.newInstance();
            }
            catch (Exception x) {
                throw new IllegalStateException("Cannot instantiate converter " + clz + ": " + x, x);
            }
            m_converterMap.put(clz, c);
        }
        return (T)c;
    }

    public static <X, T extends IConverter<X>> X convertStringToValue(Class<T> clz, Locale loc, String in) throws Exception {
        T c = ConverterRegistry.getConverterInstance(clz);
        return (X)c.convertStringToObject(loc, in);
    }

    public static <X, T extends IConverter<X>> String convertValueToString(Class<T> clz, Locale loc, X in) throws Exception {
        X c = ConverterRegistry.getConverterInstance(clz);
        return c.convertObjectToString(loc, in);
    }

    public static <X, T extends IConverter<X>> X convertStringToValue(Class<T> clz, String in) throws Exception {
        T c = ConverterRegistry.getConverterInstance(clz);
        Locale loc = NlsContext.getLocale();
        return (X)c.convertStringToObject(loc, in);
    }

    @Nonnull
    public static <X, T extends IConverter<X>> String convertValueToString(Class<T> clz, X in) throws Exception {
        if (clz == null) {
            return in == null ? "" : in.toString();
        }
        X c = ConverterRegistry.getConverterInstance(clz);
        Locale loc = NlsContext.getLocale();
        return c.convertObjectToString(loc, in);
    }

    public static synchronized <X> void registerURLConverter(Class<X> totype, IConverter<X> c) {
        if (null != m_urlConverterMap.put(totype, c)) {
            throw new IllegalStateException("Duplicate URLConverter registered for target type=" + totype);
        }
    }

    private static synchronized <X> IConverter<X> calculateURLConverter(Class<X> totype) {
        Class<X> ctype = totype;
        do {
            IConverter<?> c;
            if ((c = m_urlConverterMap.get(ctype)) != null) {
                return c;
            }
            c = ConverterRegistry.scanInterfaces(ctype);
            if (c == null) continue;
            return c;
        } while ((ctype = ctype.getSuperclass()) != null && Object.class != ctype);
        return null;
    }

    private static synchronized IConverter<?> scanInterfaces(Class<?> ctype) {
        Class<?>[] intar;
        for (Class<?> iclz : intar = ctype.getInterfaces()) {
            IConverter<?> c = m_urlConverterMap.get(iclz);
            if (c == null) continue;
            return c;
        }
        for (Class<?> iclz : intar) {
            for (Class<?> pint = iclz.getSuperclass(); pint != null && pint != Object.class; pint = pint.getSuperclass()) {
                IConverter<?> c = m_urlConverterMap.get(pint);
                if (c == null) continue;
                return c;
            }
        }
        return null;
    }

    public static synchronized <X> IConverter<X> findURLConverter(Class<X> totype) {
        IConverter<Object> c = m_urlConverterMap.get(totype);
        if (c != null) {
            return c;
        }
        c = ConverterRegistry.calculateURLConverter(totype);
        m_urlConverterMap.put(totype, c);
        return c;
    }

    public static <X> X convertURLStringToValue(Class<X> toType, String svalue) throws Exception {
        IConverter<X> c = ConverterRegistry.findURLConverter(toType);
        if (c == null) {
            return (X)RuntimeConversions.convertTo((Object)svalue, toType);
        }
        return (X)c.convertStringToObject(NlsContext.getLocale(), svalue);
    }

    public static synchronized void register(IConverterFactory cf) {
        if (m_factoryList.contains(cf)) {
            return;
        }
        m_factoryList = new ArrayList<IConverterFactory>(m_factoryList);
        m_factoryList.add(cf);
    }

    private static synchronized List<IConverterFactory> getFactoryList() {
        return m_factoryList;
    }

    static synchronized IConverterFactory getDefaultFactory() {
        return m_defaultConverterFactory;
    }

    static synchronized void setDefaultFactory(IConverterFactory f) {
        if (f == null) {
            throw new NullPointerException("Default converter CANNOT BE NULL!!");
        }
        m_defaultConverterFactory = f;
        m_converterMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IConverterFactory findFactory(Class<?> clz, PropertyMetaModel<?> pmm) {
        Class<ConverterRegistry> clazz = ConverterRegistry.class;
        synchronized (ConverterRegistry.class) {
            ArrayList<IConverterFactory> flist = new ArrayList<IConverterFactory>();
            IConverterFactory best = null;
            int bestscore = 0;
            for (IConverterFactory cf : ConverterRegistry.getFactoryList()) {
                int score = cf.accept(clz, pmm);
                if (score < 0) continue;
                flist.add(cf);
                if (score <= bestscore) continue;
                best = cf;
                bestscore = score;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return best;
        }
    }

    private static IConverterFactory getFactory(Class<?> clz, PropertyMetaModel<?> pmm) {
        IConverterFactory cf = ConverterRegistry.findFactory(clz, pmm);
        return cf == null ? ConverterRegistry.getDefaultFactory() : cf;
    }

    public static <X> IConverter<X> findConverter(Class<X> clz, PropertyMetaModel<X> pmm) {
        IConverterFactory cf = ConverterRegistry.findFactory(clz, pmm);
        if (cf == null) {
            return null;
        }
        return cf.createConverter(clz, pmm);
    }

    public static <X> IConverter<X> findConverter(Class<X> clz) {
        return ConverterRegistry.findConverter(clz, null);
    }

    public static <X> IConverter<X> getConverter(Class<X> clz, PropertyMetaModel<X> pmm) {
        IConverterFactory cf = ConverterRegistry.getFactory(clz, pmm);
        return cf.createConverter(clz, pmm);
    }

    public static <X> String convertToString(PropertyMetaModel<X> pmm, X value) {
        IConverter<X> conv = ConverterRegistry.getConverter(pmm.getActualType(), pmm);
        return conv.convertObjectToString(NlsContext.getLocale(), value);
    }

    public static <X> IConverter<X> findBestConverter(PropertyMetaModel<X> pmm) {
        if (pmm.getConverter() != null) {
            return pmm.getConverter();
        }
        return ConverterRegistry.findConverter(pmm.getActualType(), pmm);
    }

    public static synchronized <T> void registerComparator(@Nonnull Comparator<T> comp, Class<?> ... valueClass) {
        m_comparatorMap = new HashMap(m_comparatorMap);
        for (Class<?> clz : valueClass) {
            m_comparatorMap.put(clz, comp);
        }
    }

    private static synchronized Map<Class<?>, Comparator<?>> getComparatorMap() {
        return m_comparatorMap;
    }

    public static <T> Comparator<T> getComparator(@Nonnull Class<T> dataClass, @Nonnull String property, boolean descending) {
        ClassMetaModel cmm = MetaManager.findClassMeta(dataClass);
        return ConverterRegistry.getComparator(cmm, property, descending);
    }

    public static Comparator<?> getComparator(@Nonnull ClassMetaModel cmm, @Nonnull String property, boolean descending) {
        String[] ar = property.split(";");
        ArrayList all = new ArrayList();
        for (String pn : ar) {
            PropertyMetaModel<?> pmm;
            pn = pn.trim();
            boolean desc = descending;
            int pos = pn.indexOf(58);
            if (pos > 0) {
                String s = pn.substring(pos + 1);
                pn = pn.substring(0, pos);
                if ("a".equalsIgnoreCase(s)) {
                    desc = false;
                } else if ("d".equalsIgnoreCase(s)) {
                    desc = true;
                }
            }
            if (null == (pmm = cmm.findProperty(pn))) {
                throw new ProgrammerErrorException("The property '" + cmm + "." + property + "' is not known.");
            }
            Comparator<Object> comp = ConverterRegistry.findComparatorForType(pmm.getActualType());
            if (null == comp) {
                comp = DEFAULT_COMPARATOR;
            }
            all.add(new PropertyComparator(pmm, comp, descending));
        }
        if (all.size() == 1) {
            return (Comparator)all.get(0);
        }
        return new CompoundComparator(all, false);
    }

    private static Comparator<?> findComparatorForType(Class<?> actualType) {
        Map<Class<?>, Comparator<?>> cm = ConverterRegistry.getComparatorMap();
        for (Class<?> t = actualType; t != null; t = t.getSuperclass()) {
            Comparator<?> c = cm.get(t);
            if (null == c) continue;
            return c;
        }
        for (Class<?> ifc : actualType.getInterfaces()) {
            Comparator<?> c = ConverterRegistry.findComparatorForType(ifc);
            if (null == c) continue;
            return c;
        }
        return null;
    }

    static {
        ConverterRegistry.setDefaultFactory(new DefaultConverterFactory());
        ConverterRegistry.register(new DomainListConverterFactory());
        ConverterRegistry.register(new DateConverterFactory());
        ConverterRegistry.register(new MoneyConverterFactory());
        ConverterRegistry.register(new DoubleFactory());
        ConverterRegistry.register(new EnumFactory());
        ConverterRegistry.register(new BooleanConverterFactory());
        ConverterRegistry.registerURLConverter(Boolean.class, BooleanConverter.getInstance());
        ConverterRegistry.registerURLConverter(Boolean.TYPE, BooleanConverter.getInstance());
        ConverterRegistry.registerURLConverter(Date.class, DateUrlParamConverter.getInstance());
        m_comparatorMap = new HashMap();
        DEFAULT_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                if (a == null) {
                    return b == null ? 0 : 1;
                }
                if (b == null) {
                    return -1;
                }
                if (a instanceof Comparable && b instanceof Comparable) {
                    return ((Comparable)a).compareTo(b);
                }
                return a.toString().compareTo(b.toString());
            }
        };
        Comparator<Number> comp = new Comparator<Number>(){

            @Override
            public int compare(Number a, Number b) {
                if (null == a) {
                    if (null == b) {
                        return 0;
                    }
                    return -1;
                }
                if (null == b) {
                    return 1;
                }
                long res = a.longValue() - b.longValue();
                if (res == 0L) {
                    return 0;
                }
                return res < 0L ? -1 : 1;
            }
        };
        ConverterRegistry.registerComparator(comp, Long.class, Long.TYPE, Integer.class, Integer.TYPE, Short.class, Short.TYPE, Character.class, Character.TYPE);
        Comparator<Number> comp2 = new Comparator<Number>(){

            @Override
            public int compare(Number a, Number b) {
                if (a == null) {
                    return b == null ? 0 : 1;
                }
                if (b == null) {
                    return -1;
                }
                double res = a.doubleValue() - b.doubleValue();
                if (res == 0.0) {
                    return 0;
                }
                return res < 0.0 ? -1 : 1;
            }
        };
        ConverterRegistry.registerComparator(comp2, Double.class, Double.TYPE, Float.class, Float.TYPE);
    }
}

