/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import to.etc.domui.converter.IConverter;
import to.etc.domui.trouble.UIException;
import to.etc.domui.trouble.ValidationException;
import to.etc.util.CalculationUtil;

public class DateConverter
implements IConverter<Date> {
    private static final ThreadLocal<DateFormat> m_format = new ThreadLocal();
    private static final String DATE_PATTERN_NL = "dd-MM-yyyy";
    private static final String DATE_PATTERN_EN = "yyyy-MM-dd";

    private static DateFormat getFormatter() {
        DateFormat df = m_format.get();
        if (df == null) {
            df = new SimpleDateFormat(DATE_PATTERN_NL);
            m_format.set(df);
        }
        return df;
    }

    @Override
    public String convertObjectToString(Locale loc, Date in) throws UIException {
        if (in == null) {
            return "";
        }
        Date dt = in;
        if (loc.getLanguage().equalsIgnoreCase("nl")) {
            return DateConverter.getFormatter().format(dt);
        }
        if (loc.getLanguage().equalsIgnoreCase("en")) {
            return new SimpleDateFormat(DATE_PATTERN_EN).format(dt);
        }
        DateFormat df = DateFormat.getDateInstance(3, loc);
        return df.format(dt);
    }

    @Override
    public Date convertStringToObject(Locale loc, String input) throws UIException {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).length() == 0) {
            return null;
        }
        String datePattern = null;
        try {
            if (loc.getLanguage().equalsIgnoreCase("nl")) {
                datePattern = DATE_PATTERN_NL;
                return CalculationUtil.dutchDate((String)input);
            }
            if (loc.getLanguage().equalsIgnoreCase("en")) {
                datePattern = DATE_PATTERN_EN;
                SimpleDateFormat enDateFormat = new SimpleDateFormat(DATE_PATTERN_EN);
                enDateFormat.setLenient(false);
                return enDateFormat.parse(input);
            }
            DateFormat dateFormat = DateFormat.getDateInstance(3, loc);
            datePattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toLocalizedPattern() : "Internal: unknown date format!";
            dateFormat.setLenient(false);
            return dateFormat.parse(input);
        }
        catch (Exception x) {
            throw new ValidationException("v.invalid.date", datePattern);
        }
    }
}

