/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import to.etc.domui.converter.IConverter;
import to.etc.domui.trouble.UIException;
import to.etc.domui.trouble.ValidationException;
import to.etc.util.CalculationUtil;

public class DateTimeConverter
implements IConverter<Date> {
    private static final String DATE_PATTERN_NL = "dd-MM-yyyy HH:mm";
    private static final String DATE_PATTERN_EN = "yyyy-MM-dd HH:mm";
    private static final ThreadLocal<DateFormat> m_format = new ThreadLocal();

    private static DateFormat getFormatter() {
        DateFormat df = m_format.get();
        if (df == null) {
            df = new SimpleDateFormat(DATE_PATTERN_NL);
            m_format.set(df);
        }
        return df;
    }

    @Override
    public String convertObjectToString(Locale loc, Date in) throws UIException {
        if (in == null) {
            return "";
        }
        Date dt = in;
        if (loc.getLanguage().equalsIgnoreCase("nl")) {
            return DateTimeConverter.getFormatter().format(dt);
        }
        if (loc.getLanguage().equalsIgnoreCase("en")) {
            return new SimpleDateFormat(DATE_PATTERN_EN).format(dt);
        }
        DateFormat df = DateFormat.getDateTimeInstance(3, 3, loc);
        return df.format(dt);
    }

    @Override
    public Date convertStringToObject(Locale loc, String input) throws UIException {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).length() == 0) {
            return null;
        }
        DateFormat df = null;
        String datePattern = null;
        try {
            if (loc.getLanguage().equalsIgnoreCase("nl")) {
                datePattern = DATE_PATTERN_NL;
                df = new SimpleDateFormat(DATE_PATTERN_NL);
                return CalculationUtil.dutchDateAndTime((String)input);
            }
            if (loc.getLanguage().equalsIgnoreCase("en")) {
                datePattern = DATE_PATTERN_EN;
                df = new SimpleDateFormat(DATE_PATTERN_EN);
            } else {
                df = DateFormat.getDateTimeInstance(3, 3, loc);
            }
            df.setLenient(false);
            return df.parse(input);
        }
        catch (Exception x) {
            if (datePattern == null && df != null) {
                datePattern = df.format(new Date());
            }
            throw new ValidationException("v.invalid.date", datePattern);
        }
    }
}

