/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.util.Date;
import java.util.Locale;
import javax.annotation.Nonnull;
import to.etc.domui.converter.IConverter;
import to.etc.domui.trouble.UIException;
import to.etc.domui.util.DomUtil;
import to.etc.util.StringTool;

class DateUrlParamConverter
implements IConverter<Date> {
    @Nonnull
    private static final DateUrlParamConverter INSTANCE = new DateUrlParamConverter();

    DateUrlParamConverter() {
    }

    @Nonnull
    public static final DateUrlParamConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public String convertObjectToString(Locale loc, Date in) throws UIException {
        if (in == null) {
            return "";
        }
        return in.getTime() + "";
    }

    @Override
    public Date convertStringToObject(Locale loc, String input) throws UIException {
        if (StringTool.isBlank((String)input)) {
            return null;
        }
        input = DomUtil.nullChecked(input.trim());
        try {
            return new Date(Long.parseLong(input));
        }
        catch (NumberFormatException x) {
            throw new IllegalStateException("Unreasonable text conversion from string to Date, expected long value while found:" + input, x);
        }
    }
}

