/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.util.Locale;
import to.etc.domui.converter.IConverter;
import to.etc.domui.trouble.UIException;
import to.etc.domui.trouble.ValidationException;
import to.etc.util.StringTool;

public class DoubleSizeConverter
implements IConverter<Double> {
    private final double m_factor;

    public DoubleSizeConverter() {
        this.m_factor = 1.0;
    }

    public DoubleSizeConverter(double factor) {
        this.m_factor = factor;
    }

    @Override
    public String convertObjectToString(Locale loc, Double in) throws UIException {
        if (null == in) {
            return null;
        }
        return StringTool.strSize((long)((long)(in * this.m_factor)));
    }

    @Override
    public Double convertStringToObject(Locale loc, String val) throws UIException {
        int lindex;
        if ((val = val.trim()).length() == 0) {
            throw new ValidationException("v.invalid", new Object[0]);
        }
        for (lindex = val.length(); lindex > 0 && !Character.isDigit(val.charAt(lindex - 1)); --lindex) {
        }
        if (lindex <= 0) {
            throw new ValidationException("v.invalid", new Object[0]);
        }
        String f = val.substring(lindex).trim().toLowerCase();
        if (f.length() > 1) {
            f = f.substring(0, 1);
        }
        val = val.substring(0, lindex).trim();
        double size = Double.parseDouble(val);
        if ("k".equals(f)) {
            size *= 1024.0;
        } else if ("m".equals(f)) {
            size *= 1048576.0;
        } else if ("g".equals(f)) {
            size *= 1.073741824E9;
        } else if ("t".equals(f)) {
            size *= 1.099511627776E12;
        } else if (f.length() != 0) {
            throw new ValidationException("v.invalid", new Object[0]);
        }
        return size / this.m_factor;
    }
}

