/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.util.Locale;
import to.etc.domui.converter.IConverter;
import to.etc.domui.trouble.UIException;
import to.etc.domui.trouble.ValidationException;
import to.etc.util.StringTool;

public class LongSizeConverter
implements IConverter<Long> {
    @Override
    public String convertObjectToString(Locale loc, Long in) throws UIException {
        if (null == in) {
            return null;
        }
        return StringTool.strSize((long)in);
    }

    @Override
    public Long convertStringToObject(Locale loc, String val) throws UIException {
        int lindex;
        if ((val = val.trim()).length() == 0) {
            throw new ValidationException("v.invalid", new Object[0]);
        }
        for (lindex = val.length(); lindex > 0 && !Character.isDigit(val.charAt(lindex - 1)); --lindex) {
        }
        if (lindex <= 0) {
            throw new ValidationException("v.invalid", new Object[0]);
        }
        String f = val.substring(lindex).toLowerCase().trim();
        val = val.substring(0, lindex);
        double size = Double.parseDouble(val);
        if ("k".equals(f) || "kb".equals(f)) {
            size *= 1024.0;
        } else if ("m".equals(f) || "mb".equals(f)) {
            size *= 1048576.0;
        } else if ("g".equals(f) || "gb".equals(f)) {
            size *= 1.073741824E9;
        } else if ("t".equals(f) || "tb".equals(f)) {
            size *= 1.099511627776E12;
        } else if (f.length() != 0) {
            throw new ValidationException("v.invalid", new Object[0]);
        }
        return (long)size;
    }
}

