/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.util.Date;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.converter.DateConverter;
import to.etc.domui.converter.IValueValidator;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.trouble.ValidationException;
import to.etc.util.DateUtil;
import to.etc.webapp.nls.NlsContext;

@DefaultNonNull
public final class MaxMinDateValidator
implements IValueValidator<Date> {
    @Nullable
    private final Date m_minDate;
    @Nullable
    private final Date m_maxDate;
    @Nullable
    private final UIMessage m_minDateMsg;
    @Nullable
    private final UIMessage m_maxDateMsg;

    private MaxMinDateValidator(Builder b) {
        this.m_minDate = b.m_min;
        this.m_maxDate = b.m_max;
        this.m_minDateMsg = b.m_minMsg;
        this.m_maxDateMsg = b.m_maxMsg;
    }

    @Override
    public void validate(@Nullable Date input) throws Exception {
        Date max;
        if (input == null) {
            return;
        }
        Date min = this.m_minDate;
        if (null != min && input.before(min)) {
            this.throwError("v.toosmall", min, this.m_minDateMsg);
        }
        if (null != (max = this.m_maxDate) && input.after(max)) {
            this.throwError("v.toolarge", max, this.m_maxDateMsg);
        }
    }

    private void throwError(@Nonnull String code, @Nonnull Date val, @Nullable UIMessage msg) {
        if (msg != null) {
            throw new ValidationException(msg.getBundle(), msg.getCode(), msg.getParameters());
        }
        DateConverter dc = new DateConverter();
        throw new ValidationException(code, dc.convertObjectToString(NlsContext.getLocale(), val));
    }

    public static class Builder {
        @Nullable
        private Date m_min;
        @Nullable
        private Date m_max;
        @Nullable
        private UIMessage m_minMsg;
        @Nullable
        private UIMessage m_maxMsg;

        public Builder minimumDate(@Nonnull Date minDate) {
            this.m_min = DateUtil.truncateDate((Date)minDate);
            return this;
        }

        public Builder maximumDate(@Nonnull Date maxDate) {
            this.m_max = DateUtil.truncateDate((Date)maxDate);
            return this;
        }

        public Builder minimumMessage(@Nonnull UIMessage minMsg) {
            this.m_minMsg = minMsg;
            return this;
        }

        public Builder maximumMessage(@Nonnull UIMessage maxMsg) {
            this.m_maxMsg = maxMsg;
            return this;
        }

        @Nonnull
        public MaxMinDateValidator build() throws Exception {
            if (null == this.m_max && null == this.m_min) {
                throw new IllegalArgumentException("MaxDate or MinDate is mandatory");
            }
            if (null != this.m_max && null != this.m_min && this.m_min.after(this.m_max)) {
                throw new IllegalArgumentException("MaxDate cannot be smaller than MinDate");
            }
            return new MaxMinDateValidator(this);
        }
    }
}

