/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.text.NumberFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.converter.IValueValidator;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.trouble.ValidationException;
import to.etc.webapp.nls.NlsContext;

public class MaxMinValidator
implements IValueValidator<Number> {
    @Nonnull
    private Number m_max;
    @Nonnull
    private Number m_min;
    @Nullable
    private final UIMessage m_msg;

    public MaxMinValidator(@Nonnull Number min, @Nonnull Number max, @Nullable UIMessage msg) {
        this.m_max = max;
        this.m_min = min;
        this.m_msg = msg;
    }

    public MaxMinValidator(@Nonnull Number min, @Nonnull Number max) {
        this(min, max, null);
    }

    @Override
    public void validate(Number input) throws Exception {
        Class<?> ac = input.getClass();
        if (this.m_max.getClass() == ac && this.m_min.getClass() == ac && input instanceof Comparable) {
            int r = ((Comparable)((Object)input)).compareTo(this.m_min);
            if (r < 0) {
                this.throwError("v.toosmall", this.m_min);
            }
            if ((r = ((Comparable)((Object)input)).compareTo(this.m_max)) > 0) {
                this.throwError("v.toolarge", this.m_max);
            }
        } else {
            if (input.doubleValue() > this.m_max.doubleValue()) {
                this.throwError("v.toolarge", this.m_max);
            }
            if (input.doubleValue() < this.m_min.doubleValue()) {
                this.throwError("v.toosmall", this.m_min);
            }
        }
    }

    private void throwError(@Nonnull String code, @Nonnull Number val) {
        UIMessage msg = this.m_msg;
        if (msg != null) {
            throw new ValidationException(msg.getBundle(), msg.getCode(), msg.getParameters());
        }
        throw new ValidationException(code, NumberFormat.getInstance(NlsContext.getLocale()).format(val));
    }
}

