/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.webapp.nls.NlsContext;

public class MiniScanner {
    private static ThreadLocal<MiniScanner> m_current = new ThreadLocal();
    private String m_in;
    private int m_len;
    private int m_ix;
    private int m_val;
    private StringBuilder m_buffer = new StringBuilder(128);

    public static MiniScanner getInstance() {
        MiniScanner ms = m_current.get();
        if (ms == null) {
            ms = new MiniScanner();
            m_current.set(ms);
        }
        return ms;
    }

    public void init(String in) {
        this.m_in = in.trim();
        this.m_ix = 0;
        this.m_len = this.m_in.length();
        if (this.m_buffer.length() > 256) {
            this.m_buffer = new StringBuilder(128);
        } else {
            this.m_buffer.setLength(0);
        }
    }

    public int LA() {
        if (this.m_ix >= this.m_len) {
            return -1;
        }
        return 0xFFFF & this.m_in.charAt(this.m_ix);
    }

    public int LA(int ix) {
        if (this.m_ix + ix >= this.m_len) {
            return -1;
        }
        return 0xFFFF & this.m_in.charAt(this.m_ix + ix);
    }

    public boolean accept() {
        if (this.m_ix < this.m_len) {
            ++this.m_ix;
        }
        return this.m_ix < this.m_len;
    }

    public boolean copy() {
        if (this.m_ix >= this.m_len) {
            return false;
        }
        this.m_buffer.append(this.m_in.charAt(this.m_ix++));
        return this.m_ix < this.m_len;
    }

    public void copy(int i) {
        while (i-- > 0) {
            this.copy();
        }
    }

    public boolean skip(char c) {
        if (this.LA() == (c & 0xFFFF)) {
            this.accept();
            return true;
        }
        return false;
    }

    public boolean eof() {
        return this.m_ix >= this.m_len;
    }

    public String getStringResult() {
        String s = this.m_buffer.toString();
        if (this.m_buffer.length() > 256) {
            this.m_buffer = new StringBuilder(128);
        } else {
            this.m_buffer.setLength(0);
        }
        return s;
    }

    public boolean eofSkipWS() {
        if (this.eof()) {
            return true;
        }
        for (int ix = this.m_ix; ix < this.m_len; ++ix) {
            char c = this.m_in.charAt(ix);
            if (DomUtil.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public boolean scanLaxWithCurrencySign(String in, int scale, boolean useStrictScale) throws ValidationException {
        return this.scanLax(in, true, scale, useStrictScale);
    }

    public boolean scanLaxNumber(String input, int scale, boolean useStrictScale) throws ValidationException {
        return this.scanLax(input, false, scale, useStrictScale);
    }

    private boolean scanCurrencySign() {
        if (this.skip('\u20ac')) {
            return true;
        }
        String cs = NlsContext.getCurrencySymbol();
        for (int i = 0; i < cs.length(); ++i) {
            if (this.skip(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean scanLax(String in, boolean monetary, int scale, boolean useStrictScale) throws ValidationException {
        this.init(in.trim());
        boolean haseur = this.scanCurrencySign();
        this.skipWs();
        if (this.eof()) {
            if (haseur) {
                this.badamount(monetary);
            }
            return false;
        }
        if (haseur && !monetary) {
            this.badnumber();
        }
        if (this.skip('-')) {
            this.m_buffer.append('-');
            this.skipWs();
        } else if (this.m_in.endsWith("-")) {
            this.m_buffer.append('-');
            --this.m_len;
        }
        int cix = 0;
        int dotct = 0;
        int commact = 0;
        int lastdotix = -1;
        int lastcommaix = -1;
        int ndigits = 0;
        while (!this.eof()) {
            char c = (char)this.LA();
            if (c == ',') {
                if (++commact > 1) {
                    if (dotct > 1) {
                        this.badamount(monetary);
                    }
                    if (lastcommaix + 4 != cix) {
                        this.badamount(monetary);
                    }
                }
                lastcommaix = cix;
                this.accept();
            } else if (c == '.') {
                if (++dotct > 1) {
                    if (commact > 1) {
                        this.badamount(monetary);
                    }
                    if (lastdotix + 4 != cix) {
                        this.badamount(monetary);
                    }
                }
                lastdotix = cix;
                this.accept();
            } else if (Character.isDigit(c)) {
                this.copy();
                ++ndigits;
            } else {
                this.badamount(monetary);
            }
            ++cix;
        }
        if (ndigits == 0) {
            this.badamount(monetary);
        }
        if (dotct == 0 && commact == 0) {
            if (scale > 0 && useStrictScale) {
                this.badamount(monetary);
            }
            return true;
        }
        if (dotct > 1 && commact > 1) {
            throw new IllegalStateException("Programmer's blunder: dotct=" + dotct + ", commact=" + commact);
        }
        int decimalpos = -1;
        int lastthoupos = -1;
        if (dotct > 1) {
            lastthoupos = lastdotix;
            if (commact > 0) {
                decimalpos = lastcommaix;
            }
        } else if (commact > 1) {
            lastthoupos = lastcommaix;
            if (dotct > 0) {
                decimalpos = lastdotix;
            }
        } else if (dotct == 1 && commact == 0 || dotct == 0 && commact == 1) {
            int lastDotOrComma;
            int delta = (dotct == 1 ? cix - lastdotix : cix - lastcommaix) - 1;
            int n = lastDotOrComma = dotct == 1 ? lastdotix : lastcommaix;
            if (delta <= 2) {
                if (useStrictScale && scale != delta) {
                    this.badamount(monetary);
                }
                decimalpos = lastDotOrComma;
            } else if (delta == 3) {
                if (scale == 0) {
                    if (ndigits <= 3) {
                        this.badamount(monetary);
                    }
                    lastthoupos = lastDotOrComma;
                } else if (scale == 3 && useStrictScale) {
                    if (delta < 3) {
                        this.badamount(monetary);
                    }
                    decimalpos = lastDotOrComma;
                } else if (useStrictScale) {
                    this.badamount(monetary);
                } else if (scale >= 3) {
                    decimalpos = lastDotOrComma;
                }
            } else if (delta > scale) {
                this.badamount(monetary);
            } else if (delta == scale) {
                decimalpos = lastDotOrComma;
            } else if (useStrictScale) {
                this.badamount(monetary);
            } else {
                decimalpos = lastDotOrComma;
            }
        } else {
            int cdelta = cix - lastcommaix - 1;
            int ddelta = cix - lastdotix - 1;
            if (lastcommaix - lastdotix == 4) {
                if (cdelta == scale || cdelta < scale && !useStrictScale) {
                    decimalpos = lastcommaix;
                } else {
                    this.badamount(monetary);
                }
            } else if (lastdotix - lastcommaix == 4) {
                if (ddelta == scale || ddelta < scale && !useStrictScale) {
                    decimalpos = lastdotix;
                } else {
                    this.badamount(monetary);
                }
            } else {
                this.badamount(monetary);
            }
        }
        if (decimalpos == -1) {
            if (lastthoupos != -1 && cix - lastthoupos != 4) {
                this.badamount(monetary);
            }
            if (scale > 0 && useStrictScale) {
                this.badamount(monetary);
            }
        } else {
            int ddelta = cix - decimalpos - 1;
            if (ddelta > scale) {
                this.badamount(monetary);
            }
            if (ddelta < scale && useStrictScale) {
                this.badamount(monetary);
            }
            if (lastthoupos != -1 && decimalpos - lastthoupos != 4) {
                this.badamount(monetary);
            }
            if (ddelta > 0) {
                this.m_buffer.insert(this.m_buffer.length() - ddelta, '.');
            }
        }
        return true;
    }

    private void badnumber() throws ValidationException {
        throw new ValidationException("v.invalid", this.m_in);
    }

    private void badamount(boolean monetary) {
        throw new ValidationException(monetary ? "v.bad.amount" : "v.invalid", this.m_in);
    }

    private char nextNumberDelimiter() {
        this.skipWs();
        if (this.m_ix >= this.m_len) {
            return '\u0000';
        }
        this.m_val = 0;
        int c = 32;
        while (this.m_ix < this.m_len && Character.isDigit((char)(c = (int)this.m_in.charAt(this.m_ix)))) {
            this.m_val = this.m_val * 10 + (c - 48);
            c = 32;
            ++this.m_ix;
        }
        this.skipWs();
        if (this.m_ix < this.m_len) {
            if (Character.isDigit((char)(c = this.m_in.charAt(this.m_ix++)))) {
                throw new IllegalStateException("invalid: # without separators.");
            }
        } else {
            c = 1;
        }
        return (char)c;
    }

    public int val() {
        return this.m_val;
    }

    public long scanDuration(String in) {
        this.init(in);
        long res = 0L;
        while (true) {
            int c;
            if ((c = this.nextNumberDelimiter()) == 1) {
                return this.val() * 60;
            }
            if (c == 68 || c == 100) {
                res += (long)this.val() * 24L * 60L * 60L;
                c = this.nextNumberDelimiter();
                continue;
            }
            if (c == 72 || c == 104 || c == 85 || c == 117) {
                res += (long)this.val() * 60L * 60L;
                c = this.nextNumberDelimiter();
                continue;
            }
            if (c == 115 || c == 83) {
                res += (long)this.val();
                c = this.nextNumberDelimiter();
                continue;
            }
            if (c == 0) {
                return res;
            }
            if (c != 58) break;
            res += (long)(this.val() * 60) * 60L;
            c = this.nextNumberDelimiter();
            c = 83;
        }
        throw new ValidationException("v.invalid.date", "(Voorbeeld: 5d 8h)");
    }

    public void skipWs() {
        while (this.m_ix < this.m_len) {
            char c = this.m_in.charAt(this.m_ix);
            if (!DomUtil.isWhitespace(c)) {
                return;
            }
            ++this.m_ix;
        }
    }

    public boolean match(String s) {
        if (s.length() > this.m_len - this.m_ix) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if ((s.charAt(i) & 0xFFFF) == this.LA(i)) continue;
            return false;
        }
        this.copy(s.length());
        return true;
    }
}

