/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import to.etc.domui.converter.IConverter;
import to.etc.domui.trouble.UIException;
import to.etc.domui.trouble.ValidationException;
import to.etc.webapp.nls.NlsContext;

public class MinutesConverter
implements IConverter<Integer> {
    @Override
    public String convertObjectToString(Locale loc, Integer in) throws UIException {
        if (in == null) {
            return null;
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(NlsContext.getLocale());
        int hours = in / 60;
        double mins = in.doubleValue() % 60.0;
        double value = (double)hours + mins / 100.0;
        DecimalFormat df = new DecimalFormat("##0.00", dfs);
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(value));
        return sb.toString();
    }

    @Override
    public Integer convertStringToObject(Locale loc, String in) throws UIException {
        if (in == null) {
            return null;
        }
        in = in.trim();
        if (!(in = in.replace(',', '.')).startsWith(".") & !in.endsWith(".")) {
            try {
                BigDecimal mins;
                BigDecimal value = new BigDecimal(in);
                BigDecimal hours = new BigDecimal(Math.floor(value.doubleValue()));
                int numDec = 0;
                int index = in.indexOf(46);
                if (index >= 0) {
                    numDec = in.length() - 1 - index;
                }
                if (numDec == 2 && (mins = value.subtract(hours).multiply(new BigDecimal(100))).compareTo(BigDecimal.ZERO) >= 0 && mins.compareTo(new BigDecimal(60)) < 0) {
                    value = hours.multiply(new BigDecimal(60)).add(mins);
                    return value.intValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ValidationException("v.no.re.match", "HH[.|,]MM");
    }
}

