/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.math.BigDecimal;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.IConverter;
import to.etc.domui.converter.IConverterFactory;
import to.etc.domui.converter.MoneyBigDecimalFullConverter;
import to.etc.domui.converter.MoneyBigDecimalNoSign;
import to.etc.domui.converter.MoneyBigDecimalNumeric;
import to.etc.domui.converter.MoneyBigDecimalTruncatedWithSign;
import to.etc.domui.converter.MoneyDoubleFullConverter;
import to.etc.domui.converter.MoneyDoubleNoSign;
import to.etc.domui.converter.MoneyDoubleNumeric;
import to.etc.domui.converter.MoneyDoubleTruncatedWithSign;
import to.etc.util.WrappedException;

public class MoneyConverterFactory
implements IConverterFactory {
    @Override
    public int accept(Class<?> clz, PropertyMetaModel<?> pmm) {
        if (pmm == null) {
            return -1;
        }
        if (clz != Double.class && clz != Double.TYPE && clz != BigDecimal.class) {
            return -1;
        }
        switch (pmm.getNumericPresentation()) {
            default: {
                return -1;
            }
            case MONEY: 
            case MONEY_FULL: 
            case MONEY_FULL_TRUNC: 
            case MONEY_NO_SYMBOL: 
            case MONEY_NUMERIC: 
        }
        return 10;
    }

    public static IConverter<Double> createDoubleMoneyConverters(NumericPresentation np) {
        switch (np) {
            default: {
                throw new IllegalStateException("? Dont know converter: " + (Object)((Object)np));
            }
            case MONEY: 
            case MONEY_FULL: {
                return ConverterRegistry.getConverterInstance(MoneyDoubleFullConverter.class);
            }
            case MONEY_FULL_TRUNC: {
                return ConverterRegistry.getConverterInstance(MoneyDoubleTruncatedWithSign.class);
            }
            case MONEY_NO_SYMBOL: {
                return ConverterRegistry.getConverterInstance(MoneyDoubleNoSign.class);
            }
            case MONEY_NUMERIC: 
        }
        return ConverterRegistry.getConverterInstance(MoneyDoubleNumeric.class);
    }

    public static IConverter<BigDecimal> createBigDecimalMoneyConverters(NumericPresentation np) {
        switch (np) {
            default: {
                throw new IllegalStateException("? Dont know converter: " + (Object)((Object)np));
            }
            case MONEY: 
            case MONEY_FULL: {
                return ConverterRegistry.getConverterInstance(MoneyBigDecimalFullConverter.class);
            }
            case MONEY_FULL_TRUNC: {
                return ConverterRegistry.getConverterInstance(MoneyBigDecimalTruncatedWithSign.class);
            }
            case MONEY_NO_SYMBOL: {
                return ConverterRegistry.getConverterInstance(MoneyBigDecimalNoSign.class);
            }
            case MONEY_NUMERIC: 
        }
        return ConverterRegistry.getConverterInstance(MoneyBigDecimalNumeric.class);
    }

    @Override
    public <X, T extends IConverter<X>> T createConverter(Class<X> clz, PropertyMetaModel<X> pmm) {
        try {
            if (clz == Double.class || clz == Double.TYPE) {
                return (T)MoneyConverterFactory.createDoubleMoneyConverters(pmm.getNumericPresentation());
            }
            if (clz == BigDecimal.class) {
                return (T)MoneyConverterFactory.createBigDecimalMoneyConverters(pmm.getNumericPresentation());
            }
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
        throw new IllegalStateException("? Dont know converter?");
    }
}

