/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import javax.annotation.Nonnull;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.converter.IConvertable;
import to.etc.domui.converter.MiniScanner;
import to.etc.domui.converter.MoneyConverterFactory;
import to.etc.domui.util.DomUtil;
import to.etc.webapp.nls.NlsContext;

public class MoneyUtil {
    public static <T> T parseMoney(Class<T> valueClass, String in) {
        if (DomUtil.isDoubleOrWrapper(valueClass)) {
            return (T)MoneyUtil.parseEuroToDoubleW(in);
        }
        if (BigDecimal.class == valueClass) {
            return (T)MoneyUtil.parseEuroToBigDecimal(in);
        }
        throw new IllegalArgumentException("The value class " + valueClass + " is not a valid monetary type");
    }

    public static int getMoneyScale() {
        return NlsContext.getCurrency().getDefaultFractionDigits();
    }

    public static RoundingMode getRoundingMode() {
        if (!NlsContext.getCurrency().getCurrencyCode().equalsIgnoreCase("EUR")) {
            return NumberFormat.getCurrencyInstance(NlsContext.getCurrencyLocale()).getRoundingMode();
        }
        return RoundingMode.HALF_EVEN;
    }

    @Deprecated
    public static Double parseEuroToDoubleW(String input) {
        return MoneyUtil.parseEuroToDoubleW(input, MoneyUtil.getMoneyScale(), false);
    }

    @Deprecated
    public static Double parseEuroToDoubleW(String input, int scale, boolean useStrictScale) {
        MiniScanner ms = MiniScanner.getInstance();
        if (!ms.scanLaxWithCurrencySign(input, scale, useStrictScale)) {
            return null;
        }
        return Double.valueOf(ms.getStringResult());
    }

    public static BigDecimal parseEuroToBigDecimal(String input) {
        return MoneyUtil.parseEuroToBigDecimal(input, MoneyUtil.getMoneyScale(), false);
    }

    public static BigDecimal parseEuroToBigDecimal(String input, int scale, boolean useStrictScale) {
        MiniScanner ms = MiniScanner.getInstance();
        if (!ms.scanLaxWithCurrencySign(input, scale, useStrictScale)) {
            return null;
        }
        return new BigDecimal(ms.getStringResult());
    }

    @Deprecated
    public static String renderAsSimpleDotted(double v) {
        BigDecimal bd = BigDecimal.valueOf(v);
        return bd.setScale(MoneyUtil.getMoneyScale(), MoneyUtil.getRoundingMode()).toString();
    }

    @Deprecated
    public static String render(double v, boolean thousands, boolean symbol, boolean trunk) {
        return MoneyUtil.render(BigDecimal.valueOf(v), thousands, symbol, trunk);
    }

    public static String render(BigDecimal v, boolean thousands, boolean symbol, boolean trunk) {
        String s;
        DecimalFormat df;
        String fracmask;
        StringBuilder sb = new StringBuilder(20);
        Currency c = NlsContext.getCurrency();
        int nfrac = c.getDefaultFractionDigits();
        if (nfrac == -1) {
            nfrac = 0;
        }
        if (nfrac == 0) {
            fracmask = "";
        } else {
            sb.append('.');
            int i = nfrac;
            while (--i >= 0) {
                sb.append('0');
            }
            fracmask = sb.toString();
            sb.setLength(0);
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(NlsContext.getLocale());
        if (symbol && thousands) {
            df = new DecimalFormat("###,###,###,###,##0" + fracmask, dfs);
            sb.append(NlsContext.getCurrencySymbol());
            sb.append('\u00a0');
            sb.append(df.format(v));
            s = sb.toString();
        } else if (symbol) {
            df = new DecimalFormat("##############0" + fracmask, dfs);
            sb.append(NlsContext.getCurrencySymbol());
            sb.append('\u00a0');
            sb.append(df.format(v));
            s = sb.toString();
        } else if (thousands) {
            df = new DecimalFormat("###,###,###,###,##0" + fracmask, dfs);
            s = df.format(v);
        } else {
            df = new DecimalFormat("##############0" + fracmask, dfs);
            s = df.format(v);
        }
        if (trunk && nfrac > 0) {
            if (dfs.getDecimalSeparator() == '.') {
                if (s.endsWith(fracmask)) {
                    s = s.substring(0, s.length() - nfrac - 1);
                }
            } else {
                String match = dfs.getDecimalSeparator() + fracmask.substring(1);
                if (s.endsWith(match)) {
                    s = s.substring(0, s.length() - nfrac - 1);
                }
            }
        }
        return s;
    }

    @Deprecated
    public static String renderFullWithSign(double v) {
        return MoneyUtil.render(BigDecimal.valueOf(v), true, true, false);
    }

    public static String renderFullWithSign(BigDecimal v) {
        return MoneyUtil.render(v, true, true, false);
    }

    @Deprecated
    public static String renderTruncatedWithSign(double v) {
        return MoneyUtil.render(BigDecimal.valueOf(v), true, true, true);
    }

    public static String renderTruncatedWithSign(BigDecimal v) {
        return MoneyUtil.render(v, true, true, true);
    }

    public static void main(String[] args) {
        Locale l = new Locale("nl", "NL");
        NlsContext.setLocale((Locale)l);
        NlsContext.setCurrencyLocale((Locale)l);
        String s = MoneyUtil.renderFullWithSign(new BigDecimal("123.45"));
        System.out.println(">> " + s);
    }

    @Deprecated
    public static double roundValue(double value) {
        BigDecimal bdv = BigDecimal.valueOf(value);
        return MoneyUtil.roundValue(bdv).doubleValue();
    }

    @Nonnull
    public static BigDecimal roundValue(@Nonnull BigDecimal value) {
        return value.setScale(MoneyUtil.getMoneyScale(), MoneyUtil.getRoundingMode());
    }

    public static boolean areRoundedValuesEqual(double value1, double value2) {
        return MoneyUtil.roundValue(value1) == MoneyUtil.roundValue(value2);
    }

    public static boolean areRoundedValuesEqual(@Nonnull BigDecimal value1, @Nonnull BigDecimal value2) {
        return MoneyUtil.roundValue(value1).equals(MoneyUtil.roundValue(value2));
    }

    public static boolean isRoundedAsZero(@Nonnull BigDecimal value) {
        return MoneyUtil.roundValue(BigDecimal.ZERO).equals(MoneyUtil.roundValue(value));
    }

    public static <T> void assignMonetaryConverter(PropertyMetaModel<T> pmm, boolean editable, IConvertable<T> node) {
        if (pmm.getConverter() != null) {
            node.setConverter(pmm.getConverter());
        } else {
            NumericPresentation np = null;
            if (!editable) {
                np = pmm.getNumericPresentation();
            }
            if (np == null) {
                np = NumericPresentation.MONEY_NUMERIC;
            }
            if (pmm.getActualType() == Double.class || pmm.getActualType() == Double.TYPE) {
                node.setConverter(MoneyConverterFactory.createDoubleMoneyConverters(np));
            } else if (pmm.getActualType() == BigDecimal.class) {
                node.setConverter(MoneyConverterFactory.createBigDecimalMoneyConverters(np));
            } else {
                throw new IllegalStateException("Cannot handle type=" + pmm.getActualType() + " for monetary types");
            }
        }
    }
}

