/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.util.Locale;
import javax.annotation.Nonnull;
import to.etc.domui.converter.IConverter;
import to.etc.domui.converter.MiniScanner;
import to.etc.domui.trouble.UIException;
import to.etc.domui.trouble.ValidationException;

public class MsDurationConverter
implements IConverter<Long> {
    private static final long DAYS = 86400L;
    private static final long HOURS = 3600L;

    @Override
    public String convertObjectToString(Locale loc, Long in) throws UIException {
        if (in == null) {
            return "";
        }
        if (in < 0L) {
            return "";
        }
        return MsDurationConverter.strDurationMillis(in);
    }

    @Override
    public Long convertStringToObject(Locale loc, String in) throws UIException {
        if (null == in) {
            return null;
        }
        if ((in = in.trim()).length() == 0) {
            return null;
        }
        MiniScanner ms = MiniScanner.getInstance();
        ms.init(in);
        long dur = 0L;
        ms.skipWs();
        long pdur = 0L;
        while (!ms.eof()) {
            int nr = this.scanNumber(ms);
            if (nr == -1) {
                throw new ValidationException("v.bad.duration", new Object[0]);
            }
            ms.skipWs();
            int mc = ms.LA();
            switch (mc) {
                default: {
                    throw new ValidationException("v.bad.duration", new Object[0]);
                }
                case -1: 
                case 68: 
                case 100: {
                    if (nr >= 100000) {
                        throw new ValidationException("v.bad.duration", new Object[0]);
                    }
                    dur += (long)nr * 86400L * 1000L;
                    break;
                }
                case 72: 
                case 85: 
                case 104: 
                case 117: {
                    dur += (long)nr * 3600L * 1000L;
                    break;
                }
                case 77: 
                case 109: {
                    if (ms.LA(1) == 115 || ms.LA(1) == 83) {
                        dur += (long)nr;
                        ms.accept();
                        break;
                    }
                    dur += (long)(nr * 60 * 1000);
                    break;
                }
                case 83: 
                case 115: {
                    dur += (long)nr;
                }
            }
            if (dur < pdur) {
                throw new ValidationException("v.bad.duration", new Object[0]);
            }
            pdur = dur;
            ms.accept();
            ms.skipWs();
        }
        return dur;
    }

    private int scanNumber(@Nonnull MiniScanner ms) {
        int nr = 0;
        int ct = 0;
        int c;
        while (Character.isDigit(c = ms.LA())) {
            nr = nr * 10 + Character.digit(c, 10);
            ++ct;
            ms.accept();
        }
        return ct > 0 ? nr : -1;
    }

    public static String strDurationMillis(long dlt) {
        long v;
        StringBuffer sb = new StringBuffer();
        int millis = (int)(dlt % 1000L);
        boolean sp = false;
        if ((dlt /= 1000L) >= 86400L) {
            sb.append(dlt / 86400L);
            sb.append("D");
            dlt %= 86400L;
            sp = true;
        }
        if (dlt >= 3600L) {
            v = dlt / 3600L;
            if (v != 0L) {
                if (sp) {
                    sb.append(' ');
                }
                sb.append(v);
                sb.append("u");
                sp = true;
            }
            dlt %= 3600L;
        }
        if (dlt >= 60L) {
            v = dlt / 60L;
            if (v != 0L) {
                if (sp) {
                    sb.append(' ');
                }
                sb.append(v);
                sb.append("m");
                sp = true;
            }
            dlt %= 60L;
        }
        if (dlt != 0L) {
            if (sp) {
                sb.append(' ');
            }
            sb.append(dlt);
            sb.append("s");
            sp = true;
        }
        if (millis != 0) {
            if (sp) {
                sb.append(' ');
            }
            sb.append(millis);
            sb.append("ms");
        }
        return sb.toString();
    }
}

