/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.math.BigDecimal;
import java.util.Locale;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.converter.IConverter;
import to.etc.domui.converter.MoneyConverterFactory;
import to.etc.domui.converter.NumericUtil;
import to.etc.domui.trouble.UIException;
import to.etc.domui.util.DomUtil;

public class NumberConverter<T extends Number>
implements IConverter<T> {
    private final IConverter<? extends Number> m_converter;
    private NumericPresentation m_presentation;
    private int m_scale;
    private Class<T> m_actualType;

    public NumberConverter(Class<T> actualType, NumericPresentation presentation, int scale) {
        this.m_actualType = actualType;
        this.m_presentation = presentation;
        this.m_scale = scale;
        this.m_converter = NumericPresentation.isMonetary(presentation) ? (actualType == BigDecimal.class ? MoneyConverterFactory.createBigDecimalMoneyConverters(presentation) : (actualType == Double.class || actualType == Double.TYPE ? MoneyConverterFactory.createDoubleMoneyConverters(presentation) : null)) : null;
        if (DomUtil.isIntegerType(this.m_actualType) && scale != 0) {
            throw new IllegalArgumentException("Not possible to create valid NumberConverter for int types if scale is != 0, scale:" + this.m_scale);
        }
    }

    @Override
    public String convertObjectToString(Locale loc, T in) throws UIException {
        IConverter<? extends Number> converter = this.m_converter;
        if (null != converter) {
            return converter.convertObjectToString(loc, (Number)in);
        }
        return NumericUtil.renderNumber(in, this.m_presentation, this.m_scale);
    }

    @Override
    public T convertStringToObject(Locale loc, String in) throws UIException {
        IConverter<? extends Number> converter = this.m_converter;
        if (null != converter) {
            return (T)((Number)converter.convertStringToObject(loc, in));
        }
        return (T)((Number)NumericUtil.parseNumber(this.m_actualType, in, this.m_scale, this.m_presentation));
    }

    public NumericPresentation getPresentation() {
        return this.m_presentation;
    }

    public int getScale() {
        return this.m_scale;
    }

    public Class<T> getActualType() {
        return this.m_actualType;
    }
}

