/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.converter.IConvertable;
import to.etc.domui.converter.IConverter;
import to.etc.domui.converter.MiniScanner;
import to.etc.domui.converter.NumberConverter;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.webapp.nls.NlsContext;

public class NumericUtil {
    private static final BigDecimal MAXINT = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal MININT = BigDecimal.valueOf(Integer.MIN_VALUE);
    public static final int DEFAULT_FRACTION_DIGITS = 2;
    private static final String[] FULL_BY_SCALE = new String[]{"###,###,###,###,###,###,###,###,###,###,###,###,##0", "###,###,###,###,###,###,###,###,###,###,###,###,##0.0", "###,###,###,###,###,###,###,###,###,###,###,###,##0.00", "###,###,###,###,###,###,###,###,###,###,###,###,##0.000", "###,###,###,###,###,###,###,###,###,###,###,###,##0.0000", "###,###,###,###,###,###,###,###,###,###,###,###,##0.00000", "###,###,###,###,###,###,###,###,###,###,###,###,##0.000000"};
    private static final String[] NUMBER_BY_SCALE = new String[]{"#0", "#0.0", "#0.00", "#0.000", "#0.0000", "#0.00000", "#0.000000"};
    private static final String[] NUMBER_BY_SCALE_TRUNC_ZEROS = new String[]{"#0", "#0.#", "#0.##", "#0.###", "#0.####", "#0.#####", "#0.######"};

    private NumericUtil() {
    }

    public static int parseInt(String input) {
        return NumericUtil.internalParseInt(input);
    }

    @Nullable
    public static Integer parseIntWrapper(String input) {
        return NumericUtil.internalParseInt(input);
    }

    private static int internalParseInt(String input) {
        BigDecimal bd = NumericUtil.parseBigDecimal(input, 0, NumericPresentation.NUMBER);
        if (bd == null) {
            throw new ValidationException("v.invalid", input);
        }
        if (bd.compareTo(MAXINT) > 0) {
            throw new ValidationException("v.toolarge", MAXINT);
        }
        if (bd.compareTo(MININT) < 0) {
            throw new ValidationException("v.toosmall", MININT);
        }
        try {
            return bd.intValueExact();
        }
        catch (Exception x) {
            throw new ValidationException("v.invalid", input);
        }
    }

    public static long parseLong(String input) {
        MiniScanner ms = MiniScanner.getInstance();
        if (!ms.scanLaxNumber(input, 0, true)) {
            return 0L;
        }
        try {
            return Long.parseLong(ms.getStringResult());
        }
        catch (Exception x) {
            throw new ValidationException("v.invalid", input);
        }
    }

    @Nullable
    public static Long parseLongWrapper(String input) {
        MiniScanner ms = MiniScanner.getInstance();
        if (!ms.scanLaxNumber(input, 0, true)) {
            return null;
        }
        try {
            return Long.valueOf(ms.getStringResult());
        }
        catch (Exception x) {
            throw new ValidationException("v.invalid", input);
        }
    }

    @Nullable
    public static Double parseDoubleWrapper(String input, int scale, NumericPresentation np) {
        boolean useStrictScale;
        MiniScanner ms = MiniScanner.getInstance();
        boolean bl = useStrictScale = np == NumericPresentation.NUMBER_FULL;
        if (!ms.scanLaxNumber(input, scale, useStrictScale)) {
            return null;
        }
        try {
            return Double.valueOf(ms.getStringResult());
        }
        catch (Exception x) {
            throw new ValidationException("v.invalid", input);
        }
    }

    @Nullable
    public static BigDecimal parseBigDecimal(String input, int scale, NumericPresentation np) {
        boolean useStrictScale;
        MiniScanner ms = MiniScanner.getInstance();
        boolean bl = useStrictScale = np == NumericPresentation.NUMBER_FULL;
        if (!ms.scanLaxNumber(input, scale, useStrictScale)) {
            return null;
        }
        try {
            return new BigDecimal(ms.getStringResult());
        }
        catch (Exception x) {
            throw new ValidationException("v.invalid", input);
        }
    }

    @Deprecated
    @Nullable
    public static <T> T parseNumber(Class<T> type, String input) {
        if (Integer.class == type || Integer.TYPE == type || Long.class == type || Long.TYPE == type) {
            return NumericUtil.parseNumber(type, input, 0, NumericPresentation.NUMBER);
        }
        return NumericUtil.parseNumber(type, input, 2, NumericPresentation.NUMBER);
    }

    @Nullable
    public static <T> T parseNumber(Class<T> type, String input, int scale) {
        if (Integer.class == type || Integer.TYPE == type || Long.class == type || Long.TYPE == type) {
            return NumericUtil.parseNumber(type, input, 0, NumericPresentation.NUMBER);
        }
        return NumericUtil.parseNumber(type, input, scale, NumericPresentation.NUMBER);
    }

    @Nullable
    public static <T> T parseNumber(Class<T> type, String input, int scale, NumericPresentation np) {
        if (scale != 0 && (Integer.class == type || Integer.TYPE == type || Long.class == type || Long.TYPE == type)) {
            throw new IllegalArgumentException("Unsupported scale (" + scale + " - it must be 0) for type in conversion=" + type);
        }
        if (Integer.class == type || Integer.TYPE == type) {
            return (T)NumericUtil.parseIntWrapper(input);
        }
        if (Long.class == type || Long.TYPE == type) {
            return (T)NumericUtil.parseLongWrapper(input);
        }
        if (Double.class == type || Double.TYPE == type) {
            return (T)NumericUtil.parseDoubleWrapper(input, scale, np);
        }
        if (BigDecimal.class == type) {
            return (T)NumericUtil.parseBigDecimal(input, scale, np);
        }
        throw new IllegalArgumentException("Unsupported numeric type in conversion=" + type);
    }

    @Nonnull
    public static String renderNumber(Number v, NumericPresentation np, int scale) {
        if (v == null) {
            return "";
        }
        Class<?> type = v.getClass();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(NlsContext.getLocale());
        if (DomUtil.isIntegerType(type)) {
            switch (np) {
                default: {
                    throw new IllegalArgumentException("Unsupported numeric presentation for numeric type " + v.getClass() + ": " + (Object)((Object)np));
                }
                case UNKNOWN: 
                case NUMBER: 
                case NUMBER_SCALED: {
                    return v.toString();
                }
                case NUMBER_FULL: {
                    return new DecimalFormat("###,###,###,###,###,###,###,###,###,###,###,###,##0", dfs).format(v);
                }
                case NUMBER_SCIENTIFIC: 
            }
            if (type != BigDecimal.class) {
                v = new BigDecimal(v.longValue());
            }
            return new DecimalFormat("#.#E#", dfs).format(v);
        }
        if (scale > 6) {
            scale = 6;
        } else if (scale < 0) {
            scale = 0;
        }
        switch (np) {
            default: {
                throw new IllegalArgumentException("Unsupported numeric presentation for numeric type " + v.getClass() + ": " + (Object)((Object)np));
            }
            case UNKNOWN: 
            case NUMBER: {
                String res = new DecimalFormat(NUMBER_BY_SCALE_TRUNC_ZEROS[scale], dfs).format(v);
                if (res != null && (res.endsWith(".") || res.endsWith(","))) {
                    res = res.substring(0, res.length() - 2);
                }
                return res;
            }
            case NUMBER_SCALED: {
                return new DecimalFormat(NUMBER_BY_SCALE[scale], dfs).format(v);
            }
            case NUMBER_FULL: {
                return new DecimalFormat(FULL_BY_SCALE[scale], dfs).format(v);
            }
            case NUMBER_SCIENTIFIC: 
        }
        return new DecimalFormat("#.#E#", dfs).format(v);
    }

    public static <T extends Number> IConverter<T> createNumberConverter(Class<T> type, NumericPresentation np, int scale) {
        return new NumberConverter<T>(type, np, scale);
    }

    public static <T extends Number> void assignNumericConverter(PropertyMetaModel<T> pmm, boolean editable, IConvertable<T> node, Class<T> type) {
        if (pmm.getConverter() != null) {
            node.setConverter(pmm.getConverter());
        } else {
            NumericPresentation np = null;
            np = pmm.getNumericPresentation();
            int scale = pmm.getScale();
            if (DomUtil.isIntegerType(type) && scale != 0) {
                System.out.println("WRONG SCALE on int types! Detected (scale :" + scale + ") is changed to 0!");
                scale = 0;
            }
            IConverter<T> c = NumericUtil.createNumberConverter(type, np, scale);
            node.setConverter(c);
        }
    }
}

