/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import to.etc.domui.converter.IConverter;
import to.etc.domui.trouble.UIException;
import to.etc.domui.trouble.ValidationException;
import to.etc.webapp.nls.NlsContext;

public class PercentageDoubleConverter
implements IConverter<Double> {
    @Override
    public String convertObjectToString(Locale loc, Double in) throws UIException {
        if (in == null) {
            return null;
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(NlsContext.getLocale());
        DecimalFormat df = new DecimalFormat("##0.00", dfs);
        StringBuilder sb = new StringBuilder(10);
        sb.append(df.format(in));
        sb.append('%');
        return sb.toString();
    }

    @Override
    public Double convertStringToObject(Locale loc, String in) throws UIException {
        if (in == null) {
            return null;
        }
        if ((in = in.trim()).endsWith("%")) {
            in = in.substring(0, in.length() - 1).trim();
        }
        in = in.replace(',', '.');
        try {
            double value = Double.parseDouble(in);
            value = (double)Math.round(value * 100.0) / 100.0;
            if (value <= 100.0 && value >= 0.0) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new ValidationException("v.bad.percentage", in);
    }
}

