/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.util.Comparator;
import javax.annotation.Nonnull;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.util.WrappedException;

public final class PropertyComparator<T>
implements Comparator<T> {
    @Nonnull
    private final PropertyMetaModel<T> m_pmm;
    @Nonnull
    private final Comparator<T> m_valueComp;
    private boolean m_descending;

    public PropertyComparator(@Nonnull PropertyMetaModel<T> pmm, @Nonnull Comparator<T> comp, boolean descending) {
        this.m_pmm = pmm;
        this.m_valueComp = comp;
        this.m_descending = descending;
    }

    @Override
    public int compare(T o1, T o2) {
        try {
            Object a = this.m_pmm.getValue(o1);
            Object b = this.m_pmm.getValue(o2);
            int res = a == null ? (b == null ? 0 : -1) : (b == null ? 1 : this.m_valueComp.compare(a, b));
            return this.m_descending ? -res : res;
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
    }
}

