/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import to.etc.domui.converter.IConverter;
import to.etc.domui.trouble.UIException;
import to.etc.domui.trouble.ValidationException;
import to.etc.util.WrappedException;

public class TimeToSecondsConverter
implements IConverter<Integer> {
    private static final int HOURS = 3600;
    private final Pattern m_pattern = Pattern.compile("([01]?[0-9]|2[0-3])[:]?[0-5][0-9]");
    private static final String TIME24HOURS_PATTERN = "([01]?[0-9]|2[0-3])[:]?[0-5][0-9]";

    @Override
    public String convertObjectToString(Locale loc, Integer in) {
        if (in == null) {
            return "";
        }
        int time = in;
        if (time >= 3600) {
            int hours = Math.abs(time / 3600);
            Integer min = new Integer(time % 3600 / 60);
            return hours + ":" + String.format("%02d", min);
        }
        Integer min = new Integer(time / 60);
        return "0:" + String.format("%02d", min);
    }

    @Override
    public Integer convertStringToObject(Locale loc, String in) throws UIException {
        if (in == null || in.equals("")) {
            return null;
        }
        Matcher matcher = this.m_pattern.matcher(in);
        if (!matcher.matches()) {
            throw new ValidationException("ui.invalid", in);
        }
        int pos = in.indexOf(58);
        try {
            String ms;
            String hs;
            if (pos == -1) {
                if (in.length() == 3) {
                    hs = in.substring(0, 1);
                    ms = in.substring(1);
                } else {
                    hs = in.substring(0, 2);
                    ms = in.substring(2);
                }
            } else {
                hs = in.substring(0, pos);
                ms = in.substring(pos + 1);
            }
            int h = Integer.parseInt(hs.trim());
            int m = Integer.parseInt(ms.trim());
            return h * 3600 + m * 60;
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
    }
}

