/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.converter;

import java.util.HashMap;
import java.util.Map;
import to.etc.domui.converter.IParameterizedValidator;
import to.etc.domui.converter.IValueValidator;

public class ValidatorRegistry {
    private static Map<Class<? extends IValueValidator<?>>, IValueValidator<?>> m_validatorMap = new HashMap();

    public static synchronized <T> IValueValidator<T> getValueValidator(Class<? extends IValueValidator<T>> clz, String[] parameters) {
        try {
            if (parameters != null && parameters.length > 0) {
                IValueValidator<T> v = clz.newInstance();
                if (!(v instanceof IParameterizedValidator)) {
                    throw new IllegalStateException("The validator " + clz + " does not accept parameters");
                }
                ((IParameterizedValidator)v).setParameters(parameters);
                return v;
            }
            IValueValidator<Object> v = m_validatorMap.get(clz);
            if (v == null) {
                v = clz.newInstance();
                m_validatorMap.put(clz, v);
            }
            return v;
        }
        catch (Exception x) {
            throw new IllegalStateException("Cannot instantiate IValueValidator " + clz + ": " + x, x);
        }
    }
}

