/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.databinding;

import javax.annotation.Nonnull;
import to.etc.domui.databinding.IChangeEvent;
import to.etc.domui.databinding.IChangeListener;
import to.etc.util.WrappedException;

public class ListenerList<V, E extends IChangeEvent<V, E, T>, T extends IChangeListener<V, E, T>> {
    @Nonnull
    private static final Object[] NONE = new Object[0];
    @Nonnull
    private Object[] m_listeners = NONE;

    public synchronized void addChangeListener(@Nonnull T listener) {
        int length;
        int i = length = this.m_listeners.length;
        while (--i >= 0) {
            if (this.m_listeners[i] != listener) continue;
            return;
        }
        Object[] ar = new Object[length + 1];
        System.arraycopy(this.m_listeners, 0, ar, 0, length);
        ar[length] = listener;
        this.m_listeners = ar;
    }

    public synchronized void removeChangeListener(@Nonnull T listener) {
        int length;
        int i = length = this.m_listeners.length;
        while (--i >= 0) {
            if (this.m_listeners[i] != listener) continue;
            this.m_listeners[i] = null;
            return;
        }
    }

    @Nonnull
    private synchronized Object[] getListeners() {
        return this.m_listeners;
    }

    public void clear() {
        this.m_listeners = NONE;
    }

    public void fireEvent(@Nonnull E event) {
        try {
            for (Object o : this.getListeners()) {
                if (null == o) continue;
                IChangeListener listener = (IChangeListener)o;
                listener.handleChange(event);
            }
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
    }
}

