/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.databinding.observables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.databinding.ListenerList;
import to.etc.domui.databinding.list.ListChange;
import to.etc.domui.databinding.list.ListChangeAdd;
import to.etc.domui.databinding.list.ListChangeDelete;
import to.etc.domui.databinding.list.ListChangeModify;
import to.etc.domui.databinding.list2.IListChangeListener;
import to.etc.domui.databinding.list2.ListChangeEvent;
import to.etc.domui.databinding.observables.IObservableList;

public class ObservableList<T>
extends ListenerList<T, ListChangeEvent<T>, IListChangeListener<T>>
implements IObservableList<T> {
    private final List<T> m_list;
    @Nullable
    private Comparator<T> m_comparator;
    @Nullable
    private List<ListChange<T>> m_currentChange;
    private int m_changeNestingCount;

    public ObservableList() {
        this.m_list = new ArrayList<T>();
    }

    public ObservableList(@Nonnull Collection<T> list) {
        this.m_list = new ArrayList<T>(list);
    }

    public ObservableList(int size) {
        this.m_list = new ArrayList<T>(size);
    }

    private List<ListChange<T>> startChange() {
        List<ListChange<T>> currentChange = this.m_currentChange;
        if (null == currentChange) {
            this.m_changeNestingCount = 1;
            this.m_currentChange = currentChange = new ArrayList<ListChange<T>>();
        } else {
            ++this.m_changeNestingCount;
        }
        return currentChange;
    }

    private void finishChange() {
        if (this.m_changeNestingCount <= 0) {
            throw new IllegalStateException("Unbalanced startChange/finishChange");
        }
        --this.m_changeNestingCount;
        if (this.m_changeNestingCount == 0) {
            List<ListChange<T>> currentChange = this.m_currentChange;
            this.m_currentChange = null;
            if (null == currentChange) {
                throw new IllegalStateException("Logic error: no change list");
            }
            this.fireEvent(new ListChangeEvent<T>(this, currentChange));
        }
    }

    @Override
    public int size() {
        return this.m_list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_list.contains(o);
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.m_list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.m_list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.m_list.toArray(a);
    }

    @Override
    public boolean add(T e) {
        int index;
        Comparator<T> comparator = this.m_comparator;
        if (null == comparator) {
            index = this.size();
            this.m_list.add(e);
        } else {
            index = Collections.binarySearch(this.m_list, e, comparator);
            if (index < 0) {
                index = -(index + 1);
            }
            this.m_list.add(index, e);
        }
        List<ListChange<T>> el = this.startChange();
        el.add(new ListChangeAdd<T>(index, e));
        this.finishChange();
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int indx = this.m_list.indexOf(o);
        if (indx < 0) {
            return false;
        }
        this.m_list.remove(indx);
        List<ListChange<T>> el = this.startChange();
        el.add(new ListChangeDelete<Object>(indx, o));
        this.finishChange();
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.m_list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        List<ListChange<T>> el = this.startChange();
        Comparator<T> comparator = this.m_comparator;
        if (null == comparator) {
            this.m_list.addAll(c);
            int indx = this.size();
            for (T v : c) {
                el.add(new ListChangeAdd<T>(indx++, v));
            }
        } else {
            for (T v : c) {
                this.add(v);
            }
        }
        this.finishChange();
        return c.size() > 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (this.m_comparator != null) {
            throw new IllegalStateException("Cannot add by index on a sorted model: the sorting order determines the insert index");
        }
        boolean res = this.m_list.addAll(index, c);
        List<ListChange<T>> el = this.startChange();
        int indx = index;
        for (T v : c) {
            el.add(new ListChangeAdd<T>(indx++, v));
        }
        this.finishChange();
        return res;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        List<ListChange<T>> el = this.startChange();
        boolean done = false;
        for (Object v : c) {
            int indx = this.indexOf(v);
            if (indx < 0) continue;
            this.m_list.remove(indx);
            el.add(new ListChangeDelete(indx, v));
            done = true;
        }
        this.finishChange();
        return done;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        List<ListChange<T>> el = this.startChange();
        boolean done = false;
        int i = this.size();
        while (--i >= 0) {
            T cv = this.m_list.get(i);
            if (c.contains(cv)) continue;
            this.m_list.remove(i);
            el.add(new ListChangeDelete<T>(i, cv));
            done = true;
        }
        this.finishChange();
        return done;
    }

    @Override
    public void clear() {
        List<ListChange<T>> el = this.startChange();
        int i = this.size();
        while (--i >= 0) {
            T cv = this.m_list.get(i);
            el.add(new ListChangeDelete<T>(i, cv));
        }
        this.finishChange();
        this.m_list.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.m_list.equals(o);
    }

    @Override
    public int hashCode() {
        return this.m_list.hashCode();
    }

    @Override
    @Nonnull
    public T get(int index) {
        return this.m_list.get(index);
    }

    @Override
    public T set(int index, T element) {
        if (this.m_comparator != null) {
            throw new IllegalStateException("Cannot set by index on a sorted model: the sorting order determines the insert index");
        }
        T res = this.m_list.set(index, element);
        List<ListChange<T>> el = this.startChange();
        el.add(new ListChangeModify<T>(index, res, element));
        this.finishChange();
        return res;
    }

    @Override
    public void add(int index, T element) {
        if (this.m_comparator != null) {
            throw new IllegalStateException("Cannot add by index on a sorted model: the sorting order determines the insert index");
        }
        this.m_list.add(index, element);
        List<ListChange<T>> el = this.startChange();
        el.add(new ListChangeAdd<T>(index, element));
        this.finishChange();
    }

    @Override
    public T remove(int index) {
        T res = this.m_list.remove(index);
        List<ListChange<T>> el = this.startChange();
        el.add(new ListChangeDelete<T>(index, res));
        this.finishChange();
        return res;
    }

    @Override
    public int indexOf(Object o) {
        return this.m_list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.m_list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.m_list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.m_list.listIterator(index);
    }

    @Override
    @Nonnull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.m_list.subList(fromIndex, toIndex);
    }

    @Nullable
    public Comparator<T> getComparator() {
        return this.m_comparator;
    }

    public void setComparator(@Nullable Comparator<T> comparator) throws Exception {
        if (this.m_comparator == comparator) {
            return;
        }
        this.m_comparator = comparator;
        if (comparator != null) {
            this.resort();
        }
    }

    private void resort() throws Exception {
        this.startChange();
        Collections.sort(this.m_list, this.m_comparator);
        this.finishChange();
    }
}

