/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.databinding.observables;

import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.ITableModelListener;
import to.etc.domui.databinding.list.ListChangeAdd;
import to.etc.domui.databinding.list.ListChangeAssign;
import to.etc.domui.databinding.list.ListChangeDelete;
import to.etc.domui.databinding.list.ListChangeModify;
import to.etc.domui.databinding.list2.IListChangeListener;
import to.etc.domui.databinding.list2.IListChangeVisitor;
import to.etc.domui.databinding.list2.ListChangeEvent;
import to.etc.domui.databinding.observables.IObservableList;

public final class ObservableListModelAdapter<T>
implements ITableModel<T> {
    @Nonnull
    private final IObservableList<T> m_list;

    public ObservableListModelAdapter(@Nonnull IObservableList<T> list) {
        this.m_list = list;
    }

    @Nonnull
    public IObservableList<T> getSource() {
        return this.m_list;
    }

    @Override
    @Nonnull
    public List<T> getItems(int start, int end) throws Exception {
        return this.m_list.subList(start, end);
    }

    @Override
    public int getRows() throws Exception {
        return this.m_list.size();
    }

    @Override
    public void addChangeListener(@Nonnull ITableModelListener<T> l) {
    }

    @Override
    public void removeChangeListener(@Nonnull ITableModelListener<T> l) {
    }

    @Override
    public void refresh() {
    }

    private class EvListener
    implements IListChangeListener<T> {
        private final ITableModelListener<T> m_modelListener;

        public EvListener(ITableModelListener<T> l) {
            this.m_modelListener = l;
        }

        @Override
        public void handleChange(@Nonnull ListChangeEvent<T> event) throws Exception {
            event.visit(new IListChangeVisitor<T>(){

                @Override
                public void visitAdd(@Nonnull ListChangeAdd<T> l) throws Exception {
                    EvListener.this.m_modelListener.rowAdded(ObservableListModelAdapter.this, l.getIndex(), l.getValue());
                }

                @Override
                public void visitDelete(@Nonnull ListChangeDelete<T> l) throws Exception {
                    EvListener.this.m_modelListener.rowDeleted(ObservableListModelAdapter.this, l.getIndex(), l.getValue());
                }

                @Override
                public void visitModify(@Nonnull ListChangeModify<T> l) throws Exception {
                    EvListener.this.m_modelListener.rowModified(ObservableListModelAdapter.this, l.getIndex(), l.getNewValue());
                }

                @Override
                public void visitAssign(@Nonnull ListChangeAssign<T> assign) throws Exception {
                    EvListener.this.m_modelListener.modelChanged(ObservableListModelAdapter.this);
                }
            });
        }
    }
}

