/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import to.etc.domui.component.misc.LiteralXhtml;
import to.etc.domui.dom.HtmlRenderMode;
import to.etc.domui.dom.HtmlTagRenderer;
import to.etc.domui.dom.IBrowserOutput;
import to.etc.domui.dom.IRenderNBSPIfEmpty;
import to.etc.domui.dom.header.HeaderContributor;
import to.etc.domui.dom.header.HeaderContributorEntry;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.NodeVisitorBase;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.PagePhase;
import to.etc.domui.dom.html.TextArea;
import to.etc.domui.dom.html.TextNode;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.util.javascript.JavascriptStmt;
import to.etc.util.DeveloperOptions;
import to.etc.util.StringTool;

public class HtmlFullRenderer
extends NodeVisitorBase {
    private HtmlTagRenderer m_tagRenderer;
    @Nonnull
    private IBrowserOutput m_o;
    private IRequestContext m_ctx;
    private Page m_page;
    private boolean m_xml;
    @Nonnull
    private StringBuilder m_createJS = new StringBuilder();
    @Nonnull
    private StringBuilder m_stateJS = new StringBuilder();
    @Nonnull
    private JavascriptStmt m_stateBuilder = new JavascriptStmt(this.m_stateJS);

    protected HtmlFullRenderer(@Nonnull HtmlTagRenderer tagRenderer, @Nonnull IBrowserOutput o) {
        this.m_tagRenderer = tagRenderer;
        this.m_o = o;
        this.setRenderMode(HtmlRenderMode.FULL);
    }

    public HtmlTagRenderer getTagRenderer() {
        return this.m_tagRenderer;
    }

    public HtmlRenderMode getMode() {
        return this.m_tagRenderer.getMode();
    }

    public void setRenderMode(HtmlRenderMode m) {
        this.m_tagRenderer.setRenderMode(m);
    }

    public boolean isXml() {
        return this.m_xml;
    }

    public void setXml(boolean xml) {
        this.m_xml = xml;
    }

    @Nonnull
    public IBrowserOutput o() {
        return this.m_o;
    }

    public IRequestContext ctx() {
        return this.m_ctx;
    }

    public Page page() {
        return this.m_page;
    }

    @Override
    public void visitNodeBase(NodeBase n) throws Exception {
        if (DeveloperOptions.isDeveloperWorkstation()) {
            if (!n.isBuilt()) {
                throw new IllegalStateException("Node " + n + " unbuilt in render?");
            }
        } else {
            n.build();
        }
        n.onBeforeFullRender();
        n.visit(this.getTagRenderer());
        if (n.getCreateJS() != null) {
            this.m_createJS.append((CharSequence)n.getCreateJS());
        }
        n.internalRenderJavascriptState(this.m_stateBuilder);
        if (!(n instanceof TextNode)) {
            if (this.m_xml) {
                if (!n.isRendersOwnClose()) {
                    this.getTagRenderer().renderEndTag(n);
                }
            } else {
                this.m_o.dec();
            }
        }
        n.internalClearDelta();
        this.checkForFocus(n);
    }

    @Override
    @Deprecated
    public void visitLiteralXhtml(LiteralXhtml n) throws Exception {
        this.visitNodeBase(n);
        if (!this.m_xml) {
            this.m_o.inc();
            this.getTagRenderer().renderEndTag(n);
        }
    }

    @Override
    public void visitTextArea(TextArea n) throws Exception {
        if (this.getMode() == HtmlRenderMode.FULL) {
            this.visitNodeContainer(n);
            return;
        }
        this.visitNodeBase(n);
        this.o().setIndentEnabled(true);
    }

    @Override
    public void visitNodeContainer(NodeContainer n) throws Exception {
        if (DeveloperOptions.isDeveloperWorkstation()) {
            if (!n.isBuilt()) {
                throw new IllegalStateException("Node " + n + " unbuilt in render?");
            }
        } else {
            n.build();
        }
        n.onBeforeFullRender();
        boolean indena = this.o().isIndentEnabled();
        n.visit(this.getTagRenderer());
        if (n.getCreateJS() != null) {
            this.m_createJS.append((CharSequence)n.getCreateJS());
        }
        n.internalRenderJavascriptState(this.m_stateBuilder);
        this.visitChildren(n);
        this.getTagRenderer().renderEndTag(n);
        this.o().setIndentEnabled(indena);
        n.internalClearDelta();
        this.checkForFocus(n);
    }

    @Override
    public void visitChildren(NodeContainer c) throws Exception {
        if (c instanceof IRenderNBSPIfEmpty && c.getChildCount() == 0) {
            this.o().text("\u00a0");
            return;
        }
        super.visitChildren(c);
    }

    private void checkForFocus(NodeBase n) {
        if (this.m_tagRenderer.getMode() != HtmlRenderMode.FULL) {
            return;
        }
        if (n.getPage().getFocusComponent() != null) {
            return;
        }
        if (n.isFocusable()) {
            n.getPage().setFocusComponent(n);
        }
    }

    protected void renderPageHeader() throws Exception {
        if (this.isXml()) {
            this.o().writeRaw("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml; charset=UTF-8\"/>\n");
        } else {
            this.o().writeRaw("<!DOCTYPE html><html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
        }
    }

    protected void renderThemeCSS() throws Exception {
        String sheet = this.m_page.getBody().getThemedResourceRURL("THEME/style.theme.css");
        if (null == sheet) {
            throw new IllegalStateException("Unexpected null??");
        }
        this.o().writeRaw("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        this.o().writeRaw(this.ctx().getRelativePath(sheet));
        if (this.isXml()) {
            this.o().writeRaw("\"/>");
        } else {
            this.o().writeRaw("\"></link>\n");
        }
    }

    public void renderHeadContributors() throws Exception {
        ArrayList<HeaderContributorEntry> full = new ArrayList<HeaderContributorEntry>(this.page().getApplication().getHeaderContributorList());
        this.page().internalAddContributors(full);
        Collections.sort(full, HeaderContributor.C_ENTRY);
        for (HeaderContributorEntry hce : full) {
            hce.getContributor().contribute(this);
        }
        this.page().internalContributorsRendered();
    }

    public void renderLoadCSS(String path) throws Exception {
        String rurl = this.m_page.getBody().getThemedResourceRURL(path);
        path = this.ctx().getRelativePath(rurl);
        this.o().tag("link");
        this.o().attr("rel", "stylesheet");
        this.o().attr("type", "text/css");
        this.o().attr("href", path);
        this.o().endtag();
        this.o().closetag("link");
    }

    public void renderLoadJavascript(@Nonnull String path) throws Exception {
        if (!path.startsWith("http")) {
            String rurl = this.m_page.getBody().getThemedResourceRURL(path);
            path = this.ctx().getRelativePath(rurl);
        }
        this.o().tag("script");
        this.o().attr("language", "javascript");
        this.o().attr("src", path);
        this.o().endtag();
        this.o().closetag("script");
    }

    private void genVar(String name, String val) throws Exception {
        this.o().writeRaw("var " + name + "=" + val + ";\n");
    }

    public void render(IRequestContext ctx, Page page) throws Exception {
        int autorefresh;
        int pollinterval;
        StringBuilder sb;
        this.m_ctx = ctx;
        this.m_page = page;
        page.internalSetPhase(PagePhase.FULLRENDER);
        page.calculateDefaultFocus(null);
        if (page.isRenderAsXHTML()) {
            this.setXml(true);
        }
        this.renderPageHeader();
        this.o().writeRaw("<script language=\"javascript\">");
        if (!this.isXml()) {
            this.o().writeRaw("<!--\n");
        }
        this.genVar("DomUIpageTag", Integer.toString(page.getPageTag()));
        DomApplication application = DomApplication.get();
        String pb = this.m_page.getBody().getThemedResourceRURL("THEME/progressbar.gif");
        if (null == pb) {
            throw new IllegalStateException("Required resource missing");
        }
        this.genVar("DomUIProgressURL", StringTool.strToJavascriptString((String)ctx.getRelativePath(pb), (boolean)true));
        this.genVar("DomUICID", StringTool.strToJavascriptString((String)page.getConversation().getFullId(), (boolean)true));
        this.genVar("DomUIDevel", ctx.getApplication().inDevelopmentMode() ? "true" : "false");
        this.genVar("DomUIappURL", StringTool.strToJavascriptString((String)ctx.getRelativePath(""), (boolean)true));
        if (!this.isXml()) {
            this.o().writeRaw("\n-->");
        }
        this.o().writeRaw("\n</script>\n");
        if (this.m_page.isAllowVectorGraphics() && ctx.getBrowserVersion().isIE()) {
            this.o().writeRaw("<style>v\\: * { behavior:url(#default#VML); display:inline-block;} </style>\n");
            this.o().writeRaw("<xml:namespace ns=\"urn:schemas-microsoft-com:vml\" prefix=\"v\">\n");
        }
        this.renderThemeCSS();
        this.renderHeadContributors();
        if (page.getBody().getTitle() != null) {
            this.o().tag("title");
            this.o().endtag();
            this.o().text(page.getBody().getTitle());
            this.o().closetag("title");
        }
        this.o().closetag("head");
        page.getBody().visit(this);
        this.o().tag("script");
        this.o().attr("language", "javascript");
        this.o().endtag();
        this.o().text("$(document).ready(function() {");
        NodeBase f = page.getFocusComponent();
        if (f != null) {
            this.o().text("WebUI.focus('" + f.getActualID() + "');");
            page.setFocusComponent(null);
        }
        if (this.getCreateJS().length() > 0) {
            this.o().writeRaw(this.getCreateJS().toString());
        }
        if (null != (sb = this.m_page.internalFlushAppendJS())) {
            this.o().writeRaw(sb);
        }
        if (null != (sb = this.m_page.internalFlushJavascriptStateChanges())) {
            this.o().writeRaw(sb);
        }
        if ((pollinterval = application.calculatePollInterval(page.getConversation().isPollCallbackRequired())) > 0) {
            this.o().writeRaw("WebUI.startPolling(" + pollinterval + ");");
        }
        if ((autorefresh = application.getAutoRefreshPollInterval()) > 0) {
            this.o().writeRaw("WebUI.setHideExpired();");
        }
        this.o().writeRaw("WebUI.definePageName('" + page.getBody().getClass().getName() + "');");
        this.o().text("});");
        this.o().closetag("script");
        this.o().closetag("html");
        page.internalSetPhase(PagePhase.NULL);
    }

    public StringBuilder getCreateJS() {
        if (this.m_stateJS.length() > 0) {
            this.m_createJS.append(';');
            this.m_createJS.append((CharSequence)this.m_stateJS);
            this.m_stateJS.setLength(0);
        }
        return this.m_createJS;
    }
}

