/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.misc.LiteralXhtml;
import to.etc.domui.dom.HtmlRenderMode;
import to.etc.domui.dom.IBrowserOutput;
import to.etc.domui.dom.html.ATag;
import to.etc.domui.dom.html.BR;
import to.etc.domui.dom.html.Button;
import to.etc.domui.dom.html.Checkbox;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.FileInput;
import to.etc.domui.dom.html.Form;
import to.etc.domui.dom.html.HTag;
import to.etc.domui.dom.html.IFrame;
import to.etc.domui.dom.html.INativeChangeListener;
import to.etc.domui.dom.html.INodeVisitor;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.Input;
import to.etc.domui.dom.html.Label;
import to.etc.domui.dom.html.Li;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.Pre;
import to.etc.domui.dom.html.RadioButton;
import to.etc.domui.dom.html.Select;
import to.etc.domui.dom.html.SelectOption;
import to.etc.domui.dom.html.Span;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TH;
import to.etc.domui.dom.html.THead;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.TextArea;
import to.etc.domui.dom.html.TextNode;
import to.etc.domui.dom.html.Ul;
import to.etc.domui.dom.html.Underline;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.dom.html.XmlTextNode;
import to.etc.domui.parts.GrayscalerPart;
import to.etc.domui.server.BrowserVersion;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IDragHandler;
import to.etc.domui.util.IDraggable;
import to.etc.domui.util.IDropHandler;
import to.etc.domui.util.IDropTargetable;
import to.etc.domui.util.UIDragDropUtil;
import to.etc.util.StringTool;

public class HtmlTagRenderer
implements INodeVisitor {
    private StringBuilder m_sb;
    private final BrowserVersion m_browserVersion;
    private final IBrowserOutput m_o;
    private boolean m_tagless;
    private HtmlRenderMode m_mode;
    private final boolean m_uiTestMode;

    protected HtmlTagRenderer(BrowserVersion bv, IBrowserOutput o, boolean uiTestMode) {
        this.m_o = o;
        this.m_browserVersion = bv;
        this.m_uiTestMode = uiTestMode;
    }

    protected BrowserVersion getBrowser() {
        return this.m_browserVersion;
    }

    public boolean isTagless() {
        return this.m_tagless;
    }

    public void setTagless(boolean tagless) {
        this.m_tagless = tagless;
    }

    public void setRenderMode(HtmlRenderMode rm) {
        this.m_mode = rm;
    }

    public HtmlRenderMode getMode() {
        return this.m_mode;
    }

    protected boolean isFullRender() {
        return this.m_mode == HtmlRenderMode.FULL;
    }

    private boolean isAttrRender() {
        return this.m_mode == HtmlRenderMode.ATTR;
    }

    protected StringBuilder sb() {
        if (this.m_sb == null) {
            this.m_sb = new StringBuilder(128);
        } else {
            this.m_sb.setLength(0);
        }
        return this.m_sb;
    }

    protected void addDelayedAttrs(NodeBase n, String ... pairs) {
        if (pairs.length == 0) {
            return;
        }
        if (0 != (pairs.length & 1)) {
            throw new IllegalArgumentException("Odd number of attribute/value strings.");
        }
        StringBuilder sb = this.sb();
        sb.append("WebUI.delayedSetAttributes(\"");
        sb.append(n.getActualID());
        sb.append("\"");
        boolean isattr = false;
        for (String s : pairs) {
            sb.append(',');
            if (isattr) {
                sb.append(s);
            } else {
                sb.append('\"');
                sb.append(s);
                sb.append('\"');
            }
            isattr = !isattr;
        }
        sb.append(");\n");
        n.getPage().appendJS(sb);
    }

    protected void renderDisabled(NodeBase n, boolean disabled) throws IOException {
        if (this.isFullRender() && !disabled) {
            return;
        }
        this.o().attr("disabled", disabled ? "disabled" : "");
    }

    protected void renderChecked(NodeBase n, boolean checked) throws IOException {
        if (this.isFullRender() && !checked) {
            return;
        }
        this.o().attr("checked", checked ? "checked" : "");
    }

    protected void renderSelected(NodeBase n, boolean checked) throws IOException {
        if (this.isFullRender() && !checked) {
            return;
        }
        this.o().attr("selected", checked ? "selected" : "");
    }

    protected void renderReadOnly(NodeBase n, boolean readonly) throws IOException {
        if (this.isFullRender() && !readonly) {
            return;
        }
        this.o().attr("readonly", readonly ? "readonly" : "");
    }

    protected void renderDiRo(NodeBase n, boolean disabled, boolean readonly) throws IOException {
        this.renderDisabled(n, disabled);
        this.renderReadOnly(n, readonly);
    }

    public static String fixColor(String s) {
        if (s.startsWith("#")) {
            return s;
        }
        int i = s.length();
        while (--i >= 0) {
            char c = s.charAt(i);
            if (Character.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return s;
        }
        return "#" + s;
    }

    public void appendStyle(NodeBase c, Appendable a) throws IOException {
        boolean leri;
        boolean topbot;
        String bottom;
        String top;
        String right;
        StringBuilder bb;
        String left;
        String backgroundImage;
        if (c.getBackgroundAttachment() != null) {
            a.append("background-attachment: ");
            switch (c.getBackgroundAttachment()) {
                default: {
                    throw new IllegalStateException("Unknown " + (Object)((Object)c.getBackgroundAttachment()));
                }
                case FIXED: {
                    a.append("fixed; ");
                    break;
                }
                case SCROLL: {
                    a.append("scroll;");
                }
            }
        }
        if (c.getBackgroundColor() != null) {
            a.append("background-color:");
            a.append(HtmlTagRenderer.fixColor(c.getBackgroundColor()));
            a.append(';');
        }
        if ((backgroundImage = c.getBackgroundImage()) != null) {
            a.append("background-image:");
            if (backgroundImage.equalsIgnoreCase("none")) {
                a.append("none");
            } else {
                a.append("url(");
                backgroundImage = c.getThemedResourceRURL(backgroundImage);
                a.append(backgroundImage);
                a.append(");");
            }
        }
        if (c.getBackgroundPosition() != null) {
            a.append("background-position:");
            a.append(c.getBackgroundPosition());
            a.append(';');
        }
        if (c.getBackgroundRepeat() != null) {
            a.append("background-repeat:");
            a.append(c.getBackgroundRepeat());
            a.append(';');
        }
        if (DomUtil.isEqual(left = HtmlTagRenderer.border(bb = new StringBuilder(20), c.getBorderLeftWidth(), c.getBorderLeftStyle(), c.getBorderLeftColor()), right = HtmlTagRenderer.border(bb, c.getBorderRightWidth(), c.getBorderRightStyle(), c.getBorderRightColor()), top = HtmlTagRenderer.border(bb, c.getBorderTopWidth(), c.getBorderTopStyle(), c.getBorderTopColor()), bottom = HtmlTagRenderer.border(bb, c.getBorderBottomWidth(), c.getBorderBottomStyle(), c.getBorderBottomColor()))) {
            if (left.length() != 0) {
                a.append("border:");
                a.append(left);
                a.append(';');
            }
        } else if (DomUtil.isEqual(left, right, top)) {
            HtmlTagRenderer.renderBorderIf(a, left);
            a.append("border-bottom:");
            a.append(bottom);
            a.append(';');
        } else if (DomUtil.isEqual(left, right, bottom)) {
            HtmlTagRenderer.renderBorderIf(a, left);
            a.append("border-top:");
            a.append(top);
            a.append(';');
        } else if (DomUtil.isEqual(right, top, bottom)) {
            HtmlTagRenderer.renderBorderIf(a, right);
            a.append("border-left:");
            a.append(left);
            a.append(';');
        } else if (DomUtil.isEqual(left, top, bottom)) {
            HtmlTagRenderer.renderBorderIf(a, left);
            a.append("border-right:");
            a.append(right);
            a.append(';');
        } else {
            a.append("border-bottom:");
            a.append(bottom);
            a.append(';');
            a.append("border-top:");
            a.append(top);
            a.append(';');
            a.append("border-left:");
            a.append(left);
            a.append(';');
            a.append("border-right:");
            a.append(right);
            a.append(';');
        }
        if (c.getClear() != null) {
            a.append("clear:");
            a.append(c.getClear().toString());
            a.append(';');
        }
        if (c.getDisplay() != null) {
            a.append("display:");
            a.append(c.getDisplay().toString());
            a.append(';');
        }
        if (c.getFloat() != null) {
            a.append("float:");
            a.append(c.getFloat().getCode());
            a.append(';');
        }
        if (c.getVisibility() != null) {
            a.append("visibility:");
            a.append(c.getVisibility().name().toLowerCase());
            a.append(';');
        }
        if (c.getHeight() != null) {
            a.append("height:");
            a.append(c.getHeight());
            a.append(";");
        }
        if (c.getWidth() != null) {
            a.append("width:");
            a.append(c.getWidth());
            a.append(";");
        }
        if (c.getLineHeight() != null) {
            a.append("line-height:");
            a.append(c.getLineHeight());
            a.append(";");
        }
        if (c.getMaxHeight() != null) {
            a.append("max-height:");
            a.append(c.getMaxHeight());
            a.append(";");
        }
        if (c.getMaxWidth() != null) {
            a.append("max-width:");
            a.append(c.getMaxWidth());
            a.append(";");
        }
        if (c.getMinHeight() != null) {
            a.append("min-height:");
            a.append(c.getMinHeight());
            a.append(";");
        }
        if (c.getMinWidth() != null) {
            a.append("min-width:");
            a.append(c.getMinWidth());
            a.append(";");
        }
        if (c.getOverflow() != null) {
            a.append("overflow:");
            a.append(c.getOverflow().toString());
            a.append(';');
        }
        if (c.getZIndex() != Integer.MIN_VALUE) {
            a.append("z-index:");
            a.append(Integer.toString(c.getZIndex()));
            a.append(';');
        }
        if (c.getPosition() != null) {
            a.append("position:");
            a.append(c.getPosition().getTxt());
            a.append(';');
        }
        if (c.getTop() != null) {
            a.append("top:");
            a.append(c.getTop());
            a.append(";");
        }
        if (c.getBottom() != null) {
            a.append("bottom:");
            a.append(c.getBottom());
            a.append(";");
        }
        if (c.getLeft() != null) {
            a.append("left:");
            a.append(c.getLeft());
            a.append(";");
        }
        if (c.getRight() != null) {
            a.append("right:");
            a.append(c.getRight());
            a.append(";");
        }
        if (c.getColor() != null) {
            a.append("color:");
            a.append(HtmlTagRenderer.fixColor(c.getColor()));
            a.append(";");
        }
        if (c.getFontSize() != null) {
            a.append("font-size:");
            a.append(c.getFontSize());
            a.append(';');
        }
        if (c.getFontFamily() != null) {
            a.append("font-family:");
            a.append(c.getFontFamily());
            a.append(';');
        }
        if (c.getFontSizeAdjust() != null) {
            a.append("font-size-adjust:");
            a.append(c.getFontSizeAdjust());
            a.append(';');
        }
        if (c.getFontStyle() != null) {
            a.append("font-style:");
            a.append(c.getFontStyle().name().toLowerCase());
            a.append(';');
        }
        if (c.getFontVariant() != null) {
            a.append("font-variant:");
            a.append(c.getFontVariant().name().toLowerCase());
            a.append(';');
        }
        if (c.getFontWeight() != null) {
            a.append("font-weight:");
            a.append(c.getFontWeight());
            a.append(';');
        }
        if (c.getTextAlign() != null) {
            a.append("text-align:");
            a.append(c.getTextAlign().name().toLowerCase());
            a.append(';');
        }
        if (c.getVerticalAlign() != null) {
            a.append("vertical-align:");
            a.append(c.getVerticalAlign().toString());
            a.append(';');
        }
        if (c.getMarginBottom() != null || c.getMarginLeft() != null || c.getMarginRight() != null || c.getMarginTop() != null) {
            if (DomUtil.isEqual(c.getMarginBottom(), c.getMarginTop(), c.getMarginLeft(), c.getMarginRight())) {
                a.append("margin:");
                a.append(c.getMarginLeft());
                a.append(';');
            } else {
                topbot = DomUtil.isEqual((Object)c.getMarginBottom(), (Object)c.getMarginTop()) && c.getMarginBottom() != null;
                boolean bl = leri = DomUtil.isEqual((Object)c.getMarginLeft(), (Object)c.getMarginRight()) && c.getMarginLeft() != null;
                if (topbot && leri) {
                    a.append("margin:");
                    a.append(c.getMarginTop());
                    a.append(' ');
                    a.append(c.getMarginLeft());
                    a.append(';');
                } else {
                    if (c.getMarginLeft() != null) {
                        a.append("margin-left:");
                        a.append(c.getMarginLeft());
                        a.append(';');
                    }
                    if (c.getMarginRight() != null) {
                        a.append("margin-right:");
                        a.append(c.getMarginRight());
                        a.append(';');
                    }
                    if (c.getMarginBottom() != null) {
                        a.append("margin-bottom:");
                        a.append(c.getMarginBottom());
                        a.append(';');
                    }
                    if (c.getMarginTop() != null) {
                        a.append("margin-top:");
                        a.append(c.getMarginTop());
                        a.append(';');
                    }
                }
            }
        }
        if (c.getPaddingBottom() != null || c.getPaddingLeft() != null || c.getPaddingRight() != null || c.getPaddingTop() != null) {
            if (DomUtil.isEqual(c.getPaddingBottom(), c.getPaddingTop(), c.getPaddingLeft(), c.getPaddingRight())) {
                a.append("padding:");
                a.append(c.getPaddingLeft());
                a.append(';');
            } else {
                topbot = DomUtil.isEqual((Object)c.getPaddingBottom(), (Object)c.getPaddingTop()) && c.getPaddingBottom() != null;
                boolean bl = leri = DomUtil.isEqual((Object)c.getPaddingLeft(), (Object)c.getPaddingRight()) && c.getPaddingLeft() != null;
                if (topbot && leri) {
                    a.append("padding:");
                    a.append(c.getPaddingTop());
                    a.append(' ');
                    a.append(c.getPaddingLeft());
                    a.append(';');
                } else {
                    if (c.getPaddingLeft() != null) {
                        a.append("padding-left:");
                        a.append(c.getPaddingLeft());
                        a.append(';');
                    }
                    if (c.getPaddingRight() != null) {
                        a.append("padding-right:");
                        a.append(c.getPaddingRight());
                        a.append(';');
                    }
                    if (c.getPaddingBottom() != null) {
                        a.append("padding-bottom:");
                        a.append(c.getPaddingBottom());
                        a.append(';');
                    }
                    if (c.getPaddingTop() != null) {
                        a.append("padding-top:");
                        a.append(c.getPaddingTop());
                        a.append(';');
                    }
                }
            }
        }
        if (c.getTransform() != null) {
            a.append("text-transform:");
            a.append(c.getTransform().name().toLowerCase());
            a.append(';');
        }
    }

    private static String border(StringBuilder a, int w, String s, String c) {
        a.setLength(0);
        if (w >= 0) {
            a.append(w);
            a.append("px");
        }
        if (s != null) {
            if (s.length() > 0) {
                a.append(' ');
            }
            a.append(s.trim().toLowerCase());
        }
        if (c != null) {
            if (c.length() > 0) {
                a.append(' ');
            }
            a.append(c.trim().toLowerCase());
        }
        return a.toString();
    }

    private static void renderBorderIf(@Nonnull Appendable a, @Nullable String border) throws IOException {
        if (StringTool.isBlank((String)border)) {
            return;
        }
        a.append("border:").append(border).append(";");
    }

    protected final IBrowserOutput o() {
        return this.m_o;
    }

    protected String getStyleFor(NodeBase b) throws IOException {
        String s = b.getCachedStyle();
        if (s != null) {
            return s;
        }
        StringBuilder sb = this.sb();
        this.appendStyle(b, sb);
        s = sb.toString();
        b.setCachedStyle(s);
        return s;
    }

    protected void renderTag(NodeBase b, IBrowserOutput o) throws Exception {
        if (!this.m_tagless) {
            o.tag(b.getTag());
        }
    }

    protected void renderTagend(NodeBase b, IBrowserOutput o) throws Exception {
        if (!this.m_tagless) {
            o.endtag();
        }
    }

    public void basicNodeRender(NodeBase b, IBrowserOutput o) throws Exception {
        this.basicNodeRender(b, o, false);
    }

    public void basicNodeRender(NodeBase b, IBrowserOutput o, boolean inhibitevents) throws Exception {
        INativeChangeListener inb;
        List<String> sal;
        String s;
        Object dh;
        this.renderTag(b, o);
        if (this.m_tagless) {
            o.attr("select", "#" + b.getActualID());
        } else {
            o.attr("id", b.getActualID());
        }
        if (b instanceof IDraggable) {
            dh = ((IDraggable)((Object)b)).getDragHandler();
            UIDragDropUtil.exposeDraggable(b, (IDragHandler)dh);
        }
        if (b instanceof IDropTargetable) {
            dh = ((IDropTargetable)((Object)b)).getDropHandler();
            UIDragDropUtil.exposeDroppable(b, (IDropHandler)dh);
        }
        if ((s = this.getStyleFor(b)).length() > 0) {
            o.attr("style", s);
        }
        String ttl = b.getTitle();
        if (this.m_uiTestMode) {
            String testid = b.getTestID();
            if (testid != null) {
                o.attr("testid", testid);
            } else {
                testid = b.calcTestID();
                if (null != testid) {
                    o.attr("testid", testid);
                }
            }
            if (!(b instanceof UrlPage)) {
                if (ttl != null) {
                    if (testid != null) {
                        this.o().attr("title", ttl + " (TestID: " + testid + ")");
                    } else {
                        this.o().attr("title", ttl);
                    }
                } else if (testid != null) {
                    this.o().attr("title", "TestID: " + testid);
                }
            }
        } else if (!(b instanceof UrlPage) && ttl != null) {
            this.o().attr("title", ttl);
        }
        if (b.isStretchHeight()) {
            o.attr("stretch", "true");
        }
        if (b.getCssClass() != null) {
            o.attr("class", b.getCssClass());
        }
        if ((sal = b.getSpecialAttributeList()) != null) {
            for (int i = 0; i < sal.size(); i += 2) {
                this.o().attr(sal.get(i), sal.get(i + 1));
            }
        }
        if (inhibitevents) {
            return;
        }
        if (b.internalNeedClickHandler()) {
            o.attr("onclick", this.sb().append("return WebUI.clicked(this, '").append(b.getActualID()).append("', event)").toString());
        } else if (b.getOnClickJS() != null) {
            o.attr("onclick", b.getOnClickJS());
        }
        if (b instanceof INativeChangeListener && b.getSpecialAttribute("onchange") == null && null != (inb = (INativeChangeListener)((Object)b)).getOnValueChanged()) {
            o.attr("onchange", this.sb().append("WebUI.valuechanged(this, '").append(b.getActualID()).append("', event)").toString());
        }
        if (b.getOnMouseDownJS() != null) {
            o.attr("onmousedown", b.getOnMouseDownJS());
        }
    }

    @Override
    public void visitDiv(Div n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        if (n.getTag().equals("body")) {
            this.o().attr("onunload", "WebUI.unloaded()");
        }
        if (n.getReturnPressed() != null) {
            this.o().attr("onkeypress", "return WebUI.returnKeyPress(event, this)");
        }
        if (n.getDropBody() != null) {
            this.o().attr("uidropbody", ((NodeBase)((Object)n.getDropBody())).getActualID());
        }
        if (n.getDropMode() != null) {
            this.o().attr("uidropmode", n.getDropMode().name());
        }
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitSpan(Span n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitUnderline(Underline n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitTable(Table n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        if (n.getTableBorder() != -1) {
            this.o().attr("border", n.getTableBorder());
        }
        if (n.getCellPadding() != null) {
            this.o().attr("cellpadding", n.getCellPadding());
        }
        if (n.getCellSpacing() != null) {
            this.o().attr("cellspacing", n.getCellSpacing());
        }
        if (n.getTableWidth() != null) {
            this.o().attr("width", n.getTableWidth());
        }
        if (n.getTableHeight() != null) {
            this.o().attr("height", n.getTableHeight());
        }
        if (n.getAlign() != null) {
            this.o().attr("align", n.getAlign().getCode());
        }
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitTHead(THead n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitTBody(TBody n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitTD(TD n) throws Exception {
        this.o().setIndentEnabled(false);
        this.basicNodeRender(n, this.m_o);
        if (n.getValign() != null) {
            switch (n.getValign()) {
                default: {
                    throw new IllegalStateException("Unknown valign: " + (Object)((Object)n.getValign()));
                }
                case BOTTOM: {
                    this.o().attr("valign", "bottom");
                    break;
                }
                case TOP: {
                    this.o().attr("valign", "top");
                    break;
                }
                case MIDDLE: {
                    this.o().attr("valign", "middle");
                }
            }
        }
        if (n.getColspan() > 0) {
            this.o().attr("colspan", n.getColspan());
        }
        if (n.getRowspan() > 0) {
            this.o().attr("rowspan", n.getRowspan());
        }
        if (n.isNowrap()) {
            this.o().attr("nowrap", "nowrap");
        }
        if (n.getCellHeight() != null) {
            this.o().attr("height", n.getCellHeight());
        }
        if (n.getCellWidth() != null) {
            this.o().attr("width", n.getCellWidth());
        }
        if (n.getAlign() != null) {
            this.o().attr("align", n.getAlign().getCode());
        }
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitTH(TH n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        if (n.getValign() != null) {
            switch (n.getValign()) {
                default: {
                    throw new IllegalStateException("Unknown valign: " + (Object)((Object)n.getValign()));
                }
                case BOTTOM: {
                    this.o().attr("valign", "bottom");
                    break;
                }
                case TOP: {
                    this.o().attr("valign", "top");
                    break;
                }
                case MIDDLE: {
                    this.o().attr("valign", "middle");
                }
            }
        }
        if (n.getColspan() > 0) {
            this.o().attr("colspan", n.getColspan());
        }
        if (n.getRowspan() > 0) {
            this.o().attr("rowspan", n.getRowspan());
        }
        if (n.isNowrap()) {
            this.o().attr("nowrap", "nowrap");
        }
        if (n.getCellHeight() != null) {
            this.o().attr("height", n.getCellHeight());
        }
        if (n.getCellWidth() != null) {
            this.o().attr("width", n.getCellWidth());
        }
        if (n.getAlign() != null) {
            this.o().attr("align", n.getAlign().getCode());
        }
        if (n.getScope() != null) {
            this.o().attr("scope", n.getScope());
        }
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitTR(TR n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitTextNode(TextNode n) throws Exception {
        String lit = n.getText();
        if (lit != null && lit.length() > 0) {
            this.m_o.text(lit);
        }
    }

    @Override
    public void visitXmlNode(XmlTextNode n) throws Exception {
        String lit = n.getText();
        if (lit != null && lit.length() > 0) {
            this.m_o.setIndentEnabled(false);
            this.m_o.text("");
            this.m_o.writeRaw(lit);
        }
    }

    public void renderEndTag(NodeBase b) throws IOException {
        if (!this.m_tagless) {
            this.m_o.closetag(b.getTag());
        }
    }

    @Override
    public void visitA(ATag a) throws Exception {
        this.basicNodeRender(a, this.m_o);
        if (a.getHref() == null || a.getHref().trim().length() == 0) {
            this.o().attr("href", "javascript: void(0);");
        } else {
            this.o().attr("href", a.getHref());
        }
        if (a.getTarget() != null) {
            this.o().attr("target", a.getTarget());
        }
        this.renderTagend(a, this.m_o);
    }

    @Override
    public void visitLi(Li n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitUl(Ul n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        this.renderTagend(n, this.m_o);
    }

    private void renderType(String t) throws Exception {
        if (this.isAttrRender()) {
            return;
        }
        this.o().attr("type", t);
    }

    @Override
    public void visitInput(Input n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        this.o().attr("name", n.getActualID());
        this.renderType(n.getInputType());
        this.renderDiRo(n, n.isDisabled(), n.isReadOnly());
        if (n.getMaxLength() > 0) {
            this.o().attr("maxlength", n.getMaxLength());
        }
        if (n.getSize() > 0) {
            this.o().attr("size", n.getSize());
        }
        if (n.getRawValue() != null) {
            this.o().attr("value", n.getRawValue());
        }
        String transformScript = "";
        if (n.getTransform() != null) {
            switch (n.getTransform()) {
                case LOWERCASE: {
                    transformScript = "this.value=this.value.toLowerCase();";
                    break;
                }
                case UPPERCASE: {
                    transformScript = "this.value=this.value.toUpperCase();";
                    break;
                }
            }
        }
        if (n.getOnLookupTyping() != null) {
            StringBuilder sb = this.sb();
            if (!DomUtil.isBlank(n.getOnKeyPressJS())) {
                sb.append("if(! ").append(n.getOnKeyPressJS()).append(") return false;");
            }
            sb.append("WebUI.onLookupTypingReturnKeyHandler('").append(n.getActualID()).append("', event)");
            this.o().attr("onkeypress", sb.toString());
            this.o().attr("onkeyup", this.sb().append("WebUI.scheduleOnLookupTypingEvent('").append(n.getActualID()).append("', event)").toString());
            this.o().attr("onblur", this.sb().append(transformScript).append("WebUI.hideLookupTypingPopup('").append(n.getActualID()).append("')").toString());
        } else {
            if (!StringTool.isBlank((String)n.getOnKeyPressJS())) {
                this.o().attr("onkeypress", "return " + n.getOnKeyPressJS());
            }
            if (!StringTool.isBlank((String)transformScript)) {
                this.o().attr("onblur", this.sb().append(transformScript).toString());
            }
        }
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitFileInput(FileInput n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        this.o().attr("type", "file");
        this.o().attr("name", n.getActualID());
        this.renderDisabled(n, n.isDisabled());
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitCheckbox(Checkbox n) throws Exception {
        this.basicNodeRender(n, this.m_o, true);
        this.renderType("checkbox");
        this.o().attr("name", n.getActualID());
        this.renderDisabled(n, n.isDisabled());
        this.renderChecked(n, n.isChecked());
        if (this.m_browserVersion.isIE()) {
            if (n.internalNeedClickHandler() || n.getOnValueChanged() != null) {
                this.m_o.attr("onclick", this.sb().append("WebUI.clickandchange(this, '").append(n.getActualID()).append("', event); return true;").toString());
            } else if (n.getOnClickJS() != null) {
                this.m_o.attr("onclick", n.getOnClickJS());
            }
        } else {
            if (n.internalNeedClickHandler()) {
                this.m_o.attr("onclick", this.sb().append("WebUI.clicked(this, '").append(n.getActualID()).append("', event); return true;").toString());
            } else if (n.getOnClickJS() != null) {
                this.m_o.attr("onclick", n.getOnClickJS());
            }
            if (null != n.getOnValueChanged()) {
                this.m_o.attr("onchange", this.sb().append("WebUI.valuechanged(this, '").append(n.getActualID()).append("', event)").toString());
            }
        }
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitRadioButton(RadioButton<?> n) throws Exception {
        this.basicNodeRender(n, this.m_o, true);
        this.renderType("radio");
        if (n.getName() != null) {
            this.o().attr("name", n.getName());
        }
        this.renderDiRo(n, n.isDisabled() || n.isReadOnly(), false);
        this.renderChecked(n, n.isChecked());
        if (this.m_browserVersion.isIE()) {
            if (n.internalNeedClickHandler() || n.getGroup().getOnValueChanged() != null) {
                this.m_o.attr("onclick", this.sb().append("WebUI.clickandchange(this, '").append(n.getActualID()).append("', event); return true;").toString());
            } else if (n.getOnClickJS() != null) {
                this.m_o.attr("onclick", n.getOnClickJS());
            }
        } else {
            if (n.internalNeedClickHandler()) {
                this.m_o.attr("onclick", this.sb().append("WebUI.clicked(this, '").append(n.getActualID()).append("', event); return true;").toString());
            } else if (n.getOnClickJS() != null) {
                this.m_o.attr("onclick", n.getOnClickJS());
            } else if (n.getGroup().getClicked() != null) {
                this.m_o.attr("onclick", this.sb().append("WebUI.clicked(this, '").append(n.getActualID()).append("', event); return true;").toString());
            }
            if (null != n.getGroup().getOnValueChanged()) {
                this.m_o.attr("onchange", this.sb().append("WebUI.valuechanged(this, '").append(n.getActualID()).append("', event); return true;").toString());
            }
        }
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitImg(Img n) throws Exception {
        String src;
        this.o().setIndentEnabled(false);
        this.basicNodeRender(n, this.o());
        if (n.getAlign() != null) {
            this.o().attr("align", n.getAlign().getCode());
        }
        if (n.getAlt() != null) {
            this.o().attr("alt", n.getAlt());
        }
        if (null != (src = n.getSrc())) {
            src = n.getThemedResourceRURL(src);
            if (n.isDisabled() && !src.startsWith("http")) {
                src = GrayscalerPart.getURL(src);
            }
            this.o().attr("src", src);
        }
        if (n.getImgBorder() >= 0) {
            this.o().attr("border", n.getImgBorder());
        }
        if (n.getImgWidth() != null) {
            this.o().attr("width", n.getImgWidth());
        }
        if (n.getImgHeight() != null) {
            this.o().attr("height", n.getImgHeight());
        }
        this.renderTagend(n, this.o());
    }

    @Override
    public void visitButton(Button n) throws Exception {
        this.o().setIndentEnabled(false);
        this.basicNodeRender(n, this.o());
        this.renderDisabled(n, n.isDisabled());
        if (n.getType() != null && !this.isAttrRender()) {
            this.o().attr("type", n.getType().getCode());
        }
        if (n.getButtonValue() != null) {
            this.o().attr("value", n.getButtonValue());
        }
        if (n.getAccessKey() != '\u0000') {
            this.o().attr("accesskey", "" + n.getAccessKey());
        }
        this.renderTagend(n, this.o());
    }

    @Override
    public void visitPre(Pre n) throws Exception {
        this.o().setIndentEnabled(false);
        this.visitDiv(n);
    }

    @Override
    public void visitLabel(Label n) throws Exception {
        this.basicNodeRender(n, this.o());
        if (n.getFor() != null) {
            this.o().attr("for", n.getFor());
        }
        this.renderTagend(n, this.o());
    }

    @Override
    public void visitSelect(Select n) throws Exception {
        this.basicNodeRender(n, this.o());
        if (n.isMultiple()) {
            this.o().attr("multiple", "multiple");
        }
        this.renderDisabled(n, n.isDisabled());
        if (n.getSize() > 0) {
            this.o().attr("size", n.getSize());
        }
        if (n.getReturnPressed() != null) {
            this.o().attr("onkeypress", "return WebUI.returnKeyPress(event, this)");
        }
        this.renderTagend(n, this.o());
    }

    @Override
    public void visitOption(SelectOption n) throws Exception {
        this.basicNodeRender(n, this.o());
        this.renderDisabled(n, n.isDisabled());
        this.renderSelected(n, n.isSelected());
        this.o().attr("value", n.getActualID());
        this.renderTagend(n, this.o());
    }

    @Override
    public void visitBR(BR n) throws Exception {
        this.basicNodeRender(n, this.o());
        this.renderTagend(n, this.o());
    }

    @Override
    public void visitTextArea(TextArea n) throws Exception {
        this.basicNodeRender(n, this.o());
        if (n.getCols() > 0) {
            this.o().attr("cols", n.getCols());
        }
        if (n.getRows() > 0) {
            this.o().attr("rows", n.getRows());
        }
        this.renderDiRo(n, n.isDisabled(), n.isReadOnly());
        if (this.getMode() != HtmlRenderMode.FULL) {
            String txt = n.getRawValue();
            if (txt == null) {
                txt = "";
            }
            txt = StringTool.strToJavascriptString((String)txt, (boolean)false);
            this.o().attr("domjs_value", txt);
        }
        if (n.getMaxLength() > 0) {
            this.o().attr("mxlength", n.getMaxLength());
        }
        if (n.getMaxByteLength() > 0) {
            this.o().attr("maxbytes", n.getMaxByteLength());
        }
        this.renderTagend(n, this.o());
        this.o().setIndentEnabled(false);
    }

    @Override
    public void visitForm(Form n) throws Exception {
        this.basicNodeRender(n, this.o());
        if (n.getAction() != null) {
            this.o().attr("action", n.getAction());
        }
        if (n.getMethod() != null) {
            this.o().attr("method", n.getMethod());
        }
        if (n.getEnctype() != null) {
            this.o().attr("enctype", n.getEnctype());
            this.o().attr("encoding", n.getEnctype());
        }
        if (n.getTarget() != null) {
            this.o().attr("target", n.getTarget());
        }
        this.renderTagend(n, this.o());
    }

    @Override
    @Deprecated
    public void visitLiteralXhtml(LiteralXhtml n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        this.renderTagend(n, this.m_o);
        if (n.getXml() != null) {
            if (n.getTag().equalsIgnoreCase("pre")) {
                this.o().setIndentEnabled(false);
            }
            this.o().writeRaw(n.getXml());
            if (n.getTag().equalsIgnoreCase("pre")) {
                this.o().setIndentEnabled(true);
            }
        }
    }

    @Override
    public void visitH(HTag n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        this.renderTagend(n, this.m_o);
    }

    @Override
    public void visitIFrame(IFrame n) throws Exception {
        this.basicNodeRender(n, this.m_o);
        if (n.getSrc() != null) {
            this.o().attr("src", n.getSrc());
        }
        if (n.getFrameBorder() != null) {
            this.o().attr("frameBorder", n.getFrameBorder());
        }
        if (n.getFrameHeight() != null) {
            this.o().attr("height", n.getFrameHeight());
        }
        if (n.getFrameWidth() != null) {
            this.o().attr("width", n.getFrameWidth());
        }
        if (n.getMarginHeight() != null) {
            this.o().attr("marginheight", n.getMarginHeight());
        }
        if (n.getMarginWidth() != null) {
            this.o().attr("marginwidth", n.getMarginWidth());
        }
        if (n.getName() != null) {
            this.o().attr("name", n.getName());
        }
        if (n.getScrolling() != null) {
            this.o().attr("scrolling", n.getScrolling());
        }
        this.renderTagend(n, this.m_o);
        this.renderEndTag(n);
    }
}

