/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom;

import java.io.IOException;
import to.etc.domui.dom.HtmlRenderMode;
import to.etc.domui.dom.HtmlTagRenderer;
import to.etc.domui.dom.IBrowserOutput;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TextArea;
import to.etc.domui.server.BrowserVersion;
import to.etc.util.StringTool;

public class MsGarbageHtmlTagRenderer
extends HtmlTagRenderer {
    public MsGarbageHtmlTagRenderer(BrowserVersion bv, IBrowserOutput o, boolean uiTestMode) {
        super(bv, o, uiTestMode);
    }

    @Override
    protected void renderDisabled(NodeBase n, boolean disabled) throws IOException {
        if (!this.isFullRender() && this.getBrowser().getMajorVersion() < 11) {
            this.addDelayedAttrs(n, "disabled", disabled ? "true" : "false");
        } else {
            super.renderDisabled(n, disabled);
        }
    }

    @Override
    protected void renderReadOnly(NodeBase n, boolean readonly) throws IOException {
        if (!this.isFullRender() && this.getBrowser().getMajorVersion() < 11) {
            this.addDelayedAttrs(n, "readOnly", readonly ? "true" : "false");
        } else {
            super.renderReadOnly(n, readonly);
        }
    }

    @Override
    protected void renderChecked(NodeBase n, boolean checked) throws IOException {
        if (!this.isFullRender() && this.getBrowser().getMajorVersion() < 11) {
            this.addDelayedAttrs(n, "checked", checked ? "true" : "false");
        } else {
            super.renderChecked(n, checked);
        }
    }

    @Override
    protected void renderSelected(NodeBase n, boolean checked) throws IOException {
        if (!this.isFullRender() && this.getBrowser().getMajorVersion() < 11) {
            this.addDelayedAttrs(n, "selected", checked ? "true" : "false");
        } else {
            super.renderSelected(n, checked);
        }
    }

    @Override
    public void visitTextArea(TextArea n) throws Exception {
        String txt;
        this.basicNodeRender(n, this.o());
        if (n.getCols() > 0) {
            this.o().attr("cols", n.getCols());
        }
        if (n.getRows() > 0) {
            this.o().attr("rows", n.getRows());
        }
        this.renderDiRo(n, n.isDisabled(), n.isReadOnly());
        if (this.getMode() != HtmlRenderMode.FULL && (txt = n.getRawValue()) != null) {
            txt = StringTool.strToJavascriptString((String)txt, (boolean)false);
            this.o().attr("domjs_value", txt);
        }
        if (n.getMaxLength() > 0) {
            this.o().attr("maxlength", n.getMaxLength());
        }
        this.renderTagend(n, this.o());
        this.o().setIndentEnabled(false);
    }
}

