/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom;

import java.io.IOException;
import java.io.Writer;

public class XmlOutputWriterBase {
    private Writer m_w;
    protected boolean m_intag;

    public XmlOutputWriterBase(Writer w) {
        this.m_w = w;
    }

    protected Writer getWriter() {
        return this.m_w;
    }

    public void text(String s) throws IOException {
        if (s == null) {
            throw new IllegalStateException("Attempt to write null cdata.");
        }
        this.closePrevious();
        int sl = s.length();
        block6: for (int ix = 0; ix < sl; ++ix) {
            int runstart = ix;
            char c = '\u0000';
            while (ix < sl && (c = s.charAt(ix)) != '<' && c != '>' && c != '&' && c != '\n') {
                ++ix;
            }
            if (ix > runstart) {
                this.writeRaw(s, runstart, ix - runstart);
                if (ix >= sl) {
                    return;
                }
            }
            switch (c) {
                case '>': {
                    this.writeRaw("&gt;");
                    continue block6;
                }
                case '<': {
                    this.writeRaw("&lt;");
                    continue block6;
                }
                case '&': {
                    this.writeRaw("&amp;");
                    continue block6;
                }
                case '\n': {
                    this.println();
                }
            }
        }
    }

    protected void println() throws IOException {
        this.m_w.write("\n");
    }

    public void nl() throws IOException {
    }

    public void inc() {
    }

    public void dec() {
    }

    public boolean isIndentEnabled() {
        return false;
    }

    public void tag(String tagname) throws IOException {
        this.closePrevious();
        if (this.isIndentEnabled()) {
            this.nl();
        }
        this.writeRaw("<");
        this.writeRaw(tagname);
        this.m_intag = true;
        this.inc();
    }

    private void closePrevious() throws IOException {
        if (!this.m_intag) {
            return;
        }
        this.m_intag = false;
        this.writeRaw(">");
    }

    public void endtag() throws IOException {
        if (!this.m_intag) {
            throw new IllegalStateException("Ending tag but not in a tag?");
        }
        this.m_intag = false;
        this.writeRaw(">");
    }

    public void endAndCloseXmltag() throws IOException {
        if (!this.m_intag) {
            throw new IllegalStateException("Ending tag but not in a tag?");
        }
        this.m_intag = false;
        this.writeRaw("/>");
        this.dec();
    }

    public void closetag(String name) throws IOException {
        this.closePrevious();
        this.dec();
        this.writeRaw("</");
        this.writeRaw(name);
        this.writeRaw(">");
        if (this.isIndentEnabled()) {
            this.nl();
        }
    }

    public void attr(String name, String value) throws IOException {
        if (!this.m_intag) {
            throw new IllegalStateException("No tag is currently 'active'");
        }
        this.writeRaw(" ");
        this.writeRaw(name);
        this.writeRaw("=\"");
        this.writeAttrValue(value);
        this.writeRaw("\"");
    }

    public void rawAttr(String name, String value) throws IOException {
        if (!this.m_intag) {
            throw new IllegalStateException("No tag is currently 'active'");
        }
        this.writeRaw(" ");
        this.writeRaw(name);
        this.writeRaw("=\"");
        this.writeRaw(value);
        this.writeRaw("\"");
    }

    private void writeAttrValue(String value) throws IOException {
        int len = value.length();
        int pos = 0;
        String entity = null;
        while (pos < len) {
            int spos = pos;
            while (pos < len) {
                entity = null;
                char c = value.charAt(pos);
                switch (c) {
                    default: {
                        ++pos;
                        break;
                    }
                    case '&': {
                        entity = "&amp;";
                        break;
                    }
                    case '<': {
                        entity = "&lt;";
                        break;
                    }
                    case '>': {
                        entity = "&gt;";
                        break;
                    }
                    case '\n': {
                        entity = "&#0010;";
                        break;
                    }
                    case '\r': {
                        entity = "&#0013;";
                        break;
                    }
                    case '\"': {
                        entity = "&quot;";
                    }
                }
                if (entity == null) continue;
                break;
            }
            if (pos > spos) {
                this.writeRaw(value, spos, pos - spos);
            }
            if (entity == null) continue;
            this.writeRaw(entity);
            ++pos;
        }
    }

    public void attr(String name, long value) throws IOException {
        this.attr(name, Long.toString(value));
    }

    public void attr(String name, int value) throws IOException {
        this.attr(name, Integer.toString(value));
    }

    public void attr(String name, boolean value) throws IOException {
        this.attr(name, Boolean.toString(value));
    }

    public void writeRaw(CharSequence s) throws IOException {
        this.m_w.append(s);
    }

    protected void writeRaw(String s, int off, int len) throws IOException {
        this.m_w.write(s, off, len);
    }
}

