/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.errors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.errors.IErrorFence;
import to.etc.domui.dom.errors.IErrorMessageListener;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.server.DomApplication;

public class ErrorFenceHandler
implements IErrorFence {
    private NodeContainer m_container;
    private List<IErrorMessageListener> m_errorListeners = Collections.EMPTY_LIST;
    private List<UIMessage> m_messageList = Collections.EMPTY_LIST;

    public ErrorFenceHandler(NodeContainer container) {
        this.m_container = container;
    }

    public NodeContainer getContainer() {
        return this.m_container;
    }

    @Override
    public void addErrorListener(@Nonnull IErrorMessageListener eml) {
        if (this.m_errorListeners == Collections.EMPTY_LIST) {
            this.m_errorListeners = new ArrayList<IErrorMessageListener>(4);
        }
        if (!this.m_errorListeners.contains(eml)) {
            this.m_errorListeners.add(eml);
        }
    }

    @Override
    public void removeErrorListener(@Nonnull IErrorMessageListener eml) {
        this.m_errorListeners.remove(eml);
    }

    @Override
    public void addMessage(@Nonnull UIMessage uim) {
        if (this.m_messageList == Collections.EMPTY_LIST) {
            this.m_messageList = new ArrayList<UIMessage>(15);
        }
        this.m_messageList.add(uim);
        if (this.m_errorListeners.size() == 0) {
            DomApplication.get().addDefaultErrorComponent(this.getContainer());
        }
        for (IErrorMessageListener eml : this.m_errorListeners) {
            try {
                eml.errorMessageAdded(uim);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    @Override
    public void removeMessage(@Nonnull UIMessage uim) {
        if (!this.m_messageList.remove(uim)) {
            return;
        }
        List<IErrorMessageListener> list = this.m_errorListeners;
        for (IErrorMessageListener eml : new ArrayList<IErrorMessageListener>(list)) {
            try {
                eml.errorMessageRemoved(uim);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    @Override
    public void clearGlobalMessages(@Nullable String code) {
        ArrayList<UIMessage> todo = new ArrayList<UIMessage>();
        for (UIMessage m : this.m_messageList) {
            if (code != null && code.equals(m.getGroup())) {
                todo.add(m);
                continue;
            }
            if (m.getErrorNode() != null || code != null && !code.equals(m.getCode())) continue;
            todo.add(m);
        }
        for (UIMessage m : todo) {
            this.removeMessage(m);
        }
    }

    @Override
    public List<UIMessage> getMessageList() {
        return this.m_messageList;
    }
}

