/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.errors;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.errors.MsgType;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.logic.errors.ProblemInstance;
import to.etc.domui.trouble.UIException;
import to.etc.domui.util.Msgs;
import to.etc.webapp.nls.BundleRef;
import to.etc.webapp.nls.CodeException;

public class UIMessage {
    @Nonnull
    private static final Object[] NONE = new Object[0];
    @Nonnull
    private BundleRef m_bundle;
    @Nonnull
    private String m_code;
    @Nonnull
    private final MsgType m_type;
    private String m_errorLocation;
    @Nonnull
    private Object[] m_parameters;
    private NodeBase m_errorNode;
    private String m_group;
    private final String m_key;

    protected UIMessage(@Nullable NodeBase errorNode, @Nullable String errorLocation, @Nonnull MsgType type, @Nonnull BundleRef br, @Nonnull String code, @Nullable Object[] parameters) {
        this(errorNode, errorLocation, type, br, code, parameters, null);
    }

    protected UIMessage(@Nullable NodeBase errorNode, @Nullable String errorLocation, @Nonnull MsgType type, @Nonnull BundleRef br, @Nonnull String code, @Nullable Object[] parameters, @Nullable String group) {
        if (code == null) {
            throw new NullPointerException("Message code cannot be null");
        }
        if (type == null) {
            throw new NullPointerException("Message type cannot be null");
        }
        this.m_bundle = br;
        this.m_errorNode = errorNode;
        this.m_code = code;
        this.m_parameters = parameters == null ? NONE : parameters;
        this.m_type = type;
        this.m_errorLocation = errorLocation;
        this.m_group = group;
        this.m_key = br.getBundleKey() + "#" + code;
    }

    public String getMessageKey() {
        return this.m_key;
    }

    @Nonnull
    public UIMessage group(@Nonnull String name) {
        this.m_group = name;
        return this;
    }

    @Nullable
    public String getGroup() {
        return this.m_group;
    }

    public String getCode() {
        return this.m_code;
    }

    @Nullable
    public BundleRef getBundle() {
        return this.m_bundle;
    }

    @Nonnull
    public Object[] getParameters() {
        return this.m_parameters;
    }

    @Nullable
    public NodeBase getErrorNode() {
        return this.m_errorNode;
    }

    public void setErrorNode(@Nullable NodeBase errorNode) {
        this.m_errorNode = errorNode;
    }

    @Nonnull
    public MsgType getType() {
        return this.m_type;
    }

    @Nullable
    public String getErrorLocation() {
        return this.m_errorLocation;
    }

    public void setErrorLocation(String errorLocation) {
        this.m_errorLocation = errorLocation;
    }

    @Nonnull
    public UIMessage location(@Nullable String errorLocation) {
        this.m_errorLocation = errorLocation;
        return this;
    }

    @Nonnull
    public String getMessage() {
        if (this.m_bundle != null) {
            return this.m_bundle.formatMessage(this.m_code, this.m_parameters);
        }
        return Msgs.BUNDLE.formatMessage(this.m_code, this.m_parameters);
    }

    @Nonnull
    public static UIMessage create(@Nullable NodeBase n, @Nonnull ProblemInstance pi) {
        return new UIMessage(n, null, pi.getProblem().getSeverity(), pi.getProblem().getBundle(), pi.getProblem().getCode(), pi.getParameters());
    }

    @Nonnull
    public static UIMessage error(@Nonnull CodeException x) {
        return new UIMessage(null, null, MsgType.ERROR, x.getBundle(), x.getCode(), x.getParameters());
    }

    @Nonnull
    public static UIMessage error(@Nonnull UIException x) {
        return new UIMessage(null, null, MsgType.ERROR, x.getBundle(), x.getCode(), x.getParameters());
    }

    @Nonnull
    public static UIMessage error(NodeBase node, String errorLocation, @Nonnull BundleRef ref, @Nonnull String code, Object ... param) {
        return new UIMessage(node, errorLocation, MsgType.ERROR, ref, code, param);
    }

    @Nonnull
    public static UIMessage error(String errorLocation, @Nonnull BundleRef ref, @Nonnull String code, Object ... param) {
        return new UIMessage(null, errorLocation, MsgType.ERROR, ref, code, param);
    }

    @Nonnull
    public static UIMessage error(NodeBase node, @Nonnull BundleRef ref, @Nonnull String code, Object ... param) {
        return new UIMessage(node, node.getErrorLocation(), MsgType.ERROR, ref, code, param);
    }

    @Nonnull
    public static UIMessage error(@Nonnull BundleRef ref, @Nonnull String code, Object ... param) {
        return new UIMessage(null, null, MsgType.ERROR, ref, code, param);
    }

    @Nonnull
    public static UIMessage warning(NodeBase node, String errorLocation, @Nonnull BundleRef ref, @Nonnull String code, Object ... param) {
        return new UIMessage(node, errorLocation, MsgType.WARNING, ref, code, param);
    }

    @Nonnull
    public static UIMessage warning(NodeBase node, @Nonnull BundleRef ref, @Nonnull String code, Object ... param) {
        return new UIMessage(node, null, MsgType.WARNING, ref, code, param);
    }

    @Nonnull
    public static UIMessage warning(@Nonnull BundleRef ref, @Nonnull String code, Object ... param) {
        return new UIMessage(null, null, MsgType.WARNING, ref, code, param);
    }

    @Nonnull
    public static UIMessage info(@Nonnull BundleRef ref, @Nonnull String code, Object ... param) {
        return new UIMessage(null, null, MsgType.INFO, ref, code, param);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_bundle == null ? 0 : this.m_bundle.hashCode());
        result = 31 * result + (this.m_code == null ? 0 : this.m_code.hashCode());
        result = 31 * result + (this.m_errorNode == null ? 0 : this.m_errorNode.hashCode());
        result = 31 * result + Arrays.hashCode(this.m_parameters);
        result = 31 * result + (this.m_type == null ? 0 : this.m_type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UIMessage other = (UIMessage)obj;
        if (this.m_bundle == null ? other.m_bundle != null : !this.m_bundle.equals(other.m_bundle)) {
            return false;
        }
        if (this.m_code == null ? other.m_code != null : !this.m_code.equals(other.m_code)) {
            return false;
        }
        if (this.m_errorNode == null ? other.m_errorNode != null : !this.m_errorNode.equals(other.m_errorNode)) {
            return false;
        }
        if (!Arrays.equals(this.m_parameters, other.m_parameters)) {
            return false;
        }
        if (this.m_type == null ? other.m_type != null : !this.m_type.equals((Object)other.m_type)) {
            return false;
        }
        if (this.m_group == null ? other.m_group != null : !this.m_group.equals(other.m_group)) {
            return false;
        }
        return !(this.m_errorLocation == null ? other.m_errorLocation != null : !this.m_errorLocation.equals(other.m_errorLocation));
    }

    @Nonnull
    public String toString() {
        return this.getMessage();
    }
}

