/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.header;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.domui.dom.HtmlFullRenderer;
import to.etc.domui.dom.header.CssContributor;
import to.etc.domui.dom.header.GoogleChartsContributor;
import to.etc.domui.dom.header.HeaderContributorEntry;
import to.etc.domui.dom.header.JavaScriptletContributor;
import to.etc.domui.dom.header.JavascriptContributor;
import to.etc.domui.dom.header.ThemedJavascriptContributor;
import to.etc.domui.dom.html.OptimalDeltaRenderer;

public abstract class HeaderContributor {
    private static final String GOOGLE_CHARTS = "googlecharts";
    public static final Comparator<HeaderContributorEntry> C_ENTRY = new Comparator<HeaderContributorEntry>(){

        @Override
        public int compare(HeaderContributorEntry a, HeaderContributorEntry b) {
            return a.getOrder() - b.getOrder();
        }
    };
    private static Map<String, HeaderContributor> m_jsMap = new HashMap<String, HeaderContributor>();

    public abstract void contribute(HtmlFullRenderer var1) throws Exception;

    public abstract void contribute(OptimalDeltaRenderer var1) throws Exception;

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @Nonnull
    public static synchronized HeaderContributor loadJavascript(String name) {
        HeaderContributor c = m_jsMap.get(name);
        if (c == null) {
            c = new JavascriptContributor(name);
            m_jsMap.put(name, c);
        }
        return c;
    }

    @Nonnull
    public static synchronized HeaderContributor loadJavaScriptlet(String name) {
        HeaderContributor c = m_jsMap.get(name);
        if (c == null) {
            c = new JavaScriptletContributor(name);
            m_jsMap.put(name, c);
        }
        return c;
    }

    public static synchronized HeaderContributor loadStylesheet(String name) {
        HeaderContributor c = m_jsMap.get(name);
        if (c == null) {
            c = new CssContributor(name);
            m_jsMap.put(name, c);
        }
        return c;
    }

    public static synchronized HeaderContributor loadThemedJavasciptContributor(String name) {
        HeaderContributor c = m_jsMap.get(name);
        if (c == null) {
            c = new ThemedJavascriptContributor(name);
            m_jsMap.put(name, c);
        }
        return c;
    }

    public static synchronized HeaderContributor loadGoogleAnalytics(String uacode) {
        HeaderContributor c = m_jsMap.get(uacode);
        if (c == null) {
            StringBuilder blurb = new StringBuilder();
            blurb.append("\n\nvar _gaq = _gaq || [];\n");
            blurb.append("_gaq.push(['_setAccount', '" + uacode + "']);\n");
            blurb.append("_gaq.push(['_trackPageview']);\n");
            blurb.append("(function() {\n");
            blurb.append("var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;\n");
            blurb.append("ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';\n");
            blurb.append("var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);\n");
            blurb.append("})();\n");
            c = HeaderContributor.loadJavaScriptlet(blurb.toString());
            m_jsMap.put(uacode, c);
        }
        return c;
    }

    public static synchronized HeaderContributor loadGoogleCharts() {
        HeaderContributor hc = m_jsMap.get(GOOGLE_CHARTS);
        if (hc == null) {
            hc = new GoogleChartsContributor();
            m_jsMap.put(GOOGLE_CHARTS, hc);
        }
        return hc;
    }
}

