/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import java.util.Objects;
import javax.annotation.Nullable;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.ButtonType;
import to.etc.domui.dom.html.IActionControl;
import to.etc.domui.dom.html.INodeVisitor;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.util.DomUtil;

public class Button
extends NodeContainer
implements IActionControl {
    private boolean m_disabled;
    private ButtonType m_type = ButtonType.BUTTON;
    private String m_buttonValue;
    private char m_accessKey;
    @Nullable
    private String m_disabledBecause;

    public Button() {
        super("button");
    }

    @Override
    public void visit(INodeVisitor v) throws Exception {
        v.visitButton(this);
    }

    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.m_disabled != disabled) {
            this.changed();
        }
        this.m_disabled = disabled;
        if (!disabled) {
            this.setOverrideTitle(null);
        }
    }

    public void setDisabled(@Nullable UIMessage rsn) {
        if (null != rsn) {
            this.setDisabled(true);
            this.setOverrideTitle(rsn.getMessage());
            this.m_disabledBecause = rsn.getMessage();
        } else {
            this.setDisabled(false);
            this.setOverrideTitle(null);
            this.m_disabledBecause = null;
        }
    }

    @Nullable
    public String getDisabledBecause() {
        return this.m_disabledBecause;
    }

    public void setDisabledBecause(@Nullable String msg) {
        if (Objects.equals(msg, this.m_disabledBecause)) {
            return;
        }
        this.m_disabledBecause = msg;
        this.setOverrideTitle(msg);
        this.setDisabled(msg != null);
    }

    public ButtonType getType() {
        return this.m_type;
    }

    public void setType(ButtonType type) {
        if (this.m_type != type) {
            this.changed();
        }
        this.m_type = type;
    }

    public String getButtonValue() {
        return this.m_buttonValue;
    }

    public void setButtonValue(String value) {
        if (!DomUtil.isEqual((Object)value, (Object)this.m_buttonValue)) {
            this.changed();
        }
        this.m_buttonValue = value;
    }

    public char getAccessKey() {
        return this.m_accessKey;
    }

    public void setAccessKey(char accessKey) {
        this.m_accessKey = accessKey;
    }
}

