/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IHasModifiedIndication;
import to.etc.domui.dom.html.INativeChangeListener;
import to.etc.domui.dom.html.INodeVisitor;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.util.DomUtil;

public class Checkbox
extends NodeBase
implements INativeChangeListener,
IControl<Boolean>,
IHasModifiedIndication {
    public static final String TYPE_HINT = "Checkbox";
    private boolean m_checked;
    private boolean m_disabled;
    private boolean m_mandatory;
    private boolean m_modifiedByUser;
    private IValueChanged<?> m_onValueChanged;
    private boolean m_immediate;
    @Nullable
    private String m_disabledBecause;

    public Checkbox() {
        super("input");
    }

    @Override
    public void visit(INodeVisitor v) throws Exception {
        v.visitCheckbox(this);
    }

    public boolean isChecked() {
        return this.m_checked;
    }

    public void setChecked(boolean checked) {
        if (this.m_checked == checked) {
            return;
        }
        this.changed();
        this.m_checked = checked;
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.m_disabled == disabled) {
            return;
        }
        this.changed();
        this.m_disabled = disabled;
    }

    @Nullable
    public String getDisabledBecause() {
        return this.m_disabledBecause;
    }

    public void setDisabledBecause(@Nullable String msg) {
        if (Objects.equals(msg, this.m_disabledBecause)) {
            return;
        }
        this.m_disabledBecause = msg;
        this.setOverrideTitle(msg);
        this.setDisabled(msg != null);
    }

    @Override
    public boolean isReadOnly() {
        return this.isDisabled();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.setDisabled(readOnly);
    }

    @Override
    public boolean acceptRequestParameter(@Nonnull String[] values) {
        if (this.isDisabled()) {
            return false;
        }
        if (values == null || values.length != 1) {
            throw new IllegalStateException("Checkbox: expecting a single input value, not " + Arrays.toString(values));
        }
        String s = values[0].trim();
        boolean on = "y".equalsIgnoreCase(s);
        if (this.m_checked == on) {
            return false;
        }
        DomUtil.setModifiedFlag(this);
        this.setChecked(on);
        return true;
    }

    @Override
    @Nonnull
    public Boolean getValue() {
        return this.isChecked();
    }

    @Override
    public void setValue(@Nullable Boolean v) {
        this.setChecked(v == null ? false : v);
    }

    @Override
    public Boolean getValueSafe() {
        return DomUtil.getValueSafe(this);
    }

    @Override
    public boolean hasError() {
        this.getValueSafe();
        return super.hasError();
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    @Override
    @Deprecated
    public IValueChanged<?> getOnValueChanged() {
        IValueChanged<?> vc = this.m_onValueChanged;
        if (null == vc && this.isImmediate()) {
            return IValueChanged.DUMMY;
        }
        return vc;
    }

    @Override
    @Deprecated
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }

    @Override
    public boolean isModified() {
        return this.m_modifiedByUser;
    }

    @Override
    public void setModified(boolean as) {
        this.m_modifiedByUser = as;
    }

    public boolean isImmediate() {
        return this.m_immediate;
    }

    public void immediate(boolean immediate) {
        this.m_immediate = immediate;
    }

    public void immediate() {
        this.m_immediate = true;
    }
}

