/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import javax.annotation.Nonnull;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.html.DropMode;
import to.etc.domui.dom.html.INodeVisitor;
import to.etc.domui.dom.html.IReturnPressed;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.util.IDragHandler;
import to.etc.domui.util.IDraggable;
import to.etc.domui.util.IDropBody;
import to.etc.domui.util.IDropHandler;
import to.etc.domui.util.IDropTargetable;
import to.etc.domui.util.MiniTableBuilder;

public class Div
extends NodeContainer
implements IDropTargetable,
IDraggable,
IDropBody {
    private IReturnPressed<? extends NodeBase> m_returnPressed;
    private MiniTableBuilder m_miniTableBuilder;
    private IDropHandler m_dropHandler;
    private IDragHandler m_dragHandler;
    private DropMode m_dropMode;
    private IDropBody m_dropBody;

    public Div() {
        super("div");
    }

    public Div(String css) {
        this();
        this.setCssClass(css);
    }

    public Div(NodeBase ... children) {
        this();
        for (NodeBase b : children) {
            this.add(b);
        }
    }

    @Override
    public void visit(INodeVisitor v) throws Exception {
        v.visitDiv(this);
    }

    public IReturnPressed<? extends NodeBase> getReturnPressed() {
        return this.m_returnPressed;
    }

    public void setReturnPressed(IReturnPressed<? extends NodeBase> returnPressed) {
        this.m_returnPressed = returnPressed;
    }

    @Override
    protected void afterCreateContent() throws Exception {
        this.m_miniTableBuilder = null;
    }

    @Override
    public void componentHandleWebAction(@Nonnull RequestContextImpl ctx, @Nonnull String action) throws Exception {
        if (!"returnpressed".equals(action)) {
            super.componentHandleWebAction(ctx, action);
            return;
        }
        if (this.m_returnPressed != null) {
            this.m_returnPressed.returnPressed(this);
        }
    }

    public MiniTableBuilder tb() {
        if (this.m_miniTableBuilder == null) {
            this.m_miniTableBuilder = new MiniTableBuilder();
        }
        return this.m_miniTableBuilder;
    }

    @Override
    public void setDragHandler(IDragHandler dragHandler) {
        this.m_dragHandler = dragHandler;
    }

    @Override
    public IDragHandler getDragHandler() {
        return this.m_dragHandler;
    }

    @Override
    public IDropHandler getDropHandler() {
        return this.m_dropHandler;
    }

    @Override
    public void setDropHandler(IDropHandler dropHandler) {
        this.m_dropHandler = dropHandler;
        if (this.m_dropMode == null) {
            this.m_dropMode = DropMode.DIV;
        }
    }

    public void setDropBody(@Nonnull IDropBody body, DropMode dropMode) {
        switch (dropMode) {
            default: {
                throw new IllegalStateException("Unsupported DROP mode for TABLE or DIV container: " + (Object)((Object)dropMode));
            }
            case ROW: 
            case DIV: 
        }
        for (NodeBase b = (NodeBase)((Object)body); b != this; b = b.getParent()) {
            if (b.hasParent()) continue;
            throw new IllegalStateException("Programmer error: the TBody or DIV passed MUST be a child of the DIV node if you want to use the DIV as a DROP container for that TBody or DIV.");
        }
        this.m_dropMode = dropMode;
        this.m_dropBody = body;
        this.setSpecialAttribute("DROP_MODE", dropMode.name());
    }

    public IDropBody getDropBody() {
        return this.m_dropBody;
    }

    public DropMode getDropMode() {
        return this.m_dropMode;
    }

    public void slideUp() {
        if (this.internalSetDisplay(DisplayType.NONE)) {
            this.appendJavascript("$('#" + this.getActualID() + "').slideUp({complete: function() {" + Div.getCustomUpdatesCallJS() + "}});");
        }
    }

    public void slideDown() {
        if (this.internalSetDisplay(DisplayType.BLOCK)) {
            this.appendJavascript("$('#" + this.getActualID() + "').slideDown({complete: function() {" + Div.getCustomUpdatesCallJS() + "}});");
        }
    }

    public void fadeOut() {
        if (this.internalSetDisplay(DisplayType.NONE)) {
            this.appendJavascript("$('#" + this.getActualID() + "').fadeOut({complete: function() {" + Div.getCustomUpdatesCallJS() + "}});");
        }
    }

    public void fadeIn() {
        if (this.internalSetDisplay(DisplayType.BLOCK)) {
            this.appendJavascript("$('#" + this.getActualID() + "').fadeIn({complete: function() {" + Div.getCustomUpdatesCallJS() + "}});");
        }
    }

    protected static String getCustomUpdatesCallJS() {
        return "WebUI.doCustomUpdates();";
    }
}

