/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import java.io.StringWriter;
import java.io.Writer;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.NodeVisitorBase;
import to.etc.domui.dom.html.TextNode;
import to.etc.util.IndentWriter;

public class DumpDirtyStateRenderer
extends NodeVisitorBase {
    private IndentWriter m_iw;
    private StringWriter m_sw = new StringWriter(8192);
    private int m_depth;

    public DumpDirtyStateRenderer() {
        this.m_iw = new IndentWriter((Writer)this.m_sw);
    }

    public static void dump(NodeBase n) throws Exception {
        DumpDirtyStateRenderer r = new DumpDirtyStateRenderer();
        n.visit(r);
        System.out.println("---- Dirty node dump ----");
        r.m_iw.close();
        r.m_sw.close();
        System.out.println(r.m_sw.getBuffer().toString());
    }

    @Override
    public void visitNodeBase(NodeBase n) throws Exception {
        this.m_iw.print("[" + n.getTag() + ":" + n.getActualID() + " " + this.m_depth + "]");
        if (n.internalHasChangedAttributes()) {
            this.m_iw.print(" ChangedAttributes");
        }
        if (n.isBuilt()) {
            this.m_iw.print(" built");
        }
        if (n instanceof TextNode) {
            String txt = ((TextNode)n).getText();
            if (txt.length() > 20) {
                txt = txt.substring(0, 17) + "...";
            }
            this.m_iw.print(" \"" + txt + "\"");
        }
        this.m_iw.println();
    }

    @Override
    public void visitNodeContainer(NodeContainer n) throws Exception {
        this.m_iw.print("[" + n.getTag() + ":" + n.getActualID() + " " + this.m_depth + "]*");
        if (n.internalHasChangedAttributes()) {
            this.m_iw.print(" ChangedAttributes");
        }
        if (n.isBuilt()) {
            this.m_iw.print(" built");
        }
        if (n.childHasUpdates()) {
            this.m_iw.print(" childHasUpdates");
        }
        if (n.mustRenderChildrenFully()) {
            this.m_iw.print(" mustRenderChFully");
        }
        if (n.internalGetOldChildren() != null) {
            this.m_iw.print(" oldChildren");
        }
        this.m_iw.println();
        this.m_iw.inc();
        ++this.m_depth;
        this.visitChildren(n);
        --this.m_depth;
        this.m_iw.dec();
    }
}

