/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.html.ClickInfo;
import to.etc.domui.dom.html.IActionControl;
import to.etc.domui.dom.html.IClickBase;
import to.etc.domui.dom.html.INodeVisitor;
import to.etc.domui.dom.html.ImgAlign;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.util.DomUtil;

public class Img
extends NodeBase
implements IActionControl {
    private String m_alt;
    private String m_src;
    private ImgAlign m_align;
    private int m_imgBorder = -1;
    private String m_imgHeight;
    private String m_imgWidth;
    private boolean m_disabled;

    public Img() {
        super("img");
    }

    public Img(String src) {
        this();
        this.setSrc(src);
        this.setImgBorder(0);
    }

    public Img(Class<?> base, String src) {
        this();
        this.setSrc(base, src);
        this.setImgBorder(0);
    }

    @Override
    public void visit(INodeVisitor v) throws Exception {
        v.visitImg(this);
    }

    public String getAlt() {
        return this.m_alt;
    }

    public void setAlt(String alt) {
        if (!DomUtil.isEqual((Object)alt, (Object)this.m_alt)) {
            this.changed();
        }
        this.m_alt = alt;
    }

    public String getSrc() {
        return this.m_src;
    }

    public void setSrc(String src) {
        if (!DomUtil.isEqual((Object)src, (Object)this.m_src)) {
            this.changed();
        }
        this.m_src = src;
    }

    public void setSrc(Class<?> base, String resurl) {
        String s = DomUtil.getJavaResourceRURL(base, resurl);
        this.setSrc(s);
    }

    public ImgAlign getAlign() {
        return this.m_align;
    }

    public void setAlign(ImgAlign align) {
        if (this.m_align != align) {
            this.changed();
        }
        this.m_align = align;
    }

    public int getImgBorder() {
        return this.m_imgBorder;
    }

    public void setImgBorder(int imgBorder) {
        if (this.m_imgBorder != imgBorder) {
            this.changed();
        }
        this.m_imgBorder = imgBorder;
    }

    public String getImgHeight() {
        return this.m_imgHeight;
    }

    public void setImgHeight(String imgHeight) {
        if (DomUtil.isEqual((Object)this.m_imgHeight, (Object)imgHeight)) {
            return;
        }
        this.changed();
        this.m_imgHeight = imgHeight;
    }

    public String getImgWidth() {
        return this.m_imgWidth;
    }

    public void setImgWidth(String imgWidth) {
        if (DomUtil.isEqual((Object)this.m_imgWidth, (Object)imgWidth)) {
            return;
        }
        this.changed();
        this.m_imgWidth = imgWidth;
    }

    @Override
    public void setClicked(@Nullable IClickBase<?> clicked) {
        super.setClicked(clicked);
        if (null != clicked) {
            this.addCssClass("ui-clickable");
        } else {
            this.removeCssClass("ui-clickable");
        }
    }

    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.m_disabled == disabled) {
            return;
        }
        this.m_disabled = disabled;
        this.changed();
    }

    @Override
    public void internalOnClicked(@Nonnull ClickInfo cli) throws Exception {
        if (this.isDisabled()) {
            return;
        }
        super.internalOnClicked(cli);
    }
}

