/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.errors.INodeErrorDelegate;
import to.etc.domui.dom.html.IHasChangeListener;
import to.etc.domui.dom.html.IHtmlInput;
import to.etc.domui.dom.html.ILookupTypingListener;
import to.etc.domui.dom.html.INativeChangeListener;
import to.etc.domui.dom.html.INodeVisitor;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.server.IRequestContext;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.util.DomUtil;

public class Input
extends NodeBase
implements INativeChangeListener,
IHasChangeListener,
INodeErrorDelegate,
IHtmlInput {
    private boolean m_disabled;
    private int m_maxLength;
    private boolean m_readOnly;
    private int m_size;
    private String m_rawValue;
    private String m_onKeyPressJS;
    private IValueChanged<?> m_onValueChanged;
    private ILookupTypingListener<?> m_onLookupTyping;
    @Nullable
    private String m_disabledBecause;

    public Input() {
        super("input");
    }

    public String getInputType() {
        return "text";
    }

    @Override
    public void visit(INodeVisitor v) throws Exception {
        v.visitInput(this);
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        boolean isro;
        if (this.m_disabled == disabled) {
            return;
        }
        boolean wasro = this.m_disabled || this.m_readOnly;
        this.m_disabled = disabled;
        boolean bl = isro = this.m_disabled || this.m_readOnly;
        if (wasro != isro) {
            this.updateRoStyle();
        }
        if (!disabled) {
            this.setOverrideTitle(null);
        }
    }

    @Nullable
    public String getDisabledBecause() {
        return this.m_disabledBecause;
    }

    public void setDisabledBecause(@Nullable String msg) {
        if (Objects.equals(msg, this.m_disabledBecause)) {
            return;
        }
        this.m_disabledBecause = msg;
        this.setOverrideTitle(msg);
        this.setDisabled(msg != null);
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        boolean isro;
        if (this.m_readOnly == readOnly) {
            return;
        }
        boolean wasro = this.m_disabled || this.m_readOnly;
        this.m_readOnly = readOnly;
        boolean bl = isro = this.m_disabled || this.m_readOnly;
        if (wasro != isro) {
            this.updateRoStyle();
        }
    }

    private void updateRoStyle() {
        if (this.m_disabled || this.m_readOnly) {
            this.addCssClass("ui-ro");
        } else {
            this.removeCssClass("ui-ro");
        }
    }

    public int getMaxLength() {
        return this.m_maxLength;
    }

    public void setMaxLength(int maxLength) {
        if (this.m_maxLength != maxLength) {
            this.changed();
        }
        this.m_maxLength = maxLength;
    }

    public int getSize() {
        return this.m_size;
    }

    public void setSize(int size) {
        if (this.m_size != size) {
            this.changed();
        }
        this.m_size = size;
    }

    public String getRawValue() {
        return this.m_rawValue;
    }

    public void setRawValue(String value) {
        if (DomUtil.isEqual((Object)value, (Object)this.m_rawValue)) {
            return;
        }
        this.changed();
        this.m_rawValue = value;
    }

    public String getOnKeyPressJS() {
        return this.m_onKeyPressJS;
    }

    protected void setOnKeyPressJS(String onKeyPressJS) {
        if (!DomUtil.isEqual((Object)onKeyPressJS, (Object)this.m_onKeyPressJS)) {
            this.changed();
        }
        this.m_onKeyPressJS = onKeyPressJS;
    }

    @Override
    public boolean acceptRequestParameter(@Nonnull String[] values) {
        String prev = this.m_rawValue;
        this.m_rawValue = values == null || values.length != 1 ? null : values[0];
        if (!(prev != null && prev.length() != 0 || this.m_rawValue != null && this.m_rawValue.length() != 0)) {
            return false;
        }
        return !DomUtil.isEqual((Object)prev, (Object)this.m_rawValue);
    }

    @Override
    public void componentHandleWebAction(@Nonnull RequestContextImpl ctx, @Nonnull String action) throws Exception {
        if ("lookupTyping".equals(action)) {
            this.handleLookupTyping(ctx);
        } else if ("lookupTypingDone".equals(action)) {
            this.handleLookupTypingDone(ctx);
        }
    }

    private void handleLookupTyping(IRequestContext ctx) throws Exception {
        ILookupTypingListener<?> tl = this.getOnLookupTyping();
        if (tl != null) {
            tl.onLookupTyping(this, false);
        }
    }

    private void handleLookupTypingDone(IRequestContext ctx) throws Exception {
        ILookupTypingListener<?> tl = this.getOnLookupTyping();
        if (tl != null) {
            tl.onLookupTyping(this, true);
        }
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        return this.m_onValueChanged;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }

    public ILookupTypingListener<?> getOnLookupTyping() {
        return this.m_onLookupTyping;
    }

    public void setOnLookupTyping(ILookupTypingListener<?> onLookupTyping) {
        this.m_onLookupTyping = onLookupTyping;
    }
}

