/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.component.binding.ComponentPropertyBinding;
import to.etc.domui.component.binding.IBinding;
import to.etc.domui.component.binding.OldBindingHandler;
import to.etc.domui.component.event.INotify;
import to.etc.domui.component.image.Dimension;
import to.etc.domui.component.layout.Rect;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.css.CssBase;
import to.etc.domui.dom.css.PositionType;
import to.etc.domui.dom.errors.IErrorFence;
import to.etc.domui.dom.errors.INodeErrorDelegate;
import to.etc.domui.dom.errors.MsgType;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.ClickInfo;
import to.etc.domui.dom.html.DropMode;
import to.etc.domui.dom.html.IClickBase;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IClicked2;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IHasChangeListener;
import to.etc.domui.dom.html.INodeVisitor;
import to.etc.domui.dom.html.INotificationListener;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.webaction.IWebActionHandler;
import to.etc.domui.logic.ILogicContext;
import to.etc.domui.parts.IComponentJsonProvider;
import to.etc.domui.parts.IComponentUrlDataProvider;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.IPageParameters;
import to.etc.domui.themes.IThemeVariant;
import to.etc.domui.trouble.UIException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.DropEvent;
import to.etc.domui.util.IDragArea;
import to.etc.domui.util.IDragHandler;
import to.etc.domui.util.IDraggable;
import to.etc.domui.util.IDropHandler;
import to.etc.domui.util.IDropTargetable;
import to.etc.domui.util.javascript.JavascriptStmt;
import to.etc.webapp.nls.BundleStack;
import to.etc.webapp.nls.IBundle;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QDataContextFactory;

public abstract class NodeBase
extends CssBase
implements INodeErrorDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(NodeBase.class);
    private static boolean m_logAllocations;
    private static int m_nextID;
    @Nullable
    private Page m_page;
    @Nonnull
    private String m_tag;
    @Nullable
    private String m_cssClass;
    @Nullable
    private String m_actualID;
    private String m_testID;
    @Nullable
    private NodeContainer m_parent;
    @Nullable
    private IClickBase<?> m_clicked;
    private boolean m_built;
    private boolean m_attributesChanged;
    @Nullable
    private NodeContainer m_oldParent;
    int m_oldNodeIndex;
    int m_newNodeIndex;
    int m_origNewIndex;
    @Nullable
    private Object m_userObject;
    @Nullable
    private String m_title;
    @Nullable
    private String m_onClickJS;
    @Nullable
    private String m_onMouseDownJS;
    @Nullable
    private StringBuilder m_appendJS;
    @Nullable
    private StringBuilder m_createJS;
    @Nullable
    private List<String> m_specialAttributes;
    private static final byte F_FOCUSREQUESTED = 1;
    private static final byte F_BUNDLEFOUND = 2;
    private static final byte F_BUNDLEUSED = 4;
    private byte m_flags;
    private StackTraceElement[] m_allocationTracepoint;
    private boolean m_stretchHeight;
    private String m_calculatedTestIdBase;
    private String m_testFullRepeatID;
    private String m_testRepeatId;
    @Nullable
    private List<IBinding> m_bindingList;
    @Nullable
    private String m_overrideTitle;
    @Nullable
    private INotify<NodeBase> m_onSizeAndPositionChange;
    @Nullable
    private Rect m_clientBounds;
    @Nullable
    private Dimension m_browserWindowSize;
    @Nullable
    private JavascriptStmt m_createStmt;
    @Nullable
    private UIMessage m_message;
    @Nullable
    private String m_errorLocation;
    private IBundle m_componentBundle;
    @Nullable
    private List<Page.NotificationListener<?>> m_notificationListenerList;

    public abstract void visit(INodeVisitor var1) throws Exception;

    protected NodeBase(@Nonnull String tag) {
        this.m_tag = tag;
        if (m_logAllocations) {
            this.m_allocationTracepoint = DomUtil.getTracepoint();
        }
    }

    public static void internalSetLogAllocations(boolean la) {
        m_logAllocations = la;
    }

    public StackTraceElement[] getAllocationTracepoint() {
        return this.m_allocationTracepoint;
    }

    public final boolean internalHasChangedAttributes() {
        return this.m_attributesChanged;
    }

    public final void internalSetHasChangedAttributes(boolean d) {
        this.m_attributesChanged = d;
    }

    public final void internalSetHasChangedAttributes() {
        this.internalSetHasChangedAttributes(true);
    }

    void internalCheckNotDirty() {
        if (this.internalHasChangedAttributes()) {
            throw new IllegalStateException("The node " + this + " has DIRTY ATTRIBUTES set");
        }
    }

    public void internalOnClicked(@Nonnull ClickInfo cli) throws Exception {
        IClickBase<?> c = this.getClicked();
        if (c instanceof IClicked) {
            ((IClicked)c).clicked(this);
        } else if (c instanceof IClicked2) {
            ((IClicked2)c).clicked(this, cli);
        } else {
            throw new IllegalStateException("? Node " + this.getActualID() + " does not have a (valid) click handler??");
        }
    }

    @Override
    protected final void changed() {
        this.setCachedStyle(null);
        this.internalSetHasChangedAttributes();
        NodeContainer p = this.m_parent;
        if (p != null) {
            p.childChanged();
        }
        super.changed();
    }

    final void internalSetOldParent(NodeContainer c) {
        this.m_oldParent = c;
    }

    public final NodeContainer internalGetOldParent() {
        return this.m_oldParent;
    }

    public void internalClearDelta() {
        this.m_oldParent = null;
        this.internalSetHasChangedAttributes(false);
    }

    public void internalClearDeltaFully() {
        this.internalClearDelta();
    }

    protected int internalGetNodeCount(int depth) {
        return 1;
    }

    @Nonnull
    final String nextUniqID() {
        StringBuilder sb = new StringBuilder();
        sb.append("__");
        for (int id = this.nextIdNumber(); id != 0; id /= 36) {
            int d = id % 36;
            d = d <= 9 ? (d += 48) : 65 + (d - 10);
            sb.append((char)d);
        }
        return sb.toString();
    }

    private synchronized int nextIdNumber() {
        return m_nextID++;
    }

    @Nonnull
    public final String getActualID() {
        String id = this.m_actualID;
        if (null == id) {
            id = this.m_actualID = this.nextUniqID();
        }
        return id;
    }

    @Nullable
    final String internalGetID() {
        return this.m_actualID;
    }

    final void setActualID(@Nonnull String actualID) {
        this.m_actualID = actualID;
    }

    @Nonnull
    public final String getTag() {
        return this.m_tag;
    }

    protected final void internalSetTag(@Nonnull String tag) {
        this.m_tag = tag;
    }

    @Nonnull
    public final Page getPage() {
        if (null != this.m_page) {
            return this.m_page;
        }
        throw new IllegalStateException(this.getTag() + " with title " + this.getTitle() + " and id " + this.getActualID() + " not attached to a page yet. Use isAttached() to check if a node is attached or not.");
    }

    public final boolean isAttached() {
        return null != this.m_page;
    }

    final void setPage(Page page) {
        this.m_page = page;
    }

    void unregisterFromPage() {
        if (!this.isAttached()) {
            return;
        }
        this.clearMessage();
        this.getPage().unregisterNode(this);
    }

    void registerWithPage(@Nonnull Page p) {
        p.registerNode(this);
    }

    void internalOnAddedToPage(Page p) {
        StringBuilder appendJS;
        this.onAddedToPage(p);
        List<Page.NotificationListener<?>> list = this.m_notificationListenerList;
        if (null != list) {
            list.forEach(a -> p.addNotificationListener(a));
        }
        if ((appendJS = this.m_appendJS) != null) {
            this.getPage().appendJS(appendJS);
            this.m_appendJS = null;
        }
    }

    void internalOnRemoveFromPage(Page p) {
        this.onRemoveFromPage(p);
    }

    @Nullable
    public final String getCssClass() {
        return this.m_cssClass;
    }

    public void setCssClass(@Nullable String cssClass) {
        if (!DomUtil.isEqual((Object)cssClass, (Object)this.m_cssClass)) {
            this.changed();
        }
        this.m_cssClass = cssClass;
    }

    public final boolean removeCssClass(@Nonnull String name) {
        String cssClass = this.getCssClass();
        if (cssClass == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(cssClass, " \t");
        StringBuilder sb = new StringBuilder(cssClass.length());
        boolean fnd = false;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (name.equals(s)) {
                fnd = true;
                continue;
            }
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(s);
        }
        if (!fnd) {
            return false;
        }
        this.setCssClass(sb.toString());
        return true;
    }

    public final void addCssClass(@Nonnull String name) {
        if (this.getCssClass() == null) {
            this.setCssClass(name);
            return;
        }
        StringTokenizer st = new StringTokenizer(this.getCssClass(), " \t");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (!name.equals(s)) continue;
            return;
        }
        this.setCssClass(this.getCssClass() + " " + name);
    }

    public final boolean hasCssClass(@Nonnull String cls) {
        String cssClass = this.getCssClass();
        if (cssClass == null) {
            return false;
        }
        int pos = cssClass.indexOf(cls);
        if (pos == -1) {
            return false;
        }
        return pos == 0 || cssClass.charAt(pos - 1) == ' ';
    }

    final void setParent(NodeContainer parent) {
        if (this.m_oldParent == null) {
            this.m_oldParent = this.m_parent;
        }
        this.m_parent = parent;
    }

    @Nonnull
    public final NodeContainer getParent() {
        if (null != this.m_parent) {
            return this.m_parent;
        }
        if (this.m_page != null && this.m_page.getBody() == this) {
            throw new IllegalStateException("Calling getParent() on the body tag is an indication of a problem...");
        }
        throw new IllegalStateException("The node is not attached to a page, call isAttached() to test for attachment");
    }

    @Nullable
    public NodeContainer internalGetParent() {
        return this.m_parent;
    }

    public final boolean hasParent() {
        return this.m_parent != null;
    }

    @Nullable
    public final NodeContainer getParent(int up) {
        NodeContainer c = this.m_parent;
        while (--up > 0) {
            if (c == null) {
                return null;
            }
            c = c.m_parent;
        }
        return c;
    }

    @Nullable
    public final <T> T findParent(Class<T> clz) {
        if (!this.hasParent()) {
            return null;
        }
        NodeBase c = this;
        do {
            if (c.hasParent()) continue;
            return null;
        } while (!clz.isAssignableFrom((c = c.getParent()).getClass()));
        return (T)c;
    }

    @Nonnull
    public final <T> T getParent(Class<T> clz) {
        T res = this.findParent(clz);
        if (null == res) {
            throw new IllegalStateException("This node " + this + " does not have a parent of type=" + clz);
        }
        return res;
    }

    @Nullable
    public final NodeBase getParentOfTypes(Class<? extends NodeBase> ... clzar) {
        NodeBase c = this;
        block0: while (c.hasParent()) {
            c = c.getParent();
            Class<? extends NodeBase>[] classArray = clzar;
            int n = classArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                Class<? extends NodeBase> clz = classArray[n2];
                if (clz.isAssignableFrom(c.getClass())) {
                    return c;
                }
                ++n2;
            }
            break;
        }
        return null;
    }

    public final void remove() {
        if (this.m_parent != null) {
            this.m_parent.removeChild(this);
        }
    }

    public final void replaceWith(NodeBase nw) {
        this.getParent().replaceChild(this, nw);
    }

    public final void appendAfterMe(@Nonnull NodeBase item) {
        int ix = this.getParent().findChildIndex(this);
        if (ix == -1) {
            throw new IllegalStateException("!@?! Cannot find myself!?");
        }
        this.getParent().undelegatedAdd(ix + 1, item);
    }

    public final void appendBeforeMe(@Nonnull NodeBase item) {
        int ix = this.getParent().findChildIndex(this);
        if (ix == -1) {
            throw new IllegalStateException("!@?! Cannot find myself!?");
        }
        this.getParent().undelegatedAdd(ix, item);
    }

    public final void build() throws Exception {
        if (!this.m_built) {
            this.m_built = true;
            boolean ok = false;
            try {
                this.internalCreateContent();
                ok = true;
            }
            finally {
                this.m_built = ok;
            }
            if (!ok) {
                this.forceRebuild();
            }
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void forceRebuild() {
        this.onForceRebuild();
        this.clearBuilt();
    }

    private final void clearBuilt() {
        this.m_built = false;
        if (this.m_page != null) {
            this.m_page.internalAddPendingBuild(this);
        }
    }

    public boolean isBuilt() {
        return this.m_built;
    }

    private final void internalCreateContent() throws Exception {
        this.beforeCreateContent();
        this.internalCreateFrame();
        this.createContent();
        this.afterCreateContent();
    }

    protected void internalCreateFrame() throws Exception {
    }

    public void setTitle(@Nullable String title) {
        if (!DomUtil.isEqual((Object)title, (Object)this.m_title)) {
            this.changed();
        }
        this.m_title = title;
    }

    @Nullable
    public String getTitle() {
        return this.m_overrideTitle == null ? this.m_title : this.m_overrideTitle;
    }

    public void setOverrideTitle(@Nullable String overrideTitle) {
        if (Objects.equals(overrideTitle, this.m_overrideTitle)) {
            return;
        }
        this.m_overrideTitle = overrideTitle;
        this.changed();
    }

    @Nullable
    public IClickBase<?> getClicked() {
        return this.m_clicked;
    }

    public void setClicked(@Nullable IClickBase<?> clicked) {
        this.m_clicked = clicked;
    }

    public boolean internalNeedClickHandler() {
        return this.getClicked() != null;
    }

    @Nullable
    public Object getUserObject() {
        return this.m_userObject;
    }

    public void setUserObject(@Nullable Object userObject) {
        this.m_userObject = userObject;
    }

    public String getTestID() {
        return this.m_testID;
    }

    public void setTestID(String testID) {
        if (DomUtil.isEqual((Object)testID, (Object)this.m_testID)) {
            return;
        }
        this.m_testID = testID;
        this.changed();
    }

    public void setCalculcatedId(@Nonnull String calcid) {
        this.m_calculatedTestIdBase = DomUtil.convertToID(calcid);
    }

    public void setCalculcatedId(@Nonnull String calcid, @Nullable String parentId) {
        try {
            String base = this.getTestRepeatId();
            Page page = this.m_page;
            if (parentId != null && page != null) {
                String nid = base + "/" + calcid;
                if (page.isTestIDAllocated(nid)) {
                    this.setCalculcatedId(parentId + "_" + calcid);
                } else {
                    this.setCalculcatedId(calcid);
                }
            } else {
                this.setCalculcatedId(calcid);
            }
        }
        catch (Exception ex) {
            LOG.error("Error in setCalculcatedId", (Throwable)ex);
            this.setCalculcatedId("ERROR_IN_setCalculcatedId_" + calcid);
        }
    }

    @Nullable
    protected String getCalculatedTestID() {
        return this.m_calculatedTestIdBase;
    }

    @Nullable
    public String calcTestID() {
        Page page = this.m_page;
        if (null == page) {
            return null;
        }
        String baseName = this.getTestID();
        if (null != baseName) {
            return baseName;
        }
        baseName = this.getCalculatedTestID();
        if (null == baseName) {
            return null;
        }
        String repeatId = this.getTestRepeatId();
        this.m_testID = page.allocateTestID(repeatId + baseName);
        return this.m_testID;
    }

    @Nonnull
    public String getTestRepeatId() {
        if (this.m_testFullRepeatID == null) {
            NodeContainer parent = this.m_parent;
            if (parent == null) {
                throw new IllegalStateException("?? " + this.getClass().getName() + " null parent");
            }
            String ptrid = parent.getTestRepeatId();
            this.m_testFullRepeatID = this.m_testRepeatId == null ? ptrid : ptrid + "/" + this.m_testRepeatId + "/";
        }
        return this.m_testFullRepeatID;
    }

    public void setTestRepeatID(@Nonnull String trid) {
        this.m_testRepeatId = trid;
    }

    public String getOnClickJS() {
        return this.m_onClickJS;
    }

    public void setOnClickJS(String onClickJS) {
        if (DomUtil.isEqual((Object)onClickJS, (Object)this.m_onClickJS)) {
            this.changed();
        }
        this.m_onClickJS = onClickJS;
    }

    public String getOnMouseDownJS() {
        return this.m_onMouseDownJS;
    }

    public void setOnMouseDownJS(String onMouseDownJS) {
        this.m_onMouseDownJS = onMouseDownJS;
    }

    public void appendJavascript(@Nonnull CharSequence js) {
        StringBuilder sb = this.getAppendJavascriptBuffer();
        sb.append(';');
        sb.append(js);
    }

    @Nonnull
    public JavascriptStmt appendStatement() {
        return new JavascriptStmt(this.getAppendJavascriptBuffer());
    }

    @Nonnull
    private StringBuilder getAppendJavascriptBuffer() {
        if (this.isAttached()) {
            return this.getPage().internalGetAppendJS();
        }
        StringBuilder sb = this.m_appendJS;
        if (sb == null) {
            sb = this.m_appendJS = new StringBuilder(128);
        }
        return sb;
    }

    public void appendJsCustomUpdatesContributor(@Nonnull String jsCallback) {
        this.appendJavascript("WebUI.registerCustomUpdatesContributor(function(){" + jsCallback + "});");
    }

    public void appendShowOverflowTextAsTitleJs(@Nonnull String cssSelector) {
        this.appendJsCustomUpdatesContributor("WebUI.showOverflowTextAsTitle('" + this.getActualID() + "', '" + cssSelector + "')");
    }

    public void appendCreateJS(@Nonnull CharSequence js) {
        int len = js.length();
        if (len == 0) {
            return;
        }
        StringBuilder sb = this.getCreateJavascriptBuffer();
        sb.append(js);
        if (js.charAt(len - 1) != ';') {
            sb.append(';');
        }
    }

    @Nonnull
    private StringBuilder getCreateJavascriptBuffer() {
        StringBuilder sb = this.m_createJS;
        if (sb == null) {
            sb = this.m_createJS = new StringBuilder();
        } else {
            JavascriptStmt st = this.m_createStmt;
            if (null != st) {
                st.next();
            }
        }
        return sb;
    }

    @Nonnull
    public JavascriptStmt createStatement() {
        JavascriptStmt st = this.m_createStmt;
        if (null == st) {
            st = this.m_createStmt = new JavascriptStmt(this.getCreateJavascriptBuffer());
        }
        return st;
    }

    @Nullable
    public StringBuilder getCreateJS() {
        JavascriptStmt st = this.m_createStmt;
        if (null != st) {
            st.next();
        }
        return this.m_createJS;
    }

    protected void renderJavascriptState(@Nonnull JavascriptStmt b) throws Exception {
    }

    public final void internalRenderJavascriptState(@Nonnull JavascriptStmt stmt) throws Exception {
        this.renderJavascriptState(stmt);
        stmt.next();
    }

    public final void changedJavascriptState() {
        Page page = this.m_page;
        if (null != page) {
            page.registerJavascriptStateChanged(this);
        }
    }

    protected void renderJavascriptDelta(@Nonnull JavascriptStmt b) throws Exception {
    }

    public final void internalRenderJavascriptDelta(@Nonnull JavascriptStmt stmt) throws Exception {
        this.renderJavascriptDelta(stmt);
        stmt.next();
    }

    public void setSpecialAttribute(@Nonnull String name, @Nullable String value) {
        List<String> sa = this.m_specialAttributes;
        if (sa == null) {
            sa = this.m_specialAttributes = new ArrayList<String>(5);
        } else {
            for (int i = 0; i < sa.size(); i += 2) {
                if (!sa.get(i).equals(name)) continue;
                if (value == null) {
                    sa.remove(i);
                    sa.remove(i);
                    return;
                }
                sa.set(i + 1, value);
                this.changed();
                return;
            }
        }
        sa.add(name);
        sa.add(value);
        this.changed();
    }

    @Nullable
    public List<String> getSpecialAttributeList() {
        return this.m_specialAttributes;
    }

    @Nullable
    public String getSpecialAttribute(@Nonnull String name) {
        List<String> attributes = this.m_specialAttributes;
        if (attributes != null) {
            for (int i = 0; i < attributes.size(); i += 2) {
                if (!attributes.get(i).equals(name)) continue;
                return attributes.get(i + 1);
            }
        }
        return null;
    }

    @Nonnull
    public String getComponentDataURL(@Nonnull String action, @Nullable IPageParameters pp) {
        NodeBase nb = this;
        return DomUtil.getAdjustedComponentUrl(this, "#" + action, pp);
    }

    public void componentHandleWebAction(@Nonnull RequestContextImpl ctx, @Nonnull String action) throws Exception {
        if ("WEBUIDROP".equals(action)) {
            this.handleDrop(ctx);
            return;
        }
        if ("notifyClientPositionAndSize".equals(action)) {
            this.handleClientPositionAndSizeChange(ctx);
            return;
        }
        if (action.endsWith("?")) {
            action = action.substring(0, action.length() - 1);
        }
        action = "webAction" + action;
        IWebActionHandler handler = ctx.getApplication().getWebActionRegistry().findActionHandler(this.getClass(), action);
        if (null != handler) {
            handler.handleWebAction(this, ctx, false);
            return;
        }
        throw new IllegalStateException("The component " + this + " does not accept the web action " + action);
    }

    public void componentHandleWebDataRequest(@Nonnull RequestContextImpl ctx, @Nonnull String action) throws Exception {
        action = "webData" + action;
        IWebActionHandler handler = ctx.getApplication().getWebActionRegistry().findActionHandler(this.getClass(), action);
        if (null != handler) {
            handler.handleWebAction(this, ctx, true);
            return;
        }
        throw new IllegalStateException("The component " + this + " does not accept the web data request #" + action);
    }

    public boolean acceptRequestParameter(@Nonnull String[] values) throws Exception {
        throw new IllegalStateException("?? The '" + this.getTag() + "' component (" + this.getClass() + ") with id=" + this.m_actualID + " does NOT accept input!");
    }

    @Nonnull
    public String getComponentDataURL(@Nullable IPageParameters pp) {
        NodeBase nb = this;
        if (!(nb instanceof IComponentUrlDataProvider)) {
            throw new IllegalStateException("This component (" + this + ") does not implement " + IComponentUrlDataProvider.class.getName());
        }
        return DomUtil.getAdjustedComponentUrl(this, "$pagedata", pp);
    }

    @Nonnull
    public String getComponentJSONURL(@Nullable IPageParameters pp) {
        NodeBase nb = this;
        if (!(nb instanceof IComponentJsonProvider)) {
            throw new IllegalStateException("This component (" + this + ") does not implement " + IComponentJsonProvider.class.getName());
        }
        return DomUtil.getAdjustedComponentUrl(this, "$pagejson", pp);
    }

    public void setErrorLocation(@Nullable String errorLocation) {
        this.m_errorLocation = errorLocation;
    }

    @Nullable
    public String getErrorLocation() {
        return this.m_errorLocation;
    }

    public String getComponentInfo() {
        String txt;
        ComponentPropertyBinding binding;
        StringBuilder sb = new StringBuilder();
        String s = this.getClass().getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        sb.append(s);
        String el = this.getErrorLocation();
        if (null != el) {
            sb.append(":").append(el);
        }
        if ((binding = OldBindingHandler.findBinding(this, "value")) != null) {
            sb.append(" ").append(binding);
        } else {
            binding = OldBindingHandler.findBinding(this, "bindValue");
            if (binding != null) {
                sb.append(" ").append(binding);
            }
        }
        if (this instanceof NodeContainer && (txt = DomUtil.calcNodeText((NodeContainer)this)).length() > 0) {
            sb.append("/").append(txt);
        }
        return sb.toString();
    }

    @Override
    @Nullable
    public UIMessage setMessage(@Nullable UIMessage msg) {
        UIMessage old = this.m_message;
        if (old == msg) {
            return old;
        }
        if (msg != null) {
            if (old != null) {
                if (old.getType().getOrder() > msg.getType().getOrder()) {
                    return this.m_message;
                }
                if (old.equals(msg)) {
                    return old;
                }
            }
            if (msg.getErrorLocation() == null) {
                msg.setErrorLocation(this.m_errorLocation);
            }
            msg.setErrorNode(this);
        }
        this.m_message = msg;
        if (this.m_page != null) {
            IErrorFence fence = DomUtil.getMessageFence(this);
            if (null != old) {
                fence.removeMessage(old);
            }
            if (null != msg) {
                fence.addMessage(msg);
            }
        }
        return msg;
    }

    @Override
    @Deprecated
    public void clearMessage() {
        this.setMessage(null);
    }

    @Override
    @Nullable
    public UIMessage getMessage() {
        return this.m_message;
    }

    public boolean hasError() {
        UIMessage message = this.getMessage();
        return message != null && message.getType() == MsgType.ERROR;
    }

    public void appendTreeErrors(@Nonnull List<UIMessage> errorList) {
        UIMessage message = this.getMessage();
        if (null != message && message.getType() == MsgType.ERROR) {
            errorList.add(message);
        }
    }

    @Nonnull
    public List<UIMessage> getErrorList() {
        ArrayList<UIMessage> res = new ArrayList<UIMessage>();
        this.appendTreeErrors(res);
        return res;
    }

    public UIMessage addGlobalMessage(UIMessage m) {
        IErrorFence fence = DomUtil.getMessageFence(this);
        fence.addMessage(m);
        return m;
    }

    public void clearGlobalMessage() {
        IErrorFence fence = DomUtil.getMessageFence(this);
        fence.clearGlobalMessages(null);
    }

    public void clearGlobalMessage(UIMessage m) {
        IErrorFence fence = DomUtil.getMessageFence(this);
        fence.removeMessage(m);
    }

    public void clearGlobalMessage(String code) {
        IErrorFence fence = DomUtil.getMessageFence(this);
        fence.clearGlobalMessages(code);
    }

    public final void setComponentBundle(@Nullable IBundle bundle) {
        if (0 != (this.m_flags & 4)) {
            throw new IllegalStateException("The component bundle can only be set BEFORE it is used.");
        }
        this.m_componentBundle = bundle;
        this.m_flags = (byte)(this.m_flags | 2);
    }

    @Nullable
    public final IBundle findComponentBundle() {
        if ((this.m_flags & 2) == 0) {
            this.m_componentBundle = BundleStack.createStack(this.getClass());
            this.m_flags = (byte)(this.m_flags | 2);
        }
        this.m_flags = (byte)(this.m_flags | 4);
        return this.m_componentBundle;
    }

    @Nonnull
    public final IBundle getComponentBundle() {
        IBundle b = this.findComponentBundle();
        if (null == b) {
            throw new IllegalStateException("The component " + this.getClass() + " does not have any message bundle.");
        }
        return b;
    }

    @Nonnull
    public String $(@Nonnull String key, Object ... param) {
        IBundle br = this.getComponentBundle();
        if (key.startsWith("~")) {
            key = key.substring(1);
        }
        return br.formatMessage(key, param);
    }

    protected void internalShelve() throws Exception {
        this.onShelve();
    }

    protected void internalUnshelve() throws Exception {
        this.onUnshelve();
    }

    public void internalOnValueChanged() throws Exception {
        IHasChangeListener chb;
        IValueChanged<?> vc;
        if (this instanceof IHasChangeListener && (vc = (chb = (IHasChangeListener)((Object)this)).getOnValueChanged()) != null) {
            vc.onValueChanged(this);
        }
    }

    protected void onForceRebuild() {
    }

    protected void onShelve() throws Exception {
    }

    protected void onUnshelve() throws Exception {
    }

    protected void onRefresh() throws Exception {
    }

    public void renderJavascriptState(StringBuilder sb) throws Exception {
    }

    public void onBeforeFullRender() throws Exception {
    }

    public void onBeforeRender() throws Exception {
    }

    @OverridingMethodsMustInvokeSuper
    protected void beforeCreateContent() {
    }

    public void createContent() throws Exception {
    }

    protected void afterCreateContent() throws Exception {
    }

    @OverridingMethodsMustInvokeSuper
    public void onAddedToPage(Page p) {
    }

    @OverridingMethodsMustInvokeSuper
    public void onRemoveFromPage(Page p) {
    }

    public void onHeaderContributors(Page page) {
    }

    public void internalOnBeforeRender() throws Exception {
        this.onBeforeRender();
    }

    protected void handleDrop(RequestContextImpl ctx) throws Exception {
        IDragHandler dragh;
        if (!(this instanceof IDropTargetable)) {
            throw new IllegalStateException("?? Got a DROP action but I am not able to receive droppings?? " + this);
        }
        IDropHandler droph = ((IDropTargetable)((Object)this)).getDropHandler();
        String dragid = ctx.getParameter("_dragid");
        if (dragid == null) {
            throw new IllegalStateException("No _dragid in drop request to node=" + this);
        }
        NodeBase dragnode = this.getPage().findNodeByID(dragid);
        if (dragnode == null) {
            throw new IllegalStateException("Unknown dragged node " + dragid + " in drop request to node=" + this);
        }
        if (dragnode instanceof IDragArea) {
            dragh = ((IDragArea)((Object)dragnode)).getDragHandle().getDragHandler();
        } else {
            if (!(dragnode instanceof IDraggable)) {
                throw new IllegalStateException("The supposedly dragged node " + dragnode + " does not implement IDraggable!?");
            }
            dragh = ((IDraggable)((Object)dragnode)).getDragHandler();
        }
        int index = 0;
        String s = ctx.getParameter("_index");
        if (s != null) {
            try {
                index = Integer.parseInt(s.trim());
            }
            catch (Exception x) {
                throw new IllegalStateException("Bad _index parameter in DROP request: " + s);
            }
        }
        int colIndex = 0;
        s = ctx.getParameter("_colIndex");
        if (s != null) {
            try {
                colIndex = Integer.parseInt(s.trim());
            }
            catch (Exception x) {
                throw new IllegalStateException("Bad _colIndex parameter in DROP request: " + s);
            }
        }
        String nextSiblingId = ctx.getParameter("_siblingId");
        String dropContainerId = ctx.getParameter("_dropContainerId");
        String mode = ctx.getParameter("_mode");
        DropEvent dx = null;
        if (DropMode.DIV.name().equals(mode)) {
            if (dropContainerId == null) {
                throw new IllegalStateException("Missing drop container is (_dropContainerId) in DIV drop request to node=" + this);
            }
            NodeBase dropContainer = this.getPage().findNodeByID(dropContainerId);
            if (dropContainer == null) {
                throw new IllegalStateException("Unknown drop container node " + dropContainerId + " in drop request to node=" + this);
            }
            dx = new DropEvent((NodeContainer)dropContainer, dragnode, nextSiblingId);
        } else {
            dx = new DropEvent((NodeContainer)this, dragnode, index, colIndex);
        }
        dragh.onDropped(dx);
        droph.onDropped(dx);
    }

    @Nonnull
    public QDataContext getSharedContext() throws Exception {
        return this.getParent().getSharedContext();
    }

    @Nonnull
    public QDataContextFactory getSharedContextFactory() {
        return this.getParent().getSharedContextFactory();
    }

    @Nonnull
    public ILogicContext lc() throws Exception {
        return this.getPage().getBody().lc();
    }

    public void setFocus() {
        if (!this.isAttached()) {
            this.m_flags = (byte)(this.m_flags | 1);
        } else {
            this.getPage().setFocusComponent(this);
        }
    }

    public final boolean isFocusRequested() {
        return (this.m_flags & 1) != 0;
    }

    public final void clearFocusRequested() {
        this.m_flags = (byte)(this.m_flags & 1);
    }

    public final void refresh() throws Exception {
        this.onRefresh();
    }

    public boolean isFocusable() {
        NodeBase n = this;
        if (n instanceof IHasChangeListener) {
            if (n instanceof IControl) {
                IControl in = (IControl)((Object)n);
                if (!in.isDisabled() && !in.isReadOnly()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected String getFocusID() {
        return this.getActualID();
    }

    public final void appendJQuerySelector(@Nonnull StringBuilder sb) {
        sb.append("$(\"#").append(this.getActualID()).append("\")");
    }

    public boolean isStretchHeight() {
        return this.m_stretchHeight;
    }

    public void setStretchHeight(boolean value) {
        if (this.m_stretchHeight == value) {
            return;
        }
        this.m_stretchHeight = value;
        this.changed();
    }

    public String toString() {
        String n = this.getClass().getName();
        int pos = n.lastIndexOf(46);
        return n.substring(pos + 1) + ":" + this.m_actualID + (this.m_title == null ? "" : "/" + this.m_title);
    }

    public boolean isRendersOwnClose() {
        return false;
    }

    @Nonnull
    public final String getThemedResourceRURL(@Nonnull String path) {
        IThemeVariant themeStyle = this.getPage().getBody().getThemeVariant();
        return DomApplication.get().internalGetThemeManager().getThemedResourceRURL(themeStyle, path);
    }

    public final <T> void notify(T eventClass) throws Exception {
        this.getPage().notifyPage(eventClass);
    }

    public final <T> void addNotificationListener(Class<T> eventClass, INotificationListener<T> listener) {
        Page.NotificationListener<T> nl = new Page.NotificationListener<T>(eventClass, this, listener);
        if (this.isAttached()) {
            this.getPage().addNotificationListener(nl);
        } else {
            List<Page.NotificationListener<?>> list = this.m_notificationListenerList;
            if (null == list) {
                this.m_notificationListenerList = new ArrayList(4);
                list = this.m_notificationListenerList;
            }
            list.add(nl);
        }
    }

    @Nonnull
    public List<UIMessage> getBindingErrors() throws Exception {
        return OldBindingHandler.getBindingErrors(this);
    }

    public boolean bindErrors() throws Exception {
        return OldBindingHandler.reportBindingErrors(this);
    }

    @Nullable
    public final List<IBinding> getBindingList() {
        return this.m_bindingList;
    }

    public final void addBinding(@Nonnull IBinding binding) {
        List<IBinding> list = this.m_bindingList;
        if (list == null) {
            list = this.m_bindingList = new ArrayList<IBinding>(1);
        }
        list.add(binding);
    }

    public final void removeBinding(@Nonnull IBinding binding) {
        List<IBinding> list = this.m_bindingList;
        if (null != list) {
            list.remove(binding);
        }
    }

    @Nonnull
    public final ComponentPropertyBinding bind() {
        ClassMetaModel cmm = MetaManager.findClassMeta(this.getClass());
        PropertyMetaModel<?> p = cmm.findProperty("bindValue");
        if (null != p) {
            return this.bind("bindValue");
        }
        p = cmm.findProperty("value");
        if (null != p) {
            return this.bind("value");
        }
        throw new IllegalStateException("This control (" + this.getClass() + ") does not have a 'value' nor a 'bindValue' property");
    }

    @Nonnull
    public final ComponentPropertyBinding bind(@Nonnull String componentProperty) {
        ComponentPropertyBinding binder = new ComponentPropertyBinding(this, componentProperty);
        this.addBinding(binder);
        return binder;
    }

    protected void clearValidationFailure(UIException result) {
        UIMessage msg = this.getMessage();
        if (result != null && msg != null && result.getCode().equals(msg.getCode())) {
            this.setMessage(null);
        }
    }

    public void notifyParentOrOpenerPage(@Nullable String command) {
        this.appendJavascript("try { window.parent.WebUI.notifyPage('" + command + "'); } catch (err) {}");
        this.appendJavascript("try { window.opener.WebUI.notifyPage('" + command + "'); } catch (err) {}");
    }

    public void alignToTop(@Nonnull NodeBase node, int yOffset, boolean appendAsCreateJs) {
        this.alignToTop(node, yOffset, appendAsCreateJs, false);
    }

    public void alignToTop(@Nonnull NodeBase node, int yOffset, boolean appendAsCreateJs, boolean addServerPositionCallback) {
        this.alignTo(AlignmentType.Top, "WebUI.alignToTop", node, yOffset, appendAsCreateJs, addServerPositionCallback);
    }

    public void alignTopToBottom(@Nonnull NodeBase node, int yOffset, boolean appendAsCreateJs) {
        this.alignTopToBottom(node, yOffset, appendAsCreateJs, false);
    }

    public void alignTopToBottom(@Nonnull NodeBase node, int yOffset, boolean appendAsCreateJs, boolean addServerPositionCallback) {
        this.alignTo(AlignmentType.TopToBottom, "WebUI.alignTopToBottom", node, yOffset, appendAsCreateJs, addServerPositionCallback);
    }

    public void alignToLeft(@Nonnull NodeBase node, int xOffset, boolean appendAsCreateJs) {
        this.alignToLeft(node, xOffset, appendAsCreateJs, false);
    }

    public void alignToLeft(@Nonnull NodeBase node, int xOffset, boolean appendAsCreateJs, boolean addServerPositionCallback) {
        this.alignTo(AlignmentType.Left, "WebUI.alignToLeft", node, xOffset, appendAsCreateJs, addServerPositionCallback);
    }

    public void alignToRight(@Nonnull NodeBase node, int xOffset, boolean appendAsCreateJs) {
        this.alignToRight(node, xOffset, appendAsCreateJs, false);
    }

    public void alignToRight(@Nonnull NodeBase node, int xOffset, boolean appendAsCreateJs, boolean addServerPositionCallback) {
        this.alignTo(AlignmentType.Right, "WebUI.alignToRight", node, xOffset, appendAsCreateJs, addServerPositionCallback);
    }

    public void alignToMiddle(@Nonnull NodeBase node, int xOffset, boolean appendAsCreateJs) {
        this.alignToMiddle(node, xOffset, appendAsCreateJs, false);
    }

    public void alignToMiddle(@Nonnull NodeBase node, int xOffset, boolean appendAsCreateJs, boolean addServerPositionCallback) {
        this.alignTo(AlignmentType.Middle, "WebUI.alignToMiddle", node, xOffset, appendAsCreateJs, addServerPositionCallback);
    }

    private void alignTo(final @Nonnull AlignmentType alignment, @Nonnull String jsFunction, @Nonnull NodeBase node, int offset, boolean appendAsCreateJs, boolean addServerPositionCallback) {
        this.setPosition(PositionType.ABSOLUTE);
        String id = this.getActualID();
        String callbackParam = addServerPositionCallback ? "true" : "false";
        String js = jsFunction + "('" + id + "', '" + node.getActualID() + "', " + offset + ", " + callbackParam + ");";
        if (appendAsCreateJs) {
            this.appendCreateJS(js);
        } else {
            this.appendJavascript(js);
        }
        if (addServerPositionCallback) {
            this.setOnSizeAndPositionChange(new INotify<NodeBase>(){

                @Override
                public void onNotify(NodeBase sender) throws Exception {
                    Rect clientBounds = NodeBase.this.getClientBounds();
                    if (null != clientBounds) {
                        switch (alignment) {
                            case Top: 
                            case TopToBottom: {
                                NodeBase.this.setTop(clientBounds.getTop());
                                break;
                            }
                            default: {
                                NodeBase.this.setLeft(clientBounds.getLeft());
                            }
                        }
                    }
                }
            });
        }
    }

    @Nullable
    protected Rect getClientBounds() {
        return this.m_clientBounds;
    }

    protected void setClientBounds(@Nonnull Rect clientBound) {
        this.m_clientBounds = clientBound;
    }

    @Nullable
    protected Dimension getBrowserWindowSize() {
        return this.m_browserWindowSize;
    }

    protected void setBrowserWindowSize(@Nonnull Dimension browserWindowSize) {
        this.m_browserWindowSize = browserWindowSize;
    }

    @Nullable
    protected INotify<NodeBase> getOnSizeAndPositionChange() {
        return this.m_onSizeAndPositionChange;
    }

    protected void setOnSizeAndPositionChange(@Nonnull INotify<NodeBase> onSizeAndPositionChange) {
        this.m_onSizeAndPositionChange = onSizeAndPositionChange;
    }

    private void handleClientPositionAndSizeChange(@Nonnull RequestContextImpl ctx) throws Exception {
        String valueRect = ctx.getParameter(this.getActualID() + "_rect");
        String valueBrowserWindowSize = ctx.getParameter("window_size");
        if (null != valueRect && null != valueBrowserWindowSize) {
            String[] values = valueRect.split(",");
            try {
                int left = Math.round(Float.parseFloat(values[0]));
                int top = Math.round(Float.parseFloat(values[1]));
                int width = Math.round(Float.parseFloat(values[2]));
                int height = Math.round(Float.parseFloat(values[3]));
                this.setClientBounds(new Rect(left, top, width + left, height + top));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unrecognized notifyClientPositionAndSize valueRect (id='" + this.getActualID() + "'):" + valueRect, ex);
            }
            values = valueBrowserWindowSize.split(",");
            try {
                int width = Math.round(Float.parseFloat(values[0]));
                int height = Math.round(Float.parseFloat(values[1]));
                this.setBrowserWindowSize(new Dimension(width, height));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unrecognized notifyClientPositionAndSize valueBrowserWindowSize (id='" + this.getActualID() + "'):" + valueBrowserWindowSize, ex);
            }
            INotify<NodeBase> listener = this.getOnSizeAndPositionChange();
            if (listener != null) {
                listener.onNotify(this);
            }
        }
    }

    private static enum AlignmentType {
        Top,
        TopToBottom,
        Left,
        Right,
        Middle;

    }
}

