/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import to.etc.domui.component.layout.FloatingDiv;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.IConverter;
import to.etc.domui.dom.errors.ErrorFenceHandler;
import to.etc.domui.dom.errors.IErrorFence;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.IActionControl;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.TextNode;
import to.etc.domui.util.DomUtil;
import to.etc.webapp.ProgrammerErrorException;

public abstract class NodeContainer
extends NodeBase
implements Iterable<NodeBase> {
    private List<NodeBase> m_children = Collections.EMPTY_LIST;
    private boolean m_childHasUpdates;
    private boolean m_mustRenderChildrenFully;
    private NodeBase[] m_oldChildren;
    private IErrorFence m_errorFence;
    private NodeContainer m_delegate;

    public NodeContainer(@Nonnull String tag) {
        super(tag);
    }

    final boolean mustRenderChildrenFully() {
        return this.m_mustRenderChildrenFully;
    }

    final void setMustRenderChildrenFully(boolean mustRenderChildrenFully) {
        this.m_mustRenderChildrenFully = mustRenderChildrenFully;
    }

    final void setMustRenderChildrenFully() {
        this.setMustRenderChildrenFully(true);
    }

    final void childChanged() {
        NodeContainer c = this;
        while (true) {
            if (c.m_childHasUpdates) {
                return;
            }
            c.m_childHasUpdates = true;
            if (!c.hasParent()) break;
            c = c.getParent();
        }
    }

    final boolean childHasUpdates() {
        return this.m_childHasUpdates;
    }

    final void setChildHasUpdates(boolean childHasUpdates) {
        this.m_childHasUpdates = childHasUpdates;
    }

    final List<NodeBase> internalGetChildren() {
        return this.m_children;
    }

    @Override
    public final void internalCheckNotDirty() {
        super.internalCheckNotDirty();
        if (this.childHasUpdates()) {
            throw new IllegalStateException("The node " + this + " has 'childHasUpdates' set");
        }
        if (this.internalGetOldParent() != null) {
            throw new IllegalStateException("The node " + this + " has an 'oldParent' set");
        }
        if (this.internalGetOldChildren() != null) {
            throw new IllegalStateException("The node " + this + " has 'oldChildren' set");
        }
    }

    @Override
    public final void internalClearDelta() {
        super.internalClearDelta();
        this.setMustRenderChildrenFully(false);
        this.m_oldChildren = null;
        this.m_childHasUpdates = false;
    }

    @Override
    public final void internalClearDeltaFully() {
        this.internalClearDelta();
        int i = this.m_children.size();
        while (--i >= 0) {
            this.m_children.get(i).internalClearDeltaFully();
        }
    }

    public final NodeBase[] internalGetOldChildren() {
        return this.m_oldChildren;
    }

    @Override
    protected int internalGetNodeCount(int depth) {
        if (depth <= 0) {
            return 0;
        }
        --depth;
        int count = 0;
        for (NodeBase b : this.m_children) {
            count += b.internalGetNodeCount(depth);
        }
        return count;
    }

    @Override
    @Nonnull
    public final Iterator<NodeBase> iterator() {
        if (this.m_delegate != null) {
            return this.m_delegate.iterator();
        }
        return this.m_children.iterator();
    }

    public final int getChildCount() {
        if (this.m_delegate != null) {
            return this.m_delegate.getChildCount();
        }
        return this.m_children.size();
    }

    public final int findChildIndex(@Nonnull NodeBase b) {
        int ix;
        if (this.m_delegate != null && (ix = this.m_delegate.findChildIndex(b)) != -1) {
            return ix;
        }
        if (!b.hasParent()) {
            return -1;
        }
        if (b.getParent() != this) {
            return -1;
        }
        return this.m_children.indexOf(b);
    }

    @Nonnull
    public final NodeBase getChild(int i) {
        if (this.m_delegate != null) {
            return this.m_delegate.getChild(i);
        }
        return this.m_children.get(i);
    }

    public final NodeBase undelegatedGetChild(int i) {
        return this.m_children.get(i);
    }

    final void treeChanging() {
        if (this.m_oldChildren != null) {
            return;
        }
        if (this.hasParent()) {
            this.getParent().childChanged();
        }
        if (this.isAttached()) {
            this.getPage().copyIdMap();
        }
        this.m_oldChildren = this.m_children.toArray(new NodeBase[this.m_children.size()]);
        int i = this.m_oldChildren.length;
        while (--i >= 0) {
            this.m_oldChildren[i].internalSetOldParent(this);
        }
    }

    final void registerChildren() {
        for (int i = 0; i < 50; ++i) {
            try {
                for (NodeBase ch : this.m_children) {
                    if (ch.isAttached()) continue;
                    ch.registerWithPage(this.getPage());
                }
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        throw new IllegalStateException("registerChildren() keeps dying with ConcurrentModificationException!?");
    }

    private final void registerWithPage(@Nonnull NodeBase child) {
        if (!this.isAttached()) {
            return;
        }
        child.registerWithPage(this.getPage());
    }

    @Override
    final void registerWithPage(@Nonnull Page p) {
        super.registerWithPage(p);
        this.registerChildren();
    }

    @Override
    final void unregisterFromPage() {
        for (int i = 0; i < 50; ++i) {
            try {
                for (NodeBase b : this.m_children) {
                    if (this == b) {
                        throw new IllegalStateException("Internal: somehow I (the parent) is also present in my own list-of-children!?");
                    }
                    b.unregisterFromPage();
                }
                super.unregisterFromPage();
                return;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        throw new IllegalStateException("unregisterFromPage: keeps throwing ConcurrentModificationExceptions!??");
    }

    @OverridingMethodsMustInvokeSuper
    protected void canContain(@Nonnull NodeBase node) {
    }

    @Nonnull
    public final NodeContainer add(@Nonnull NodeBase nd) {
        this.add(Integer.MAX_VALUE, nd);
        return this;
    }

    public final void add(int index, @Nonnull NodeBase nd) {
        if (nd instanceof FloatingDiv) {
            if (!this.isAttached()) {
                throw new ProgrammerErrorException("The component " + nd.getClass() + " is defined as 'must be added to the body' but the node it is added to " + this + " is not yet added to the page.");
            }
            this.getPage().internalAddFloater(this, (FloatingDiv)nd);
            return;
        }
        if (this.m_delegate != null) {
            this.m_delegate.add(index, nd);
            return;
        }
        this.internalAdd(index, nd);
    }

    public final void undelegatedAdd(int index, @Nonnull NodeBase nd) {
        if (nd instanceof FloatingDiv) {
            if (!this.isAttached()) {
                throw new ProgrammerErrorException("The component " + nd.getClass() + " is defined as 'must be added to the body' but the node it is added to " + this + " is not yet added to the page.");
            }
            this.getPage().internalAddFloater(this, (FloatingDiv)nd);
            return;
        }
        this.internalAdd(index, nd);
    }

    protected final void internalAdd(int index, @Nonnull NodeBase nd) {
        if (nd == this) {
            throw new IllegalStateException("Attempt to add a node " + nd + " to itself as a child.");
        }
        this.canContain(nd);
        if (this.m_children == Collections.EMPTY_LIST) {
            this.m_children = new ArrayList<NodeBase>();
        }
        nd.remove();
        if (nd instanceof TextNode) {
            this.setMustRenderChildrenFully();
        }
        this.treeChanging();
        if (index >= this.m_children.size()) {
            this.m_children.add(nd);
        } else {
            this.m_children.add(index, nd);
        }
        nd.setParent(this);
        this.registerWithPage(nd);
        this.childChanged();
    }

    @Nonnull
    public final NodeContainer add(@Nullable String txt) {
        if (txt != null && txt.length() > 0) {
            this.add(new TextNode(txt));
        }
        return this;
    }

    public final void removeChild(@Nonnull NodeBase child) {
        int ix = this.m_children.indexOf(child);
        if (ix == -1) {
            if (this.m_delegate != null) {
                this.m_delegate.removeChild(child);
                return;
            }
            if (child.getParent() != this) {
                throw new IllegalStateException("Child " + child + " is not a child of container " + this);
            }
            throw new IllegalStateException("Child " + child + " was not in list!? " + this);
        }
        this.treeChanging();
        this.m_children.remove(ix);
        child.unregisterFromPage();
        child.setParent(null);
        this.childChanged();
    }

    @Nonnull
    public final NodeBase removeChild(int index) {
        if (this.m_delegate != null) {
            return this.m_delegate.removeChild(index);
        }
        if (index < 0 || index >= this.m_children.size()) {
            throw new IllegalStateException("Bad delete index " + index + " on node " + this + " with " + this.m_children.size() + " children");
        }
        this.treeChanging();
        NodeBase child = this.m_children.remove(index);
        child.unregisterFromPage();
        child.setParent(null);
        this.childChanged();
        return child;
    }

    public final void replaceChild(@Nonnull NodeBase child, @Nonnull NodeBase nw) {
        int ix = this.m_children.indexOf(child);
        if (ix == -1) {
            if (this.m_delegate != null) {
                this.m_delegate.replaceChild(child, nw);
                return;
            }
            if (child.getParent() != this) {
                throw new IllegalStateException("Child " + child + " is not a child of container " + this);
            }
            throw new IllegalStateException("Child " + child + " was not in list!? " + this);
        }
        this.treeChanging();
        this.m_children.set(ix, nw);
        child.unregisterFromPage();
        child.setParent(null);
        nw.remove();
        nw.setParent(this);
        this.registerWithPage(nw);
        this.childChanged();
    }

    public final void removeAllChildren() {
        if (this.m_delegate != null) {
            this.m_delegate.removeAllChildren();
            return;
        }
        if (this.m_children.size() == 0) {
            return;
        }
        this.treeChanging();
        this.m_childHasUpdates = false;
        this.m_mustRenderChildrenFully = true;
        for (NodeBase b : this.m_children) {
            b.unregisterFromPage();
            b.setParent(null);
        }
        this.m_children.clear();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public final void forceRebuild() {
        this.m_delegate = null;
        this.removeAllChildren();
        this.treeChanging();
        super.forceRebuild();
    }

    public void setText(@Nullable String txt) {
        if (this.m_delegate != null) {
            this.m_delegate.setText(txt);
            return;
        }
        this.setMustRenderChildrenFully();
        if (this.getChildCount() == 1 && this.getChild(0) instanceof TextNode) {
            ((TextNode)this.getChild(0)).setText(txt);
            this.childChanged();
            this.treeChanging();
            return;
        }
        while (this.getChildCount() > 0) {
            this.removeChild(this.getChild(this.getChildCount() - 1));
        }
        if (null != txt && txt.length() > 0) {
            TextNode t = new TextNode(txt);
            this.add(t);
        }
    }

    @Nullable
    public String getTextContents() {
        StringBuilder sb = new StringBuilder();
        for (NodeBase nb : this) {
            if (nb instanceof TextNode) {
                TextNode tn = (TextNode)nb;
                sb.append(tn.getText());
                continue;
            }
            return null;
        }
        return sb.toString();
    }

    @Override
    protected final void internalShelve() throws Exception {
        this.onShelve();
        int i = this.m_children.size();
        while (--i >= 0) {
            this.m_children.get(i).internalShelve();
        }
    }

    @Override
    protected final void internalUnshelve() throws Exception {
        this.onUnshelve();
        int i = this.m_children.size();
        while (--i >= 0) {
            this.m_children.get(i).internalUnshelve();
        }
    }

    public TBody addTable(String ... headers) {
        Table t = new Table();
        t.setCellPadding("0");
        t.setCellSpacing("0");
        this.add(t);
        if (headers != null && headers.length > 0) {
            t.getHead().setHeaders(headers);
        }
        TBody b = new TBody();
        t.add(b);
        return b;
    }

    @Nonnull
    public TBody addTableForLayout(String css) {
        Table t = new Table();
        t.setCssClass(css);
        t.addCssClass("ui-layout");
        t.setCellPadding("0");
        t.setCellSpacing("0");
        t.setTableWidth("100%");
        this.add(t);
        TBody b = new TBody();
        t.add(b);
        return b;
    }

    @Nonnull
    public TBody addTableForLayout() {
        return this.addTableForLayout(null);
    }

    public final <T> List<T> getChildren(@Nonnull Class<T> ofClass) {
        if (this.m_delegate != null) {
            return this.m_delegate.getChildren(ofClass);
        }
        ArrayList<NodeBase> res = null;
        for (NodeBase b : this.m_children) {
            if (!ofClass.isAssignableFrom(b.getClass())) continue;
            if (res == null) {
                res = new ArrayList<NodeBase>();
            }
            res.add(b);
        }
        return res == null ? Collections.EMPTY_LIST : res;
    }

    @Nonnull
    public final <T> List<T> getDeepChildren(@Nonnull Class<T> ofClass) {
        if (this.m_delegate != null) {
            return this.m_delegate.getDeepChildren(ofClass);
        }
        ArrayList res = new ArrayList();
        this.internalDeepChildren(res, ofClass);
        return res;
    }

    private final <T> void internalDeepChildren(List<T> res, Class<T> ofClass) {
        for (NodeBase b : this.m_children) {
            if (ofClass.isAssignableFrom(b.getClass())) {
                res.add(b);
                continue;
            }
            if (!(b instanceof NodeContainer)) continue;
            ((NodeContainer)b).internalDeepChildren(res, ofClass);
        }
    }

    @Override
    protected void onRefresh() throws Exception {
        if (this.m_delegate != null) {
            this.m_delegate.onRefresh();
            return;
        }
        for (int i = 0; i < this.m_children.size(); ++i) {
            this.m_children.get(i).onRefresh();
        }
    }

    public <T, C extends IConverter<T>> void setValue(@Nonnull Class<C> conv, @Nullable T value) throws Exception {
        this.setText(ConverterRegistry.convertValueToString(conv, value));
    }

    @Nullable
    public final IErrorFence getErrorFence() {
        IErrorFence f;
        if (this.m_delegate != null && null != (f = this.m_delegate.getErrorFence())) {
            return f;
        }
        return this.m_errorFence;
    }

    public final void setErrorFence(@Nullable IErrorFence errorFence) {
        if (this.m_delegate != null) {
            this.m_delegate.setErrorFence(errorFence);
        } else {
            this.m_errorFence = errorFence;
        }
    }

    public final void setErrorFence() {
        if (this.m_delegate != null) {
            this.m_delegate.setErrorFence();
        } else if (this.m_errorFence == null) {
            this.m_errorFence = new ErrorFenceHandler(this);
        }
    }

    @Override
    public final void internalOnBeforeRender() throws Exception {
        this.onBeforeRender();
        int i = this.m_children.size();
        while (--i >= 0) {
            this.m_children.get(i).internalOnBeforeRender();
        }
    }

    public final void delegateTo(@Nullable NodeContainer c) {
        if (c == this) {
            throw new IllegalStateException("Cannot delegate to self: this would nicely loop..");
        }
        NodeContainer nc = c;
        int dc = 0;
        while (nc != null) {
            if (++dc > 10) {
                throw new ProgrammerErrorException("Too many delegation levels: can be a delegation loop");
            }
            nc = nc.m_delegate;
        }
        this.m_delegate = c;
    }

    public NodeContainer getDelegate() {
        return this.m_delegate;
    }

    @Override
    protected final void internalCreateFrame() throws Exception {
        this.m_delegate = null;
        this.createFrame();
    }

    @OverridingMethodsMustInvokeSuper
    protected void createFrame() throws Exception {
    }

    @Override
    public void appendTreeErrors(@Nonnull List<UIMessage> errorList) {
        super.appendTreeErrors(errorList);
        for (NodeBase nb : this) {
            nb.appendTreeErrors(errorList);
        }
    }

    @Override
    public boolean hasError() {
        for (NodeBase nb : this) {
            if (!nb.hasError()) continue;
            return true;
        }
        return false;
    }

    public void disableAllChildControlsDeep() throws Exception {
        for (IControl iControl : this.getDeepChildren(IControl.class)) {
            iControl.setReadOnly(true);
            iControl.setDisabled(true);
            if (!(iControl instanceof NodeContainer)) continue;
            DomUtil.buildTree((NodeContainer)((Object)iControl));
            ((NodeContainer)((Object)iControl)).disableAllChildControlsDeep();
        }
        for (IActionControl iActionControl : this.getDeepChildren(IActionControl.class)) {
            iActionControl.setDisabled(true);
            if (!(iActionControl instanceof NodeContainer)) continue;
            DomUtil.buildTree((NodeContainer)((Object)iActionControl));
            ((NodeContainer)((Object)iActionControl)).disableAllChildControlsDeep();
        }
    }
}

