/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.domui.dom.HtmlFullRenderer;
import to.etc.domui.dom.HtmlRenderMode;
import to.etc.domui.dom.HtmlTagRenderer;
import to.etc.domui.dom.IBrowserOutput;
import to.etc.domui.dom.IHtmlDeltaAttributeRenderer;
import to.etc.domui.dom.header.HeaderContributor;
import to.etc.domui.dom.header.HeaderContributorEntry;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Page;
import to.etc.domui.dom.html.PagePhase;
import to.etc.domui.dom.html.TextNode;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.IRequestContext;
import to.etc.util.IndentWriter;
import to.etc.util.StringTool;

public class OptimalDeltaRenderer {
    private static final boolean DEBUG = false;
    private IBrowserOutput m_o;
    private HtmlTagRenderer m_html;
    private IRequestContext m_ctx;
    private Page m_page;
    private HtmlFullRenderer m_fullRenderer;
    private Map<NodeContainer, NodeInfo> m_infoMap = new HashMap<NodeContainer, NodeInfo>(255);

    public OptimalDeltaRenderer(HtmlFullRenderer fullr, IRequestContext ctx, Page page) {
        this.m_o = fullr.o();
        this.m_html = fullr.getTagRenderer();
        this.m_fullRenderer = fullr;
        this.m_fullRenderer.setXml(true);
        this.m_html.setRenderMode(HtmlRenderMode.ATTR);
        this.m_ctx = ctx;
        this.m_page = page;
    }

    @Nonnull
    public IBrowserOutput o() {
        return this.m_o;
    }

    public IRequestContext ctx() {
        return this.m_ctx;
    }

    public Page page() {
        return this.m_page;
    }

    public void render() throws Exception {
        int pollinterval;
        this.m_page.internalSetPhase(PagePhase.DELTARENDER);
        this.o().writeRaw("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        this.o().tag("delta");
        this.o().endtag();
        List<HeaderContributorEntry> list = this.m_page.getAddedContributors();
        if (list.size() > 0) {
            Collections.sort(list, HeaderContributor.C_ENTRY);
            this.o().tag("eval");
            this.o().endtag();
            for (HeaderContributorEntry hc : list) {
                hc.getContributor().contribute(this);
            }
            this.o().closetag("eval");
            this.m_page.internalContributorsRendered();
        }
        this.calc(this.m_page);
        this.o().tag("eval");
        this.o().endtag();
        this.o().text(this.m_fullRenderer.getCreateJS().toString());
        StringBuilder sb = this.m_page.internalFlushAppendJS();
        if (null != sb) {
            this.o().text(sb.toString());
        }
        if (null != (sb = this.m_page.internalFlushJavascriptStateChanges())) {
            this.o().writeRaw(sb);
        }
        NodeBase focusComponent = this.m_page.getFocusComponent();
        if (this.m_page.getDefaultFocusSource() != null && focusComponent == null) {
            this.recurseCheckFocus(this.m_page.getDefaultFocusSource());
        }
        this.m_page.calculateDefaultFocus(null);
        focusComponent = this.m_page.getFocusComponent();
        if (focusComponent != null) {
            String focusID = focusComponent.getFocusID();
            if (null != focusID) {
                this.o().text("WebUI.focus('" + focusID + "');");
            }
            this.m_page.setFocusComponent(null);
        }
        if ((pollinterval = DomApplication.get().calculatePollInterval(this.m_page.getConversation().isPollCallbackRequired())) > 0) {
            this.o().writeRaw("WebUI.startPolling(" + pollinterval + ");");
        } else {
            this.o().writeRaw("WebUI.cancelPolling();");
        }
        this.o().closetag("eval");
        this.o().closetag("delta");
        this.m_page.internalSetPhase(PagePhase.NULL);
    }

    private boolean recurseCheckFocus(NodeBase nb) {
        if (nb.isFocusable()) {
            this.m_page.setFocusComponent(nb);
            return true;
        }
        if (!(nb instanceof NodeContainer)) {
            return false;
        }
        for (NodeBase n : (NodeContainer)nb) {
            if (!this.recurseCheckFocus(n)) continue;
            return true;
        }
        return false;
    }

    public void renderLoadCSS(@Nonnull String path) throws IOException {
        String rurl = this.m_page.getBody().getThemedResourceRURL(path);
        path = this.ctx().getRelativePath(rurl);
        this.o().writeRaw("WebUI.loadStylesheet(" + StringTool.strToJavascriptString((String)path, (boolean)false) + ");\n");
    }

    public void renderLoadJavascript(@Nonnull String path) throws IOException {
        String rurl = this.m_page.getBody().getThemedResourceRURL(path);
        path = this.ctx().getRelativePath(rurl);
        this.o().writeRaw("WebUI.loadJavascript(" + StringTool.strToJavascriptString((String)path, (boolean)false) + ");\n");
    }

    private void calc(Page page) throws Exception {
        NodeInfo root = new NodeInfo(null);
        this.doContainer(root, page.getBody());
        this.renderDeletes(root);
        this.renderRest(root);
        page.internalClearDeltaFully();
    }

    private void renderDeletes(NodeInfo ni) throws IOException {
        if (ni.isFullRender) {
            return;
        }
        if (ni.isAdded) {
            this.renderDelete(ni.node);
            return;
        }
        for (NodeBase nd : ni.deleteList) {
            this.renderDelete(nd);
        }
        for (NodeInfo t : ni.lowerChanges) {
            if (t == ni) {
                throw new IllegalStateException("? Node present on it's own lower list??? " + t);
            }
            this.renderDeletes(t);
        }
    }

    private void renderDelete(NodeBase nd) throws IOException {
        this.o().tag("remove");
        this.o().attr("select", "#" + nd.getActualID());
        this.o().endAndCloseXmltag();
        this.o().nl();
    }

    private void renderAttributeChange(NodeBase b) throws Exception {
        if (b instanceof IHtmlDeltaAttributeRenderer) {
            ((IHtmlDeltaAttributeRenderer)((Object)b)).renderAttributeChanges(this.m_html, this, this.o());
            return;
        }
        this.o().tag("changeTagAttributes");
        this.m_html.setTagless(true);
        this.m_html.setRenderMode(HtmlRenderMode.ATTR);
        b.visit(this.m_html);
        this.o().endAndCloseXmltag();
        this.o().nl();
    }

    private void renderAdd(NodeContainer parent, NodeBase nd) throws Exception {
        this.m_html.setRenderMode(HtmlRenderMode.ADDS);
        this.m_fullRenderer.setRenderMode(HtmlRenderMode.ADDS);
        if (nd.m_origNewIndex == 0) {
            this.o().tag("prepend");
            this.o().attr("select", "#" + parent.getActualID());
            this.m_html.setTagless(false);
            nd.visit(this.m_fullRenderer);
            this.o().closetag("prepend");
        } else {
            NodeBase pre = parent.internalGetChildren().get(nd.m_origNewIndex - 1);
            if (pre instanceof TextNode) {
                throw new IllegalStateException("Internal: attempting to insert after a #text node");
            }
            this.o().tag("after");
            this.o().attr("select", "#" + pre.getActualID());
            this.m_html.setTagless(false);
            nd.visit(this.m_fullRenderer);
            this.o().closetag("after");
        }
        this.o().nl();
    }

    private void renderRest(NodeInfo ni) throws Exception {
        if (ni.isFullRender) {
            if ("textarea".equalsIgnoreCase(ni.node.getTag())) {
                this.renderAttributeChange(ni.node);
                this.o().setIndentEnabled(true);
                return;
            }
            this.o().setIndentEnabled(false);
            this.o().tag("replaceContent");
            this.o().attr("select", "#" + ni.node.getActualID());
            this.m_html.setTagless(false);
            this.m_html.setRenderMode(HtmlRenderMode.REPL);
            this.m_fullRenderer.setRenderMode(HtmlRenderMode.REPL);
            this.m_fullRenderer.visitChildren(ni.node);
            this.o().closetag("replaceContent");
            this.renderAttributeChange(ni.node);
            return;
        }
        for (NodeBase b : ni.attrChangeList) {
            this.renderAttributeChange(b);
        }
        for (NodeBase b : ni.addList) {
            this.renderAdd(ni.node, b);
        }
        for (NodeInfo tni : ni.lowerChanges) {
            this.renderRest(tni);
        }
    }

    private NodeInfo makeNodeInfo(NodeContainer c) {
        NodeInfo ni = this.m_infoMap.get(c);
        if (ni == null) {
            ni = new NodeInfo(c);
            this.m_infoMap.put(c, ni);
        }
        return ni;
    }

    private void doBase(NodeInfo parentInfo, NodeBase n) throws Exception {
        if (n.internalHasChangedAttributes()) {
            parentInfo.addAttrChange(n);
        }
    }

    private void doContainerChildren(NodeInfo nodeInfo, NodeContainer nc) throws Exception {
        List<NodeBase> chl = nc.internalGetChildren();
        int len = chl.size();
        for (int i = 0; i < len; ++i) {
            NodeBase n = chl.get(i);
            if (n instanceof NodeContainer) {
                this.doBase(nodeInfo, n);
                this.doContainer(nodeInfo, (NodeContainer)n);
                continue;
            }
            this.doBase(nodeInfo, n);
        }
    }

    private void doContainer(NodeInfo parentChanges, NodeContainer n) throws Exception {
        if (!n.isBuilt()) {
            throw new IllegalStateException("Node " + n + " is not BUILT in delta renderer");
        }
        NodeBase[] oldl = n.internalGetOldChildren();
        if (oldl != null) {
            Map<String, NodeBase> beforeMap = this.m_page.getBeforeMap();
            if (null == beforeMap) {
                throw new IllegalStateException("Before map is null inside delta?");
            }
            if (!beforeMap.containsKey(n.getActualID())) {
                for (String s : beforeMap.keySet()) {
                    System.out.println("before key=" + s);
                }
                throw new IllegalStateException("Rotary device exception: delta exists on NEW node, and we're trying to render the new node as a delta!? Node=" + n.getActualID());
            }
            this.doTreeDeltaOn(parentChanges, n);
            return;
        }
        if (n.internalHasChangedAttributes()) {
            parentChanges.addAttrChange(n);
        }
        if (n.childHasUpdates()) {
            this.doContainerChildren(parentChanges, n);
        }
        n.internalClearDelta();
    }

    private void doTreeDeltaOn(NodeInfo parentInfo, NodeContainer nc) throws Exception {
        int ncmd;
        int i;
        NodeBase[] oldar = nc.internalGetOldChildren();
        List<NodeBase> newl = nc.internalGetChildren();
        NodeInfo ni = this.makeNodeInfo(nc);
        if (oldar.length == 0 || oldar.length < newl.size() && (double)oldar.length / (double)newl.size() < 0.1 || nc.mustRenderChildrenFully()) {
            ni.setFullRerender();
            if (parentInfo != null) {
                parentInfo.addChildChange(ni);
            }
            return;
        }
        ArrayList<NodeBase> oldl = new ArrayList<NodeBase>(oldar.length);
        for (NodeBase n : oldar) {
            if (n.internalGetParent() != nc) {
                ni.addDelete(n);
                continue;
            }
            oldl.add(n);
        }
        ArrayList<NodeBase> nl = new ArrayList<NodeBase>(newl.size());
        for (i = 0; i < newl.size(); ++i) {
            NodeBase nn = newl.get(i);
            nn.m_origNewIndex = i;
            Map<String, NodeBase> beforeMap = this.m_page.getBeforeMap();
            if (null == beforeMap) {
                throw new IllegalStateException("Before map is null inside delta??");
            }
            if (nn.internalGetOldParent() == null || nn.internalGetOldParent() != nc || !beforeMap.containsKey(nn.getActualID())) {
                if (nn instanceof NodeContainer) {
                    NodeInfo nni = this.makeNodeInfo((NodeContainer)nn);
                    nni.isAdded = true;
                }
                ni.addAdd(i, nn);
                continue;
            }
            nl.add(nn);
        }
        if (oldl.size() != nl.size()) {
            System.out.println("----- Hell freezer's state ------\nOLD size=" + oldl.size() + ", new size=" + nl.size() + "\nOLD dump:");
            for (NodeBase b : oldl) {
                System.out.println("Node=" + b);
            }
            System.out.println("NEW dump:");
            for (NodeBase b : nl) {
                System.out.println("Node=" + b);
            }
            System.out.println("----- Hell freezer's state DONE ------");
            throw new IllegalStateException("The impossible has happened (Hell freezeth over?) or there's a huge algorithmic error... My bet's on the second one, so....");
        }
        i = nl.size();
        while (--i >= 0) {
            ((NodeBase)nl.get((int)i)).m_newNodeIndex = i;
        }
        i = oldl.size();
        while (--i >= 0) {
            ((NodeBase)oldl.get((int)i)).m_oldNodeIndex = i;
        }
        int olen = oldl.size();
        int nlen = nl.size();
        int oix = 0;
        int nix = 0;
        while (oix < olen) {
            NodeBase nn;
            NodeBase on = (NodeBase)oldl.get(oix);
            NodeBase nodeBase = nn = nix < nlen ? (NodeBase)nl.get(nix) : null;
            if (on == null) {
                throw new IllegalStateException("?? null in old list??");
            }
            if (on == nn) {
                NodeContainer nnc;
                ++oix;
                ++nix;
                if (on.internalHasChangedAttributes()) {
                    ni.addAttrChange(nn);
                }
                if (nn instanceof NodeContainer && ((nnc = (NodeContainer)nn).childHasUpdates() || nnc.internalGetOldChildren() != null)) {
                    this.doContainer(ni, nnc);
                }
                nn.internalClearDelta();
                continue;
            }
            if (nn == null) {
                throw new IllegalStateException("The impossible has happened (Hell freezeth over?) or there's a huge algorithmic error... My bet's on the second one, so....");
            }
            int olddelta = oix - on.m_newNodeIndex;
            int newdelta = nix - on.m_oldNodeIndex;
            if (olddelta < 0) {
                olddelta = -olddelta;
            }
            if (newdelta < 0) {
                newdelta = -newdelta;
            }
            if (olddelta > newdelta) {
                ni.addDelete(on);
                ++oix;
                continue;
            }
            ni.addAdd(nn.m_origNewIndex, nn);
            ++nix;
        }
        while (nix < nlen) {
            NodeBase nn = (NodeBase)nl.get(nix++);
            ni.addAdd(nn.m_origNewIndex, nn);
        }
        for (NodeBase nb : ni.addList) {
            NodeBase pre;
            if (nb.m_origNewIndex == 0 || !((pre = nc.internalGetChildren().get(nb.m_origNewIndex - 1)) instanceof TextNode)) continue;
            ni.setFullRerender();
        }
        if (!ni.isFullRender && (double)(ncmd = ni.deleteList.size() + ni.addList.size()) / (double)newl.size() > 0.9) {
            int xcount = 0;
            for (NodeBase n : newl) {
                xcount += n.internalGetNodeCount(2);
            }
            if (xcount > ncmd * 2) {
                ni.setFullRerender();
            }
        }
        if (parentInfo.node != nc) {
            parentInfo.addChildChange(ni);
        }
    }

    private static final String ndid(NodeInfo ni) {
        return ni.node == null ? "(ROOT)" : ni.node.getActualID();
    }

    private void dump(NodeInfo ni) throws IOException {
        StringWriter sw = new StringWriter(8192);
        IndentWriter iw = new IndentWriter((Writer)sw);
        this.dump(iw, ni);
        iw.close();
        sw.close();
        System.out.println("---- NodeInfo-render dump -----");
        System.out.println(sw.getBuffer().toString());
    }

    private void dump(IndentWriter iw, NodeInfo ni) throws IOException {
        if (ni.node == null) {
            iw.print("[(ROOT):(ROOT)]");
        } else {
            iw.print("[" + ni.node.getTag() + ":" + ni.node.getActualID() + "]");
        }
        if (ni.isFullRender) {
            iw.print(" fullRender");
        }
        if (ni.isAdded) {
            iw.print(" ADDED");
        }
        iw.println();
        if (ni.deleteList != null && ni.deleteList.size() > 0) {
            iw.inc();
            iw.print("DELETED-NODES: ");
            for (NodeBase nb : ni.deleteList) {
                iw.print(nb.getTag() + ":" + nb.getActualID() + " ");
            }
            iw.println();
            iw.dec();
        }
        if (ni.addList != null && ni.addList.size() > 0) {
            iw.inc();
            iw.print("ADDED-NODES: ");
            for (NodeBase nb : ni.addList) {
                iw.print(nb.getTag() + ":" + nb.getActualID() + " ");
            }
            iw.println();
            iw.dec();
        }
        if (ni.attrChangeList != null && ni.attrChangeList.size() > 0) {
            iw.inc();
            iw.print("ATTRCHANGED-NODES: ");
            for (NodeBase nb : ni.attrChangeList) {
                iw.print(nb.getTag() + ":" + nb.getActualID() + " ");
            }
            iw.println();
            iw.dec();
        }
        if (ni.lowerChanges != null && ni.lowerChanges.size() > 0) {
            iw.inc();
            int i = 0;
            for (NodeInfo lni : ni.lowerChanges) {
                iw.println("LOWER-NODE-CHANGE[" + i + "]");
                iw.inc();
                this.dump(iw, lni);
                iw.dec();
            }
            iw.dec();
        }
    }

    private static class NodeInfo {
        public NodeContainer node;
        public List<NodeBase> deleteList = Collections.EMPTY_LIST;
        public List<NodeBase> attrChangeList = Collections.EMPTY_LIST;
        public List<NodeBase> addList = Collections.EMPTY_LIST;
        public List<NodeInfo> lowerChanges = Collections.EMPTY_LIST;
        public boolean isAdded;
        public boolean isFullRender;

        public NodeInfo(NodeContainer c) {
            this.node = c;
        }

        public void setFullRerender() {
            this.isFullRender = true;
            this.lowerChanges = null;
            this.attrChangeList = null;
            this.deleteList = null;
        }

        public void addAttrChange(NodeBase n) {
            if (this.isFullRender || this.isAdded) {
                return;
            }
            if (this.attrChangeList == Collections.EMPTY_LIST) {
                this.attrChangeList = new ArrayList<NodeBase>();
            }
            this.attrChangeList.add(n);
        }

        public void addDelete(NodeBase b) {
            if (this.isFullRender || this.isAdded) {
                return;
            }
            if (this.deleteList == Collections.EMPTY_LIST) {
                this.deleteList = new ArrayList<NodeBase>();
            }
            this.deleteList.add(b);
        }

        public void addAdd(int ix, NodeBase n) {
            if (this.isFullRender || this.isAdded) {
                return;
            }
            if (this.addList == Collections.EMPTY_LIST) {
                this.addList = new ArrayList<NodeBase>();
            }
            this.addList.add(n);
        }

        public void addChildChange(NodeInfo ch) {
            if (ch == this) {
                throw new IllegalStateException("?? Adding myself to my own lower list?! " + this.node);
            }
            if (this.lowerChanges == Collections.EMPTY_LIST) {
                this.lowerChanges = new ArrayList<NodeInfo>();
            }
            this.lowerChanges.add(ch);
        }
    }
}

