/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.binding.OldBindingHandler;
import to.etc.domui.component.layout.FloatingDiv;
import to.etc.domui.component.misc.WindowParameters;
import to.etc.domui.dom.errors.IErrorFence;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.header.HeaderContributor;
import to.etc.domui.dom.header.HeaderContributorEntry;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.INotificationListener;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.PagePhase;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.server.DomApplication;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.IPageParameters;
import to.etc.domui.state.PageParameters;
import to.etc.domui.state.UIContext;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IExecute;
import to.etc.domui.util.javascript.JavascriptStmt;
import to.etc.webapp.core.IRunnable;
import to.etc.webapp.nls.NlsContext;
import to.etc.webapp.query.IQContextContainer;
import to.etc.webapp.query.QContextContainer;

public final class Page
implements IQContextContainer {
    private int m_nextID = 1;
    private final int m_pageTag;
    @Nullable
    private StringBuilder m_sb;
    private IPageParameters m_pageParameters;
    private ConversationContext m_cc;
    @Nonnull
    private final Map<String, NodeBase> m_nodeMap = new HashMap<String, NodeBase>(127);
    @Nullable
    private Map<String, NodeBase> m_beforeMap;
    @Nonnull
    private List<HeaderContributorEntry> m_orderedContributorList = Collections.EMPTY_LIST;
    private int m_lastContributorIndex;
    private Set<HeaderContributor> m_headerContributorSet;
    private StringBuilder m_appendJS;
    private int m_pageExceptionCount;
    private boolean m_fullRenderCompleted;
    @Nonnull
    private final UrlPage m_rootContent;
    private NodeBase m_focusComponent;
    private NodeContainer m_currentPopIn;
    private Map<String, Object> m_pageData = Collections.EMPTY_MAP;
    private boolean m_allowVectorGraphics;
    private Set<NodeBase> m_pendingBuildSet = new HashSet<NodeBase>();
    private NodeBase m_theCurrentNode;
    private boolean m_renderAsXHTML;
    private boolean m_injected;
    private List<FloatingDiv> m_floatingWindowStack;
    private int m_requestCounter;
    @Nonnull
    private PagePhase m_phase = PagePhase.NULL;
    @Nonnull
    private List<NodeBase> m_removeAfterRenderList = Collections.EMPTY_LIST;
    @Nonnull
    private List<IExecute> m_afterRequestListenerList = Collections.EMPTY_LIST;
    @Nonnull
    private List<IExecute> m_beforeRequestListenerList = Collections.EMPTY_LIST;
    @Nonnull
    private final Map<String, IntRef> m_testIdMap = new HashMap<String, IntRef>();
    private boolean m_shelved;
    private NodeBase m_defaultFocusSource;
    private NodeBase m_validationSource;
    private IRunnable m_validationAction;
    @Nonnull
    private final Set<NodeBase> m_javaScriptStateChangedSet = new HashSet<NodeBase>();
    private List<NotificationListener<?>> m_notificationListenerList = new ArrayList();

    public Page(@Nonnull UrlPage pageContent) throws Exception {
        this.m_pageTag = DomApplication.internalNextPageTag();
        this.m_rootContent = pageContent;
        this.registerNode(pageContent);
        pageContent.internalSetTag("body");
        pageContent.setErrorFence();
        String res = DomApplication.get().findLocalizedResourceName("$js/calendarnls", ".js", NlsContext.getLocale());
        if (res == null) {
            throw new IllegalStateException("internal: missing calendar NLS resource $js/calendarnls{nls}.js");
        }
        this.addHeaderContributor(HeaderContributor.loadJavascript(res), -760);
        res = DomApplication.get().findLocalizedResourceName("$js/domuinls", ".js", NlsContext.getLocale());
        if (res == null) {
            throw new IllegalStateException("internal: missing domui NLS resource $js/domuinls{nls}.js");
        }
        this.addHeaderContributor(HeaderContributor.loadJavascript(res), -760);
    }

    public void internalSetPhase(@Nonnull PagePhase phase) {
        this.m_phase = phase;
    }

    public void inNull() {
        if (this.m_phase == PagePhase.NULL) {
            return;
        }
        throw new IllegalStateException("DomUI: not allowed in state " + (Object)((Object)this.m_phase));
    }

    public void inRender() {
        if (this.m_phase == PagePhase.FULLRENDER || this.m_phase == PagePhase.DELTARENDER) {
            return;
        }
        throw new IllegalStateException("DomUI: not allowed in state " + (Object)((Object)this.m_phase));
    }

    public void inBuild() {
        if (this.m_phase == PagePhase.BUILD) {
            return;
        }
        throw new IllegalStateException("DomUI: not allowed in state " + (Object)((Object)this.m_phase));
    }

    public final void internalInitialize(@Nonnull IPageParameters pp, @Nonnull ConversationContext cc) {
        if (pp == null) {
            throw new IllegalStateException("Internal: Page parameters cannot be null here");
        }
        if (cc == null) {
            throw new IllegalStateException("Internal: ConversationContext cannot be null here");
        }
        this.m_cc = cc;
        if (!pp.isReadOnly()) {
            if (pp instanceof PageParameters) {
                ((PageParameters)pp).setReadOnly();
            } else {
                PageParameters rpp = pp.getUnlockedCopy();
                rpp.setReadOnly();
                pp = rpp;
            }
        }
        this.m_pageParameters = pp;
    }

    public void setTheCurrentNode(@Nullable NodeBase b) {
        if (b != null && b.getPage() != this) {
            throw new IllegalStateException("The node is not part of this page!");
        }
        this.m_theCurrentNode = b;
    }

    @Nullable
    public NodeBase getTheCurrentNode() {
        return this.m_theCurrentNode;
    }

    @Nullable
    public NodeBase getTheCurrentControl() {
        NodeBase nb;
        for (nb = this.getTheCurrentNode(); nb != null && !(nb instanceof IControl) && nb.hasParent(); nb = nb.getParent()) {
        }
        return nb != null ? nb : this.getTheCurrentNode();
    }

    @Nonnull
    public Map<String, NodeBase> internalNodeMap() {
        return this.m_nodeMap;
    }

    @Nonnull
    private StringBuilder sb() {
        StringBuilder sb = this.m_sb;
        if (sb == null) {
            sb = this.m_sb = new StringBuilder(64);
        } else {
            sb.setLength(0);
        }
        return sb;
    }

    @Nonnull
    public DomApplication getApplication() {
        return DomApplication.get();
    }

    @Nonnull
    public IPageParameters getPageParameters() {
        if (null != this.m_pageParameters) {
            return this.m_pageParameters;
        }
        throw new IllegalStateException("The page is not initialized??");
    }

    public int getRequestCounter() {
        return this.m_requestCounter;
    }

    public void internalIncrementRequestCounter() {
        ++this.m_requestCounter;
    }

    public final int getPageTag() {
        return this.m_pageTag;
    }

    @Nonnull
    final String nextID() {
        StringBuilder sb = this.sb();
        sb.append("_");
        for (int id = this.m_nextID++; id != 0; id /= 36) {
            int d = id % 36;
            d = d <= 9 ? (d += 48) : 65 + (d - 10);
            sb.append((char)d);
        }
        return sb.toString();
    }

    final void registerNode(@Nonnull NodeBase n) {
        if (n.isAttached()) {
            throw new IllegalStateException("Node still attached to other page");
        }
        String id = n.internalGetID();
        if (id != null) {
            if (this.m_nodeMap.containsKey(id)) {
                id = this.nextID();
                n.setActualID(id);
            }
        } else {
            id = this.nextID();
            n.setActualID(id);
        }
        if (null != this.m_nodeMap.put(id, n)) {
            throw new IllegalStateException("Duplicate node ID '" + id + "'!?!?");
        }
        n.setPage(this);
        n.onHeaderContributors(this);
        n.internalOnAddedToPage(this);
        if (n.isFocusRequested()) {
            this.setFocusComponent(n);
            n.clearFocusRequested();
        }
        this.internalAddPendingBuild(n);
        UIMessage message = n.getMessage();
        if (message != null) {
            IErrorFence fence = DomUtil.getMessageFence(n);
            fence.addMessage(message);
        }
    }

    final void unregisterNode(@Nonnull NodeBase n) {
        if (n.getPage() != this) {
            throw new IllegalStateException("This node does not belong to this page!?");
        }
        if (n.getActualID() == null) {
            throw new IllegalStateException("This-node's actual ID has gone!?");
        }
        if (this.m_theCurrentNode == n) {
            this.m_theCurrentNode = n.getParent();
        }
        n.internalOnRemoveFromPage(this);
        n.setPage(null);
        if (this.m_nodeMap.remove(n.getActualID()) == null) {
            throw new IllegalStateException("The node with ID=" + n.getActualID() + " was not found!?");
        }
        this.m_pendingBuildSet.remove(n);
    }

    @Nullable
    public NodeBase findNodeByID(@Nonnull String id) {
        return this.m_nodeMap.get(id);
    }

    protected final void copyIdMap() {
        if (this.m_beforeMap != null) {
            return;
        }
        this.m_beforeMap = new HashMap<String, NodeBase>(this.m_nodeMap);
    }

    @Nullable
    public final Map<String, NodeBase> getBeforeMap() {
        return this.m_beforeMap;
    }

    public void internalClearDeltaFully() {
        for (NodeBase nb : this.m_removeAfterRenderList) {
            nb.remove();
        }
        this.m_removeAfterRenderList.clear();
        this.getBody().internalClearDeltaFully();
        this.m_beforeMap = null;
        this.m_sb = null;
    }

    public void addRemoveAfterRenderNode(@Nonnull NodeBase node) {
        if (this.m_removeAfterRenderList == Collections.EMPTY_LIST) {
            this.m_removeAfterRenderList = new ArrayList<NodeBase>();
        }
        this.m_removeAfterRenderList.add(node);
    }

    @Nonnull
    public String allocateTestID(@Nonnull String initial) {
        IntRef ir = this.m_testIdMap.get(initial);
        if (null == ir) {
            ir = new IntRef();
            this.m_testIdMap.put(initial, ir);
            return initial;
        }
        int v = ++ir.m_value;
        return initial + "_" + v;
    }

    public boolean isTestIDAllocated(@Nonnull String id) {
        return this.m_testIdMap.get(id) != null;
    }

    public final void addHeaderContributor(@Nonnull HeaderContributor hc, int order) {
        if (this.m_headerContributorSet == null) {
            this.m_headerContributorSet = new HashSet<HeaderContributor>(30);
            this.m_orderedContributorList = new ArrayList<HeaderContributorEntry>(30);
            this.m_headerContributorSet.add(hc);
            this.m_orderedContributorList.add(new HeaderContributorEntry(hc, order));
            return;
        }
        if (this.m_headerContributorSet.contains(hc)) {
            return;
        }
        this.m_headerContributorSet.add(hc);
        this.m_orderedContributorList.add(new HeaderContributorEntry(hc, order));
    }

    public synchronized void internalAddContributors(@Nonnull List<HeaderContributorEntry> full) {
        full.addAll(this.m_orderedContributorList);
    }

    @Nonnull
    public List<HeaderContributorEntry> getHeaderContributorList() {
        return new ArrayList<HeaderContributorEntry>(this.m_orderedContributorList);
    }

    @Nonnull
    public List<HeaderContributorEntry> getAddedContributors() {
        if (this.m_orderedContributorList == null || this.m_lastContributorIndex >= this.m_orderedContributorList.size()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<HeaderContributorEntry>(this.m_orderedContributorList.subList(this.m_lastContributorIndex, this.m_orderedContributorList.size()));
    }

    public void internalContributorsRendered() {
        this.m_lastContributorIndex = this.m_orderedContributorList == null ? 0 : this.m_orderedContributorList.size();
    }

    @Nonnull
    public UrlPage getBody() {
        return this.m_rootContent;
    }

    public <T> void setData(@Nonnull T inst) {
        if (this.m_pageData == Collections.EMPTY_MAP) {
            this.m_pageData = new HashMap<String, Object>();
        }
        this.m_pageData.put(inst.getClass().getName(), inst);
    }

    @Nullable
    public <T> T getData(@Nonnull Class<T> clz) {
        return (T)this.m_pageData.get(clz.getName());
    }

    public void modelToControl() throws Exception {
        this.internalSetPhase(PagePhase.bindModelToControl);
        try {
            OldBindingHandler.modelToControl(this.getBody());
        }
        finally {
            this.internalSetPhase(PagePhase.NULL);
        }
    }

    public void controlToModel() throws Exception {
        this.internalSetPhase(PagePhase.bindControlToModel);
        try {
            OldBindingHandler.controlToModel(this.getBody());
        }
        finally {
            this.internalSetPhase(PagePhase.NULL);
        }
    }

    void internalAddFloater(@Nonnull NodeContainer originalParent, @Nonnull FloatingDiv in) {
        if (!(in instanceof FloatingDiv)) {
            throw new IllegalStateException("Floaters can only be FloatingDiv-derived, and " + in + " is not.");
        }
        if (this.getBody() == null) {
            throw new IllegalStateException("Ehm- I have no body?");
        }
        final FloatingDiv window = in;
        for (FloatingDiv floatingDiv : this.getFloatingStack()) {
            if (floatingDiv != window) continue;
            return;
        }
        int zindex = 100;
        for (FloatingDiv fr : this.getFloatingStack()) {
            if (fr.getZIndex() < zindex) continue;
            zindex = fr.getZIndex() + 100;
        }
        window.setZIndex(zindex);
        if (window.isModal()) {
            Div div = new Div();
            this.getBody().add(div);
            div.setCssClass("ui-flw-hider");
            div.setZIndex(zindex - 1);
            window.internalSetHider(div);
            div.setClicked(new IClicked<NodeBase>(){

                @Override
                public void clicked(@Nonnull NodeBase clickednode) throws Exception {
                    if (window.isAutoClose()) {
                        window.closePressed();
                    }
                }
            });
        }
        this.getFloatingStack().add(window);
        this.getBody().internalAdd(Integer.MAX_VALUE, window);
    }

    public void internalRemoveFloater(@Nonnull FloatingDiv floater) {
        if (!this.getFloatingStack().remove(floater)) {
            return;
        }
        Div h = floater.internalGetHider();
        if (h != null) {
            h.remove();
            floater.internalSetHider(null);
        }
    }

    @Nonnull
    private List<FloatingDiv> getFloatingStack() {
        if (this.m_floatingWindowStack == null) {
            this.m_floatingWindowStack = new ArrayList<FloatingDiv>();
        }
        return this.m_floatingWindowStack;
    }

    void internalAddPendingBuild(@Nonnull NodeBase n) {
        this.m_pendingBuildSet.add(n);
    }

    public void internalFullBuild() throws Exception {
        this.m_phase = PagePhase.BUILD;
        this.m_pendingBuildSet.clear();
        this.buildSubTree(this.getBody());
        this.rebuildLoop();
    }

    public void internalDeltaBuild() throws Exception {
        this.m_phase = PagePhase.BUILD;
        this.m_pendingBuildSet.clear();
        this.buildChangedTree(this.getBody());
        this.rebuildLoop();
    }

    private void rebuildLoop() throws Exception {
        int tries = 0;
        while (this.m_pendingBuildSet.size() > 0) {
            if (tries++ > 10) {
                throw new IllegalStateException("Internal: building the tree failed after " + tries + " attempts: the tree keeps changing every build....");
            }
            NodeBase[] todo = this.m_pendingBuildSet.toArray(new NodeBase[this.m_pendingBuildSet.size()]);
            this.m_pendingBuildSet.clear();
            for (NodeBase nd : todo) {
                this.buildSubTree(nd);
            }
        }
    }

    private void buildSubTree(@Nonnull NodeBase nd) throws Exception {
        nd.build();
        this.m_pendingBuildSet.remove(nd);
        if (!(nd instanceof NodeContainer)) {
            return;
        }
        NodeContainer nc = (NodeContainer)nd;
        List<NodeBase> ichl = nc.internalGetChildren();
        int len = ichl.size();
        for (int i = 0; i < len; ++i) {
            this.buildSubTree(ichl.get(i));
        }
    }

    private void buildChangedTree(@Nonnull NodeBase nd) throws Exception {
        this.m_pendingBuildSet.remove(nd);
        if (!(nd instanceof NodeContainer)) {
            nd.build();
            return;
        }
        NodeContainer nc = (NodeContainer)nd;
        if (nc.childHasUpdates() && nc.internalGetOldChildren() == null) {
            nc.build();
            List<NodeBase> ichl = nc.internalGetChildren();
            int len = ichl.size();
            for (int i = 0; i < len; ++i) {
                this.buildChangedTree(ichl.get(i));
            }
        }
        if (nc.internalGetOldChildren() != null || nc.childHasUpdates() || nc.mustRenderChildrenFully()) {
            this.buildSubTree(nc);
        }
    }

    public void appendJS(@Nonnull CharSequence sq) {
        this.internalGetAppendJS().append(sq);
    }

    @Nullable
    public StringBuilder internalFlushAppendJS() {
        StringBuilder sb = this.m_appendJS;
        this.m_appendJS = null;
        return sb;
    }

    @Nonnull
    public StringBuilder internalGetAppendJS() {
        StringBuilder sb = this.m_appendJS;
        if (null == sb) {
            sb = this.m_appendJS = new StringBuilder(2048);
        }
        return sb;
    }

    public void openWindow(@Nonnull String windowURL, @Nullable WindowParameters wp) {
        if (windowURL == null || windowURL.length() == 0) {
            throw new IllegalArgumentException("Empty window URL");
        }
        String js = DomUtil.createOpenWindowJS(DomUtil.calculateURL(UIContext.getRequestContext(), windowURL), wp);
        this.appendJS(js);
    }

    @Deprecated
    public void openWindow(@Nonnull Class<? extends UrlPage> clz, @Nullable IPageParameters pp, @Nullable WindowParameters wp) {
        String js = DomUtil.createOpenWindowJS(clz, pp, wp);
        this.appendJS(js);
    }

    @Nullable
    public NodeBase getFocusComponent() {
        return this.m_focusComponent;
    }

    public void setFocusComponent(@Nullable NodeBase focusComponent) {
        this.m_focusComponent = focusComponent;
    }

    @Nonnull
    public ConversationContext getConversation() {
        ConversationContext cc = this.m_cc;
        if (cc == null) {
            throw new IllegalStateException("The conversational context is null??????");
        }
        cc.checkAttached();
        return cc;
    }

    @Nullable
    public ConversationContext internalGetConversation() {
        return this.m_cc;
    }

    public int getPageExceptionCount() {
        return this.m_pageExceptionCount;
    }

    public void setPageExceptionCount(int pageExceptionCount) {
        this.m_pageExceptionCount = pageExceptionCount;
    }

    public boolean isFullRenderCompleted() {
        return this.m_fullRenderCompleted;
    }

    public void setFullRenderCompleted(boolean fullRenderCompleted) {
        this.m_fullRenderCompleted = fullRenderCompleted;
    }

    public void internalShelve() throws Exception {
        if (this.m_shelved) {
            throw new IllegalStateException("Calling SHELVE on already-shelved page " + this);
        }
        this.m_shelved = true;
        this.getBody().internalShelve();
    }

    public void internalUnshelve() throws Exception {
        if (!this.m_shelved) {
            throw new IllegalStateException("Calling UNSHELVE on already-unshelved page " + this);
        }
        this.m_shelved = false;
        this.getBody().internalUnshelve();
    }

    public boolean isShelved() {
        return this.m_shelved;
    }

    void registerJavascriptStateChanged(@Nonnull NodeBase nodeBase) {
        this.m_javaScriptStateChangedSet.add(nodeBase);
    }

    @Nonnull
    public Set<NodeBase> internalGetJavaScriptStateChangedSet() {
        return this.m_javaScriptStateChangedSet;
    }

    @Nullable
    public StringBuilder internalFlushJavascriptStateChanges() throws Exception {
        if (this.m_javaScriptStateChangedSet.size() == 0) {
            return null;
        }
        ArrayList<NodeBase> todo = new ArrayList<NodeBase>(this.m_javaScriptStateChangedSet);
        StringBuilder sb = new StringBuilder(8192);
        JavascriptStmt stmt = new JavascriptStmt(sb);
        for (int count = 0; count < 10; ++count) {
            this.m_javaScriptStateChangedSet.clear();
            for (NodeBase nb : todo) {
                nb.renderJavascriptDelta(stmt);
                stmt.next();
            }
            if (this.m_javaScriptStateChangedSet.size() == 0) {
                return sb;
            }
            todo.clear();
            todo.addAll(this.m_javaScriptStateChangedSet);
            this.m_javaScriptStateChangedSet.clear();
        }
        throw new IllegalStateException("Javascript state keeps changing: set is " + todo);
    }

    public void setPopIn(@Nullable NodeContainer pin) {
        if (this.m_currentPopIn != null && this.m_currentPopIn != pin) {
            NodeContainer old = this.m_currentPopIn;
            this.m_currentPopIn = null;
            old.remove();
        }
        this.m_currentPopIn = pin;
    }

    public void clearPopIn() {
        if (this.m_currentPopIn != null) {
            NodeContainer old = this.m_currentPopIn;
            this.m_currentPopIn = null;
            old.remove();
        }
    }

    @Nullable
    public NodeContainer getPopIn() {
        return this.m_currentPopIn;
    }

    public String toString() {
        return "Page[" + this.getBody().getClass().getName() + "]";
    }

    public boolean isDestroyed() {
        return this.m_cc != null && !this.m_cc.isValid();
    }

    public boolean isInjected() {
        return this.m_injected;
    }

    public void setInjected(boolean injected) {
        this.m_injected = injected;
    }

    @Nonnull
    public List<QContextContainer> getAllContextContainers() {
        return this.getConversation().getAllContextContainers();
    }

    @Nonnull
    public QContextContainer getContextContainer(@Nonnull String key) {
        return this.getConversation().getContextContainer(key);
    }

    public boolean isAllowVectorGraphics() {
        return this.m_allowVectorGraphics;
    }

    public void setAllowVectorGraphics(boolean allowVectorGraphics) {
        this.m_allowVectorGraphics = allowVectorGraphics;
    }

    public boolean isRenderAsXHTML() {
        return this.m_renderAsXHTML;
    }

    public void setRenderAsXHTML(boolean renderAsXHTML) {
        this.m_renderAsXHTML = renderAsXHTML;
    }

    public void calculateDefaultFocus(NodeBase node) {
        this.m_defaultFocusSource = node;
    }

    @Nullable
    public NodeBase getDefaultFocusSource() {
        return this.m_defaultFocusSource;
    }

    public void addAfterRequestListener(@Nonnull IExecute x) {
        if (this.m_afterRequestListenerList.size() == 0) {
            this.m_afterRequestListenerList = new ArrayList<IExecute>();
        }
        this.m_afterRequestListenerList.add(x);
    }

    public void addBeforeRequestListener(@Nonnull IExecute x) {
        if (this.m_beforeRequestListenerList.size() == 0) {
            this.m_beforeRequestListenerList = new ArrayList<IExecute>();
        }
        this.m_beforeRequestListenerList.add(x);
    }

    public void callRequestFinished() throws Exception {
        for (IExecute x : this.m_afterRequestListenerList) {
            x.execute();
        }
    }

    public void callRequestStarted() throws Exception {
        for (IExecute x : this.m_beforeRequestListenerList) {
            x.execute();
        }
    }

    <T> void addNotificationListener(NotificationListener<T> newl) {
        for (NotificationListener<?> nl : this.m_notificationListenerList) {
            if (nl.getWhom() != newl.getWhom() || nl.getEventClass() != newl.getEventClass()) continue;
            return;
        }
        this.m_notificationListenerList.add(newl);
    }

    <T> void notifyPage(@Nonnull T eventClass) throws Exception {
        this.buildSubTree(this.getBody());
        Class<?> clz = eventClass.getClass();
        for (NotificationListener<?> nl : this.m_notificationListenerList) {
            if (!nl.getEventClass().isAssignableFrom(clz)) continue;
            INotificationListener<?> listener = nl.getListener();
            listener.notify(eventClass);
        }
    }

    @DefaultNonNull
    public static class NotificationListener<T> {
        private final Class<T> m_eventClass;
        private final NodeBase m_whom;
        private final INotificationListener<T> m_listener;

        public NotificationListener(Class<T> eventClass, NodeBase whom, INotificationListener<T> listener) {
            this.m_eventClass = eventClass;
            this.m_whom = whom;
            this.m_listener = listener;
        }

        public Class<T> getEventClass() {
            return this.m_eventClass;
        }

        public NodeBase getWhom() {
            return this.m_whom;
        }

        public INotificationListener<T> getListener() {
            return this.m_listener;
        }
    }

    private static class IntRef {
        public int m_value;

        private IntRef() {
        }
    }
}

