/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.dom.html;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.html.IClickBase;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IHasModifiedIndication;
import to.etc.domui.dom.html.INodeVisitor;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.RadioGroup;
import to.etc.domui.util.DomUtil;

public class RadioButton<T>
extends NodeBase
implements IHasModifiedIndication {
    private RadioGroup<T> m_radioGroup;
    private boolean m_checked;
    private boolean m_disabled;
    private boolean m_readOnly;
    private T m_buttonValue;
    private boolean m_modifiedByUser;

    public RadioButton() {
        super("input");
    }

    public RadioButton(@Nonnull RadioGroup<T> g) {
        super("input");
        this.m_radioGroup = g;
        g.addButton(this);
    }

    public RadioButton(@Nonnull RadioGroup<T> g, T value) {
        super("input");
        this.m_radioGroup = g;
        this.m_buttonValue = value;
        g.addButton(this);
    }

    public RadioButton(T value) {
        super("input");
        this.m_buttonValue = value;
    }

    @Override
    public void visit(INodeVisitor v) throws Exception {
        v.visitRadioButton(this);
    }

    public void setGroup(@Nonnull RadioGroup<T> g) {
        if (this.m_radioGroup == g) {
            return;
        }
        if (this.m_radioGroup != null) {
            this.m_radioGroup.removeButton(this);
        }
        this.m_radioGroup = g;
        g.addButton(this);
        this.changed();
    }

    public RadioGroup<T> getGroup() {
        if (this.m_radioGroup == null) {
            this.m_radioGroup = this.findParent(RadioGroup.class);
            if (null == this.m_radioGroup) {
                throw new IllegalArgumentException("A RadioButton must be part of a RadioGroup");
            }
        }
        return this.m_radioGroup;
    }

    public String getName() {
        return this.getGroup().getName();
    }

    public T getButtonValue() {
        return this.m_buttonValue;
    }

    public void setButtonValue(T selectedValue) {
        this.m_buttonValue = selectedValue;
    }

    public boolean isChecked() {
        return this.m_checked;
    }

    void internalSetChecked(boolean on) {
        if (this.m_checked == on) {
            return;
        }
        this.m_checked = on;
        this.changed();
    }

    public void setChecked(boolean checked) {
        if (this.m_checked != checked) {
            this.changed();
        }
        this.m_checked = checked;
        RadioGroup<T> g = this.getGroup();
        if (this.m_checked) {
            g.internalSetValue(this.getButtonValue());
            for (RadioButton<T> rb : g.getButtonList()) {
                if (this == rb) continue;
                rb.setChecked(false);
            }
        } else if (g.getValue() == this.getButtonValue()) {
            g.internalSetValue(null);
        }
    }

    public boolean isDisabled() {
        return this.m_disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this.m_disabled != disabled) {
            this.changed();
        }
        this.m_disabled = disabled;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.m_readOnly != readOnly) {
            this.changed();
        }
        this.m_readOnly = readOnly;
    }

    @Override
    public boolean acceptRequestParameter(@Nonnull String[] values) {
        if (values == null || values.length != 1) {
            throw new IllegalStateException("RadioButton: expecting a single input value, not " + Arrays.toString(values));
        }
        String s = values[0].trim();
        boolean on = "y".equalsIgnoreCase(s);
        if (on == this.m_checked) {
            return false;
        }
        DomUtil.setModifiedFlag(this);
        this.m_checked = on;
        if (!on) {
            return true;
        }
        RadioGroup<T> g = this.getGroup();
        for (RadioButton<T> rb : g.getButtonList()) {
            super.selectionChangedTo(this);
        }
        g.internalSetValue(this.getButtonValue());
        return true;
    }

    @Override
    public void internalOnValueChanged() throws Exception {
        if (this.m_checked) {
            this.getGroup().internalOnValueChanged();
        }
    }

    private void selectionChangedTo(RadioButton<T> radioButton) {
        this.m_checked = radioButton == this;
    }

    @Override
    @Nullable
    public IClickBase<?> getClicked() {
        IClickBase<?> clicked = super.getClicked();
        if (null != clicked) {
            return clicked;
        }
        final IClicked c2 = (IClicked)this.getGroup().getClicked();
        if (c2 != null) {
            return new IClicked<RadioButton<T>>(){

                @Override
                public void clicked(@Nonnull RadioButton<T> clickednode) throws Exception {
                    c2.clicked(RadioButton.this.getGroup());
                }
            };
        }
        return c2;
    }

    @Override
    public boolean isModified() {
        return this.m_modifiedByUser;
    }

    @Override
    public void setModified(boolean as) {
        this.m_modifiedByUser = as;
    }
}

